/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.idealgasintegrals.bose;

import java.awt.Color;
import java.text.NumberFormat;
import org.opensourcephysics.controls.AbstractCalculation;
import org.opensourcephysics.controls.CalculationControl;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.numerics.Function;
import org.opensourcephysics.numerics.Integral;

public class ComputeBoseIntegralApp
extends AbstractCalculation
implements Function {
    PlotFrame plotFrame = new PlotFrame("T*", "\u03bc*", "Temperature Dependence of the Chemical Potential");
    double b = 1.0;
    double T = 1.0;
    double mu = -1.0;
    double x_low = 0.0;
    double x_high = 1000.0;
    int npoints = 0;
    double[] mua;
    double[] Ta;
    double tolerance = 0.001;
    int nmaxTrials = 1000;
    NumberFormat nf = NumberFormat.getInstance();

    ComputeBoseIntegralApp() {
        this.mua = new double[this.nmaxTrials];
        this.Ta = new double[this.nmaxTrials];
        this.plotFrame.setPreferredMinMaxX(0.0, 10.0);
        this.plotFrame.setAutoscaleX(true);
        this.nf.setMaximumFractionDigits(3);
        this.plotFrame.setMarkerColor(0, Color.RED);
        this.plotFrame.setXYColumnNames(0, "T*", "\u03bc*");
    }

    public void reset() {
        this.control.setValue("T*", 10.0);
        this.control.setValue("Guess for \u03bc*", -1.0);
        this.control.println("Calculated integral \t T* \t guess for \u03bc*");
        this.control.println("(= 1 if \u03bc* is correct)");
        this.npoints = 0;
    }

    public double evaluate(double d) {
        return Math.sqrt(d) / (Math.exp(this.b * (d - this.mu)) - 1.0);
    }

    public void calculate1() {
        double d = 0.1;
        while (d < 15.0) {
            double d2 = Math.exp(-1.0 / d);
            double d3 = Math.exp(-10.0 / d);
            double d4 = 1.0 + d2 + d3;
            double d5 = (d2 + 10.0 * d3) / d4;
            double d6 = d + 0.001;
            d2 = Math.exp(-1.0 / d6);
            d3 = Math.exp(-10.0 / d6);
            d4 = 1.0 + d2 + d3;
            double d7 = (d2 + 10.0 * d3) / d4;
            double d8 = (d7 - d5) / 0.001;
            this.plotFrame.append(0, d, d8);
            d += 0.1;
        }
    }

    public void calculate() {
        this.mu = this.control.getDouble("Guess for \u03bc*");
        this.T = this.control.getDouble("T*");
        this.b = 1.0 / this.T;
        double d = -this.b * this.mu;
        double d2 = d >= 0.0 && d < 0.1 ? Math.pow(this.b, -1.5) * 0.3828483920367534 * (-3.54 * Math.sqrt(d) + 2.612 + 1.46 * d - 0.104 * d * d + 0.00425 * d * d * d) : 0.432 * Integral.simpson(this, 0.0, this.x_high, 2, this.tolerance);
        this.control.println(String.valueOf(this.nf.format(d2)) + "\t \t" + this.T + "\t" + this.mu);
        this.plot();
    }

    public void accept() {
        this.mua[this.npoints] = this.mu;
        this.Ta[this.npoints] = this.T;
        ++this.npoints;
        if (this.npoints > this.nmaxTrials) {
            this.control.print("Too many points");
            System.exit(-1);
        }
        this.plot();
    }

    public void plot() {
        this.plotFrame.clearData();
        int n = 0;
        while (n < this.npoints) {
            this.plotFrame.append(0, this.Ta[n], this.mua[n]);
            ++n;
        }
        this.plotFrame.render();
    }

    public static void main(String[] stringArray) {
        CalculationControl calculationControl = CalculationControl.createApp(new ComputeBoseIntegralApp(), stringArray);
        calculationControl.addButton("accept", "Plot (\u03bc*,T*)");
    }
}

