/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.ising.ising2d;

import java.util.Arrays;
import org.opensourcephysics.display.Dataset;

public class AutoCorrelator {
    private int numberToSave;
    private double[] correlationArray;
    private double[] saveArray;
    private double aTotal;
    private double a2Total;
    private int time;
    private boolean isComputed = false;
    private Dataset dataset = new Dataset();

    public AutoCorrelator() {
        this.setNumberToSave(10);
        this.setupVaribles();
    }

    public AutoCorrelator(int n) {
        this.setNumberToSave(n);
        this.setupVaribles();
    }

    protected void setupArrays() {
        this.correlationArray = new double[this.numberToSave + 1];
        this.saveArray = new double[this.numberToSave];
        Arrays.fill(this.correlationArray, 0.0);
        Arrays.fill(this.saveArray, 0.0);
    }

    protected void setupVaribles() {
        this.time = 0;
        this.aTotal = 0.0;
        this.a2Total = 0.0;
        this.isComputed = false;
    }

    public void updateStatistics(double d) {
        ++this.time;
        int n = (this.time - 1) % this.numberToSave;
        if (this.time > this.numberToSave) {
            int n2 = n;
            int n3 = this.numberToSave;
            while (n3 >= 1) {
                int n4 = n3--;
                this.correlationArray[n4] = this.correlationArray[n4] + d * this.saveArray[n2];
                n2 = (n2 + 1) % this.numberToSave;
            }
        }
        this.saveArray[n] = d;
        this.aTotal += d;
        this.a2Total += d * d;
    }

    public void compute() {
        if (this.isComputed) {
            return;
        }
        double d = this.aTotal / (double)this.time;
        double d2 = this.a2Total / (double)this.time;
        double d3 = d * d;
        this.correlationArray[0] = d2 - d3;
        double d4 = 1.0 / ((double)this.time - (double)this.numberToSave);
        int n = 1;
        while (n <= this.numberToSave) {
            this.correlationArray[n] = (this.correlationArray[n] * d4 - d3) / this.correlationArray[0];
            ++n;
        }
        this.isComputed = true;
    }

    public Dataset getCorrelationDataset() {
        if (!this.isComputed) {
            this.compute();
        }
        this.dataset.clear();
        int n = 1;
        while (n <= this.numberToSave) {
            this.dataset.append(n, this.correlationArray[n]);
            ++n;
        }
        return this.dataset;
    }

    public double[] getCorrelationArray() {
        if (!this.isComputed) {
            this.compute();
        }
        return (double[])this.correlationArray.clone();
    }

    public void setNumberToSave(int n) {
        this.numberToSave = n;
        this.setupArrays();
    }

    public String toString() {
        if (!this.isComputed) {
            this.compute();
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n <= this.numberToSave) {
            stringBuffer.append(n);
            stringBuffer.append(":\t");
            stringBuffer.append(this.correlationArray[n]);
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }

    public void reset() {
        this.dataset.clear();
        this.setNumberToSave(10);
        this.setupVaribles();
    }
}

