/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.ising.ising2d;

import java.awt.Color;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display2d.CellLattice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ising2D
implements Drawable {
    public static final double criticalTemperature = 2.0 / Math.log(1.0 + Math.sqrt(2.0));
    public int[][] spin;
    public int L;
    public int N;
    public double J = 1.0;
    public double T;
    public double H;
    public double E;
    public double E_acc;
    public double E2_acc;
    public int M;
    public double M_acc;
    public double absM_acc;
    public double M2_acc;
    public int mcs;
    public int acceptedMoves;
    private CellLattice lattice;

    public void initialize(int n, double d, double d2) {
        this.L = n;
        this.N = this.L * this.L;
        this.T = d;
        this.H = d2;
        this.lattice = new CellLattice(this.L, this.L);
        this.lattice.setIndexedColor(0, Color.YELLOW);
        this.lattice.setIndexedColor(2, Color.BLUE);
        this.spin = new int[this.L][this.L];
        int n2 = 0;
        while (n2 < this.L) {
            int n3 = 0;
            while (n3 < this.L) {
                this.spin[n2][n3] = 1;
                ++n3;
            }
            ++n2;
        }
        this.M = this.N;
        this.E = -2.0 * this.J * (double)this.N - this.H * (double)this.M;
        this.resetData();
    }

    public void setTemperature(double d) {
        this.T = d;
    }

    public void setExternalField(double d) {
        this.E += this.H * (double)this.M - d * (double)this.M;
        this.H = d;
    }

    public double specificHeat() {
        int n = this.mcs == 0 ? 1 : this.mcs;
        double d = this.E2_acc / (double)n;
        double d2 = this.E_acc / (double)n;
        return (d - d2 * d2) / (this.T * this.T * (double)this.N);
    }

    public double susceptibility() {
        int n = this.mcs == 0 ? 1 : this.mcs;
        double d = this.M2_acc / (double)n;
        double d2 = this.absM_acc / (double)n;
        return (d - d2 * d2) / (this.T * (double)this.N);
    }

    public void resetData() {
        this.mcs = 0;
        this.E_acc = 0.0;
        this.E2_acc = 0.0;
        this.absM_acc = 0.0;
        this.M_acc = 0.0;
        this.M2_acc = 0.0;
        this.acceptedMoves = 0;
    }

    public void doOneMCStep() {
        int n = 0;
        while (n < this.N) {
            int n2;
            int n3 = (int)(Math.random() * (double)this.L);
            double d = 2.0 * this.J * (double)this.spin[n3][n2 = (int)(Math.random() * (double)this.L)] * (this.H + (double)this.spin[(n3 + 1) % this.L][n2] + (double)this.spin[(n3 - 1 + this.L) % this.L][n2] + (double)this.spin[n3][(n2 + 1) % this.L] + (double)this.spin[n3][(n2 - 1 + this.L) % this.L]);
            if (d <= 0.0 || Math.random() < Math.exp(-d / this.T)) {
                this.spin[n3][n2] = -this.spin[n3][n2];
                ++this.acceptedMoves;
                this.E += d;
                this.M += 2 * this.spin[n3][n2];
            }
            ++n;
        }
        this.accumulate_EM();
        ++this.mcs;
    }

    public void doOneWolffStep(double d) {
        HashMap<Integer, Integer> hashMap = this.growWolffCluster(d);
        int n = hashMap.size();
        int n2 = 0;
        while (n2 < n) {
            int n3 = hashMap.get(n2) % this.L;
            int n4 = hashMap.get(n2) / this.L;
            int n5 = this.spin[n3][n4];
            int[] nArray = this.spin[n3];
            int n6 = n4;
            nArray[n6] = nArray[n6] * -1;
            double d2 = (double)(2 * n5) * (this.J * (double)(this.spin[(n3 - 1 + this.L) % this.L][n4] + this.spin[(n3 + 1 + this.L) % this.L][n4] + this.spin[n3][(n4 - 1 + this.L) % this.L] + this.spin[n3][(n4 + 1 + this.L) % this.L]));
            this.M += -2 * n5;
            this.E += d2;
            ++n2;
        }
        this.accumulate_EM();
        ++this.mcs;
    }

    public HashMap<Integer, Integer> growWolffCluster(double d) {
        Random random = new Random();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>(100);
        boolean[] blArray = new boolean[this.N];
        int n = 0;
        int n2 = 0;
        int n3 = random.nextInt(this.L);
        int n4 = random.nextInt(this.L);
        int n5 = n3 + this.L * n4;
        int n6 = this.spin[n3][n4];
        hashMap.put(n2, n5);
        ++n;
        blArray[n5] = true;
        while (n2 < n) {
            int n7 = hashMap.get(n2);
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            int n8 = n7 % this.L;
            int n9 = n7 / this.L;
            arrayList.add(n8 + (n9 - 1 + this.L) % this.L * this.L);
            arrayList.add(n8 + (n9 + 1 + this.L) % this.L * this.L);
            arrayList.add((n8 - 1 + this.L) % this.L + n9 * this.L);
            arrayList.add((n8 + 1 + this.L) % this.L + n9 * this.L);
            blArray[n7] = true;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                boolean bl;
                int n10 = (Integer)iterator.next();
                boolean bl2 = blArray[n10];
                boolean bl3 = this.spin[n10 % this.L][n10 / this.L] == n6;
                boolean bl4 = bl = random.nextDouble() < d;
                if (bl2 || !bl3 || !bl || hashMap.containsValue(n10)) continue;
                hashMap.put(n, n10);
                ++n;
            }
            ++n2;
        }
        return hashMap;
    }

    public void accumulate_EM() {
        this.E_acc += this.E;
        this.E2_acc += this.E * this.E;
        this.M_acc += (double)this.M;
        this.absM_acc += (double)Math.abs(this.M);
        this.M2_acc += (double)(this.M * this.M);
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.lattice == null) {
            return;
        }
        int n = 0;
        while (n < this.L) {
            int n2 = 0;
            while (n2 < this.L) {
                this.lattice.setValue(n, n2, (byte)(this.spin[n][n2] + 1));
                ++n2;
            }
            ++n;
        }
        this.lattice.draw(drawingPanel, graphics);
    }
}

