/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.ising.ising2d;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.text.NumberFormat;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.OSPCombo;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.frames.DisplayFrame;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.ising.ising2d.Ising2D;
import org.opensourcephysics.stp.ising.ising2d.Ising2DControl;
import org.opensourcephysics.stp.ising.ising2d.Ising2DWRApp;

public class Ising2DApp
extends AbstractSimulation {
    Ising2D ising;
    DisplayFrame displayFrame = new DisplayFrame("Spin Configuration");
    DrawingPanel displayPanel;
    PlotFrame plotFrame = new PlotFrame("time", "E and M", "Thermodynamic Quantities");
    NumberFormat nf;
    double bondProbability;
    boolean metropolis = true;

    public Ising2DApp() {
        this.ising = new Ising2D();
        this.plotFrame.setPreferredMinMaxX(0.0, 10.0);
        this.plotFrame.setAutoscaleX(true);
        this.plotFrame.setAutoscaleY(true);
        this.displayFrame.addDrawable(this.ising);
        this.nf = NumberFormat.getInstance();
        this.nf.setMaximumFractionDigits(3);
        this.displayPanel = this.displayFrame.getDrawingPanel();
    }

    public void initialize() {
        this.plotFrame.setLineColor(0, Color.YELLOW);
        this.plotFrame.setLineColor(1, Color.BLUE);
        this.plotFrame.setMarkerColor(0, Color.YELLOW);
        this.plotFrame.setMarkerColor(1, Color.BLUE);
        this.ising.initialize(this.control.getInt("Length"), this.control.getDouble("Temperature"), this.control.getDouble("External field"));
        this.bondProbability = this.bondProbability(this.ising.J, this.ising.T);
        this.metropolis = this.control.getString("Dynamics").equals("Metropolis");
        this.displayPanel.setPreferredMinMax(-5.0, this.ising.L + 5, -5.0, this.ising.L + 5);
        this.control.clearMessages();
        this.zeroAverages();
        this.stopRunning();
    }

    public double bondProbability(double d, double d2) {
        return 1.0 - Math.exp(-2.0 * d / d2);
    }

    public void doStep() {
        if (this.metropolis) {
            this.ising.doOneMCStep();
        } else {
            this.ising.doOneWolffStep(this.bondProbability);
        }
        this.plotFrame.append(0, this.ising.mcs, (double)this.ising.M / (double)this.ising.N);
        this.plotFrame.append(1, this.ising.mcs, this.ising.E / (double)this.ising.N);
    }

    public void startRunning() {
        this.ising.setTemperature(this.control.getDouble("Temperature"));
        this.ising.setExternalField(this.control.getDouble("External field"));
    }

    public void stopRunning() {
        double d = this.ising.mcs == 0 ? 1.0 : 1.0 / (double)(this.ising.mcs * this.ising.N);
        this.control.println("mcs = " + this.ising.mcs);
        this.control.println("<E> = " + this.nf.format(this.ising.E_acc * d));
        this.control.println("Specific heat = " + this.nf.format(this.ising.specificHeat()));
        this.control.println("<M> = " + this.nf.format(this.ising.M_acc * d));
        this.control.println("<|M|>=" + this.nf.format(Math.abs(this.ising.absM_acc * d)));
        this.control.println("Susceptibility = " + this.nf.format(this.ising.susceptibility()));
        if (this.metropolis) {
            this.control.println("Acceptance ratio = " + this.nf.format((double)this.ising.acceptedMoves * d));
        }
        this.control.println();
    }

    public void reset() {
        this.control.setValue("Length", 32);
        this.control.setAdjustableValue("Temperature", this.nf.format(Ising2D.criticalTemperature));
        this.control.setAdjustableValue("External field", 0);
        OSPCombo oSPCombo = new OSPCombo(new String[]{"Metropolis", "Wolff"}, 0);
        this.control.setValue("Dynamics", oSPCombo);
        this.enableStepsPerDisplay(true);
    }

    public void zeroAverages() {
        this.control.clearMessages();
        this.ising.resetData();
        this.stopRunning();
        this.plotFrame.clearData();
        this.plotFrame.repaint();
    }

    public void switchGUI() {
        this.stopSimulation();
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = Ising2DApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(Ising2DApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                Ising2DWRApp ising2DWRApp = new Ising2DWRApp();
                Ising2DControl ising2DControl = new Ising2DControl(ising2DWRApp, ising2DWRApp.displayFrame, null);
                ising2DControl.getMainFrame().setDefaultCloseOperation(n);
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        ising2DControl.getMainFrame().addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                ising2DControl.loadXML(xMLControlElement, true);
                ising2DWRApp.customize();
                ising2DWRApp.initialize();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    void customize() {
        OSPFrame oSPFrame = this.getMainFrame();
        if (oSPFrame == null || !oSPFrame.isDisplayable()) {
            return;
        }
        JMenu jMenu = oSPFrame.getMenu("Display");
        JMenuItem jMenuItem = new JMenuItem("Switch GUI");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Ising2DApp.this.switchGUI();
            }
        });
        jMenu.add(jMenuItem);
        this.addChildFrame(this.displayFrame);
        this.addChildFrame(this.plotFrame);
    }

    public static void main(String[] stringArray) {
        Ising2DApp ising2DApp = new Ising2DApp();
        SimulationControl simulationControl = SimulationControl.createApp(ising2DApp, stringArray);
        simulationControl.addButton("zeroAverages", "Zero averages");
        ising2DApp.customize();
    }
}

