/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.ising.ising2d;

import java.awt.event.WindowListener;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.ejs.control.EjsSimulationControl;
import org.opensourcephysics.stp.ising.ising2d.Ising2DApp;
import org.opensourcephysics.stp.ising.ising2d.Ising2DControl;

public class Ising2DWRApp
extends Ising2DApp {
    public void switchGUI() {
        this.stopSimulation();
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = Ising2DWRApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(Ising2DWRApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                Ising2DApp ising2DApp = new Ising2DApp();
                SimulationControl simulationControl = SimulationControl.createApp(ising2DApp);
                simulationControl.setDefaultCloseOperation(n);
                simulationControl.addButton("zeroAverages", "Zero averages");
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        simulationControl.addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                simulationControl.loadXML(xMLControlElement, true);
                ising2DApp.customize();
                ising2DApp.initialize();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public void doStep() {
        super.doStep();
        this.stopRunning();
    }

    public void initialize() {
        super.initialize();
        GUIUtils.repaintOSPFrames();
    }

    public void stopRunning() {
        if (this.control == null) {
            return;
        }
        double d = this.ising.mcs == 0 ? 1.0 : 1.0 / (double)(this.ising.mcs * this.ising.N);
        ((EjsSimulationControl)this.control).getControl("meanE").setProperty("value", this.nf.format(this.ising.E_acc * d));
        ((EjsSimulationControl)this.control).getControl("meanM").setProperty("value", this.nf.format(this.ising.M_acc * d));
        ((EjsSimulationControl)this.control).getControl("C").setProperty("value", this.nf.format(this.ising.specificHeat()));
        ((EjsSimulationControl)this.control).getControl("susceptibility").setProperty("value", this.nf.format(this.ising.susceptibility()));
    }

    public static void main(String[] stringArray) {
        Ising2DWRApp ising2DWRApp = new Ising2DWRApp();
        new Ising2DControl(ising2DWRApp, ising2DWRApp.displayFrame, stringArray);
        ising2DWRApp.customize();
    }
}

