/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.ising.ising2d;

import java.awt.Color;
import java.awt.Graphics;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display2d.TriangularByteLattice;

public class IsingTriangularAnti
implements Drawable {
    public static final double criticalTemperature = 3.641;
    public int[][] spin;
    public int L;
    public int N;
    public double temperature = 3.641;
    public int mcs = 0;
    public int J = -1;
    public int energy;
    public double energyAccumulator = 0.0;
    public double energySquaredAccumulator = 0.0;
    public int magnetization = 0;
    public double magnetizationAccumulator = 0.0;
    public double magnetizationAbsAccumulator = 0.0;
    public double magnetizationSquaredAccumulator = 0.0;
    public int acceptedMoves = 0;
    private double[] w = new double[13];
    private TriangularByteLattice lattice;

    public void initialize(int n) {
        this.L = n;
        this.lattice = new TriangularByteLattice(this.L, this.L);
        this.lattice.setIndexedColor(0, Color.red);
        this.lattice.setIndexedColor(2, Color.blue);
        this.spin = new int[this.L][this.L];
        this.N = this.L * this.L;
        int n2 = 0;
        while (n2 < this.L) {
            int n3 = 0;
            while (n3 < this.L) {
                this.spin[n2][n3] = 1;
                ++n3;
            }
            ++n2;
        }
        this.magnetization = this.N;
        this.energy = -3 * this.J * this.N;
        this.resetData();
        this.w[12] = Math.exp(-12.0 / this.temperature);
        this.w[8] = Math.exp(-8.0 / this.temperature);
        this.w[4] = Math.exp(-4.0 / this.temperature);
    }

    public double magnetizationAverage() {
        return this.magnetizationAbsAccumulator / (double)this.mcs;
    }

    public double specificHeat() {
        double d = this.energySquaredAccumulator / (double)this.mcs;
        double d2 = this.energyAccumulator / (double)this.mcs;
        double d3 = d - d2 * d2;
        return (d3 /= this.temperature * this.temperature) / (double)this.N;
    }

    public double susceptibility() {
        double d = this.magnetizationSquaredAccumulator / (double)this.mcs;
        return (d - Math.pow(this.magnetizationAverage(), 2.0)) / (this.temperature * (double)this.N);
    }

    public void resetData() {
        this.mcs = 0;
        this.energyAccumulator = 0.0;
        this.energySquaredAccumulator = 0.0;
        this.magnetizationAccumulator = 0.0;
        this.magnetizationAbsAccumulator = 0.0;
        this.magnetizationSquaredAccumulator = 0.0;
        this.acceptedMoves = 0;
    }

    public void doOneMCStep() {
        int n = 0;
        while (n < this.N) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7 = (int)(Math.random() * (double)this.L);
            int n8 = 2 * this.J * this.spin[n7][n6 = (int)(Math.random() * (double)this.L)] * (this.spin[n5 = (n7 + 1) % this.L][n6] + this.spin[n4 = (n7 - 1 + this.L) % this.L][n6] + this.spin[n7][n3 = (n6 + 1) % this.L] + this.spin[n7][n2 = (n6 - 1 + this.L) % this.L] + this.spin[n5][n2] + this.spin[n4][n3]);
            if (n8 <= 0 || this.w[n8] > Math.random()) {
                this.spin[n7][n6] = -this.spin[n7][n6];
                ++this.acceptedMoves;
                this.energy += n8;
                this.magnetization += 2 * this.spin[n7][n6];
            }
            ++n;
        }
        this.energyAccumulator += (double)this.energy;
        this.energySquaredAccumulator += (double)(this.energy * this.energy);
        this.magnetizationAccumulator += (double)this.magnetization;
        this.magnetizationAbsAccumulator += (double)Math.abs(this.magnetization);
        this.magnetizationSquaredAccumulator += (double)(this.magnetization * this.magnetization);
        ++this.mcs;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.lattice == null) {
            return;
        }
        int n = 0;
        while (n < this.L) {
            int n2 = 0;
            while (n2 < this.L) {
                this.lattice.setCell((n + n2 / 2) % this.L, n2, (byte)(this.spin[n][n2] + 1));
                ++n2;
            }
            ++n;
        }
        this.lattice.draw(drawingPanel, graphics);
    }
}

