/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.ising.ising2d;

import java.text.NumberFormat;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.ControlUtils;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.ising.ising2d.IsingTriangularAnti;

public class IsingTriangularAntiApp
extends AbstractSimulation {
    IsingTriangularAnti ising;
    DrawingPanel drawingPanel;
    DrawingFrame drawingFrame;
    DrawingFrame plottingFrame;
    PlotFrame plotFrame = new PlotFrame("time", "E and M", "Thermodynamic Quantities");
    NumberFormat nf;

    public IsingTriangularAntiApp() {
        this.ising = new IsingTriangularAnti();
        this.plotFrame.setAutoscaleX(true);
        this.plotFrame.setAutoscaleY(true);
        this.drawingPanel = new DrawingPanel();
        this.drawingPanel.addDrawable(this.ising);
        this.drawingFrame = new DrawingFrame("Spin Configuration", this.drawingPanel);
        this.nf = NumberFormat.getInstance();
        this.nf.setMaximumFractionDigits(3);
    }

    public void initialize() {
        this.ising.temperature = this.control.getDouble("temperature");
        this.ising.initialize(this.control.getInt("L"));
        this.ising.resetData();
        this.plotFrame.clearData();
        this.plotFrame.repaint();
        this.drawingPanel.setPreferredMinMax(-5.0, this.ising.L + 5, -5.0, this.ising.L + 5);
        this.drawingPanel.repaint();
        this.control.clearMessages();
    }

    public void doStep() {
        this.ising.doOneMCStep();
        this.plotFrame.append(0, this.ising.mcs, (double)this.ising.magnetization * 1.0 / (double)this.ising.N);
        this.plotFrame.append(1, this.ising.mcs, (double)this.ising.energy * 1.0 / (double)this.ising.N);
        this.drawingPanel.repaint();
    }

    public void stop() {
        double d = 1.0 / (double)(this.ising.mcs * this.ising.N);
        this.control.println("mcs = " + this.ising.mcs);
        this.control.println("acceptance ratio = " + ControlUtils.f2((double)this.ising.acceptedMoves * d));
        this.control.println("<E> = " + ControlUtils.f3(this.ising.energyAccumulator * d));
        this.control.println("Specific heat = " + ControlUtils.f3(this.ising.specificHeat()));
        this.control.println("<M> = " + ControlUtils.f3(this.ising.magnetizationAccumulator * d));
        this.control.println("Susceptibility = " + ControlUtils.f3(this.ising.susceptibility()));
    }

    public void reset() {
        this.control.setValue("L", 32);
        this.control.setAdjustableValue("temperature", 4.0);
        this.initialize();
        this.enableStepsPerDisplay(true);
    }

    public static void main(String[] stringArray) {
        IsingTriangularAntiApp isingTriangularAntiApp = new IsingTriangularAntiApp();
        SimulationControl simulationControl = new SimulationControl(isingTriangularAntiApp);
        simulationControl.setTitle("Anti-Ferromagnetic Ising Model on a Hexagonal Lattice");
        isingTriangularAntiApp.setControl(simulationControl);
    }
}

