/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.ising.ising2d;

import java.text.NumberFormat;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.frames.DisplayFrame;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.ising.ising2d.LatGas2D;

public class LatGas2DApp
extends AbstractSimulation {
    LatGas2D ising;
    DisplayFrame displayFrame = new DisplayFrame("Particle Configuration");
    PlotFrame plotFrame = new PlotFrame("time", "E/N", "Thermodynamic Quantities");
    NumberFormat nf;
    double bondProbability;
    boolean metropolis = true;

    public LatGas2DApp() {
        this.ising = new LatGas2D();
        this.plotFrame.setPreferredMinMaxX(0.0, 10.0);
        this.plotFrame.setAutoscaleX(true);
        this.plotFrame.setAutoscaleY(true);
        this.displayFrame.addDrawable(this.ising);
        this.nf = NumberFormat.getInstance();
        this.nf.setMaximumFractionDigits(3);
    }

    public void initialize() {
        this.ising.initialize(this.control.getInt("Length"), this.control.getDouble("Temperature"), this.control.getInt("Number of particles"));
        this.ising.g = this.control.getDouble("Gravitational field");
        this.displayFrame.setPreferredMinMax(-5.0, this.ising.L + 5, -5.0, this.ising.L + 5);
        this.control.clearMessages();
    }

    public void doStep() {
        this.ising.setTemperature(this.control.getDouble("Temperature"));
        this.ising.setField(this.control.getDouble("Gravitational field"));
        this.ising.doOneMCStep();
        this.plotFrame.append(1, this.ising.mcs, this.ising.E / (double)this.ising.N);
    }

    public void stopRunning() {
        double d = this.ising.mcs == 0 ? 1.0 : 1.0 / (double)(this.ising.mcs * this.ising.N);
        this.control.println("mcs = " + this.ising.mcs);
        this.control.println("<E/N> = " + this.nf.format(this.ising.E_acc * d / (double)this.ising.N));
        this.control.println("Specific heat = " + this.nf.format(this.ising.specificHeat()));
        this.control.println("Acceptance ratio = " + this.nf.format((double)this.ising.acceptedMoves * d));
        this.control.println();
    }

    public void reset() {
        this.control.setValue("Length", 32);
        this.control.setValue("Number of particles", 512);
        this.control.setAdjustableValue("Temperature", this.nf.format(LatGas2D.criticalTemperature));
        this.control.setAdjustableValue("Gravitational field", 0);
        this.enableStepsPerDisplay(true);
    }

    public void zeroAverages() {
        this.control.clearMessages();
        this.ising.resetData();
        this.plotFrame.clearData();
        this.plotFrame.repaint();
    }

    void customize() {
        OSPFrame oSPFrame = this.getMainFrame();
        if (oSPFrame == null || !oSPFrame.isDisplayable()) {
            return;
        }
        this.addChildFrame(this.displayFrame);
        this.addChildFrame(this.plotFrame);
    }

    public static void main(String[] stringArray) {
        LatGas2DApp latGas2DApp = new LatGas2DApp();
        SimulationControl simulationControl = SimulationControl.createApp(latGas2DApp, stringArray);
        simulationControl.addButton("zeroAverages", "Zero averages");
        latGas2DApp.customize();
    }
}

