/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.ising.wanglandau;

public class Thermodynamics {
    static double logZ(int n, double[] dArray, double d) {
        double d2 = 0.0;
        int n2 = -2 * n;
        while (n2 <= 2 * n) {
            d2 = Math.max(d2, dArray[n2 + 2 * n] - d * (double)n2);
            n2 += 4;
        }
        double d3 = 0.0;
        int n3 = -2 * n;
        while (n3 <= 2 * n) {
            d3 += Math.exp(dArray[n3 + 2 * n] - d * (double)n3 - d2);
            n3 += 4;
        }
        return Math.log(d3) + d2;
    }

    static double heatCapacity(int n, double[] dArray, double d) {
        double d2 = Thermodynamics.logZ(n, dArray, d);
        double d3 = 0.0;
        double d4 = 0.0;
        int n2 = -2 * n;
        while (n2 <= 2 * n) {
            if (dArray[n2 + 2 * n] != 0.0) {
                d3 += (double)n2 * Math.exp(dArray[n2 + 2 * n] - d * (double)n2 - d2);
                d4 += (double)(n2 * n2) * Math.exp(dArray[n2 + 2 * n] - d * (double)n2 - d2);
            }
            n2 += 4;
        }
        return (d4 - d3 * d3) * d * d;
    }
}

