/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.ising.wanglandau;

import java.awt.Color;
import java.text.NumberFormat;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.ising.wanglandau.Thermodynamics;

public class WangLandauApp
extends AbstractSimulation {
    PlotFrame histogramFrame = new PlotFrame("E", "H(E)", "Histogram");
    PlotFrame densityFrame = new PlotFrame("E", "ln g(E)", "Density of States");
    PlotFrame heatFrame = new PlotFrame("T", "C(T)", "Heat Capacity");
    PlotFrame pEnergyFrame = new PlotFrame("E", "P(E)", "Energy Distribution");
    int mcs;
    int L;
    int N;
    int E;
    int iterations;
    double[] g;
    int[] H;
    int[] spin;
    double f;

    int sumNeighbors(int n) {
        int n2 = n - this.L;
        int n3 = n + this.L;
        int n4 = n - 1;
        int n5 = n + 1;
        if (n2 < 0) {
            n2 += this.N;
        }
        if (n3 >= this.N) {
            n3 -= this.N;
        }
        if (n % this.L == 0) {
            n4 += this.L;
        }
        if (n5 % this.L == 0) {
            n5 -= this.L;
        }
        return this.spin[n2] + this.spin[n3] + this.spin[n4] + this.spin[n5];
    }

    public void variable_initialize() {
        this.mcs = 0;
        this.N = this.L * this.L;
        this.f = Math.exp(1.0);
        this.iterations = 0;
        this.spin = new int[this.N];
        int n = 0;
        while (n < this.N) {
            this.spin[n] = Math.random() < 0.5 ? 1 : -1;
            ++n;
        }
        this.g = new double[4 * this.N + 1];
        this.H = new int[4 * this.N + 1];
        n = 0;
        while (n <= 4 * this.N) {
            this.g[n] = 0.0;
            this.H[n] = 0;
            ++n;
        }
        this.E = 0;
        n = 0;
        while (n < this.N) {
            this.E += -this.spin[n] * this.sumNeighbors(n);
            ++n;
        }
        this.E /= 2;
        this.E += 2 * this.N;
    }

    void flipSpins() {
        int n = 0;
        while (n < this.N) {
            int n2 = (int)((double)this.N * Math.random());
            int n3 = 2 * this.spin[n2] * this.sumNeighbors(n2);
            if (Math.random() < Math.exp(this.g[this.E] - this.g[this.E + n3])) {
                this.spin[n2] = -this.spin[n2];
                this.E += n3;
            }
            int n4 = this.E;
            this.g[n4] = this.g[n4] + Math.log(this.f);
            int n5 = this.E;
            this.H[n5] = this.H[n5] + 1;
            ++n;
        }
    }

    boolean isFlat() {
        int n = 0;
        double d = 0.0;
        int n2 = 0;
        while (n2 <= 4 * this.N) {
            if (this.H[n2] > 0) {
                n += this.H[n2];
                d += 1.0;
            }
            n2 += 4;
        }
        n2 = 0;
        while (n2 <= 4 * this.N) {
            if (this.H[n2] > 0 && (double)this.H[n2] < 0.8 * (double)n / d) {
                return false;
            }
            n2 += 4;
        }
        return true;
    }

    public void doStep() {
        double d = 1.0 / this.control.getDouble("T for P(E)");
        int n = this.mcs + Math.max(100000 / this.N, 1);
        while (this.mcs < n) {
            this.flipSpins();
            ++this.mcs;
        }
        this.histogramFrame.clearData();
        this.densityFrame.clearData();
        this.pEnergyFrame.clearData();
        double d2 = 0.0;
        int n2 = 0;
        while (n2 <= 4 * this.N) {
            if (this.g[n2] > 0.0) {
                this.densityFrame.append(0, n2 - 2 * this.N, this.g[n2] - this.g[0]);
                this.histogramFrame.append(0, n2 - 2 * this.N, this.H[n2]);
                d2 += Math.exp(this.g[n2] - this.g[0]) * Math.exp(-d * (double)(n2 - 2 * this.N));
            }
            n2 += 4;
        }
        this.histogramFrame.setMessage("mcs = " + this.mcs);
        n2 = 0;
        while (n2 <= 4 * this.N) {
            if (this.g[n2] > 0.0) {
                this.pEnergyFrame.append(0, n2 - 2 * this.N, Math.exp(this.g[n2] - this.g[0]) * Math.exp(-d * (double)(n2 - 2 * this.N)) / d2);
            }
            n2 += 4;
        }
        this.heatFrame.clearData();
        double d3 = 0.5;
        while (d3 < 6.0) {
            this.heatFrame.append(0, d3, Thermodynamics.heatCapacity(this.N, this.g, 1.0 / d3) / (double)this.N);
            d3 += 0.1;
        }
        d3 = 1.9;
        while (d3 < 2.7) {
            this.heatFrame.append(0, d3, Thermodynamics.heatCapacity(this.N, this.g, 1.0 / d3) / (double)this.N);
            d3 += 0.02;
        }
        if (this.isFlat() && this.f > 1.0001) {
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(4);
            this.f = Math.sqrt(this.f);
            this.control.println("mcs = " + this.mcs);
            this.control.println("iteration = " + this.iterations);
            this.control.println("f = " + numberFormat.format(this.f));
            ++this.iterations;
            int n3 = 0;
            while (n3 <= 4 * this.N) {
                this.H[n3] = 0;
                n3 += 4;
            }
        }
    }

    public void initialize() {
        this.L = this.control.getInt("L");
        this.variable_initialize();
        this.histogramFrame.clearData();
        this.densityFrame.clearData();
        this.heatFrame.clearData();
        this.control.clearMessages();
    }

    public void reset() {
        this.control.setValue("L", 16);
        this.control.setAdjustableValue("T for P(E)", 2.5);
        this.variable_initialize();
        this.enableStepsPerDisplay(true);
    }

    public WangLandauApp() {
        this.histogramFrame.setPreferredMinMaxY(0.0, 10000.0);
        this.histogramFrame.setAutoscaleY(true);
        this.densityFrame.setMarkerColor(0, Color.blue);
        this.densityFrame.setPreferredMinMaxY(0.0, 10000.0);
        this.densityFrame.setAutoscaleY(true);
        this.heatFrame.setMarkerColor(0, Color.red);
        this.heatFrame.setPreferredMinMax(0.5, 6.0, 0.0, 1000.0);
        this.heatFrame.setAutoscaleX(true);
        this.heatFrame.setAutoscaleY(true);
        this.heatFrame.setMarkerShape(0, 0);
        this.heatFrame.getDataset(0).setSorted(true);
        this.heatFrame.setConnected(true);
    }

    public static void main(String[] stringArray) {
        SimulationControl.createApp(new WangLandauApp(), stringArray);
    }
}

