/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.isinglg;

import java.awt.Color;
import org.opensourcephysics.frames.LatticeFrame;
import org.opensourcephysics.numerics.PBC;

public class IsingLG2 {
    public static final double criticalTemperature = 2.0 / Math.log(1.0 + Math.sqrt(2.0));
    public int L = 32;
    public int N = this.L * this.L;
    public double temperature = criticalTemperature;
    public double chemicalPotentialLeft;
    public double chemicalPotentialRight;
    public int mcs = 0;
    public int nLeft;
    public int nRight;
    public int np;
    public int acceptedMoves = 0;
    private double[][][] w = new double[9][2][2];
    public LatticeFrame lattice;
    public int[] x;
    public int[] y;
    public int[] nnx;
    public int[] nny;

    public IsingLG2() {
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[2] = -1;
        this.nnx = nArray;
        int[] nArray2 = new int[4];
        nArray2[1] = 1;
        nArray2[3] = -1;
        this.nny = nArray2;
    }

    public void initialize(int n, LatticeFrame latticeFrame) {
        this.lattice = latticeFrame;
        this.L = n;
        this.N = n * n;
        this.lattice.resizeLattice(n + 2, n);
        this.lattice.setIndexedColor(1, Color.blue);
        this.lattice.setIndexedColor(0, Color.yellow);
        this.np = this.nLeft + this.nRight;
        this.x = new int[this.np];
        this.y = new int[this.np];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.nLeft) {
            do {
                n3 = (int)(Math.random() * (double)n);
            } while (this.lattice.getValue(n2 = 1 + (int)(Math.random() * 0.5 * (double)n), n3) == 1);
            this.x[n4] = n2;
            this.y[n4] = n3;
            ++n4;
            this.lattice.setValue(n2, n3, 1);
            ++n5;
        }
        n5 = 0;
        while (n5 < this.nRight) {
            do {
                n3 = (int)(Math.random() * (double)n);
            } while (this.lattice.getValue(n2 = 1 + n / 2 + (int)(Math.random() * 0.5 * (double)n), n3) == 1);
            this.x[n4] = n2;
            this.y[n4] = n3;
            ++n4;
            this.lattice.setValue(n2, n3, 1);
            ++n5;
        }
        this.resetData();
        this.setBoltzmannArrays();
    }

    public void setBoltzmannArrays() {
        int n = 0;
        while (n < 9) {
            this.w[n][0][0] = Math.exp((double)(-(n - 4)) / this.temperature);
            this.w[n][1][0] = Math.exp(-((double)(n - 4) + (this.chemicalPotentialLeft - this.chemicalPotentialRight)) / this.temperature);
            this.w[n][0][1] = Math.exp(-((double)(n - 4) + (this.chemicalPotentialRight - this.chemicalPotentialLeft)) / this.temperature);
            this.w[n][1][1] = Math.exp((double)(-(n - 4)) / this.temperature);
            ++n;
        }
    }

    public void resetData() {
        this.mcs = 0;
        this.acceptedMoves = 0;
    }

    public void doOneMCStep() {
        int n = 0;
        while (n < this.np) {
            int n2 = (int)(Math.random() * (double)this.np);
            int n3 = (int)(Math.random() * 4.0);
            int n4 = this.x[n2] + this.nnx[n3];
            int n5 = PBC.position(this.y[n2] + this.nny[n3], this.L);
            if (n4 > 0 && n4 < this.L + 1 && this.lattice.getValue(n4, n5) == 0) {
                this.lattice.setValue(this.x[n2], this.y[n2], 0);
                int n6 = 4 - (this.lattice.getValue(n4 + 1, n5) + this.lattice.getValue(n4 - 1, n5) + this.lattice.getValue(n4, (n5 + 1) % this.L) + this.lattice.getValue(n4, (n5 - 1 + this.L) % this.L));
                n6 += this.lattice.getValue(this.x[n2] + 1, this.y[n2]) + this.lattice.getValue(this.x[n2] - 1, this.y[n2]) + this.lattice.getValue(this.x[n2], (this.y[n2] + 1) % this.L) + this.lattice.getValue(this.x[n2], (this.y[n2] - 1 + this.L) % this.L);
                this.lattice.setValue(this.x[n2], this.y[n2], 1);
                int n7 = 2 * (this.x[n2] - 1) / this.L;
                int n8 = 2 * (n4 - 1) / this.L;
                if (this.w[n6][n7][n8] > Math.random()) {
                    this.lattice.setValue(this.x[n2], this.y[n2], 0);
                    this.lattice.setValue(n4, n5, 1);
                    this.x[n2] = n4;
                    this.y[n2] = n5;
                    ++this.acceptedMoves;
                    this.nRight += n8 - n7;
                    this.nLeft -= n8 - n7;
                }
            }
            ++n;
        }
        ++this.mcs;
    }
}

