/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.isinglg;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.frames.LatticeFrame;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.isinglg.IsingLG2;
import org.opensourcephysics.stp.isinglg.IsingLG2Control;
import org.opensourcephysics.stp.isinglg.IsingLG2WRApp;

public class IsingLG2App
extends AbstractSimulation {
    IsingLG2 ising = new IsingLG2();
    LatticeFrame displayFrame = new LatticeFrame("Ising Model");
    PlotFrame plotFrame = new PlotFrame("time", "nLeft and nRight", "Number of Particles");

    public IsingLG2App() {
        this.plotFrame.setXYColumnNames(0, "mcs", "nLeft");
        this.plotFrame.setXYColumnNames(1, "mcs", "nRight");
        this.plotFrame.setMarkerColor(0, Color.green);
        this.plotFrame.setMarkerColor(1, Color.magenta);
        this.plotFrame.setPreferredMinMax(0.0, 10.0, 0.0, 10.0);
        this.plotFrame.setAutoscaleX(true);
        this.plotFrame.setAutoscaleY(true);
    }

    public void initialize() {
        int n = this.control.getInt("L");
        this.ising.temperature = this.control.getDouble("temperature");
        this.ising.chemicalPotentialLeft = this.control.getDouble("left chemical potential");
        this.ising.chemicalPotentialRight = this.control.getDouble("right chemical potential");
        this.ising.nLeft = (int)(0.5 * (double)n * (double)n * this.control.getDouble("density of particles on left"));
        this.ising.nRight = (int)(0.5 * (double)n * (double)n * this.control.getDouble("density of particles on right"));
        this.ising.initialize(n, this.displayFrame);
        this.control.clearMessages();
        this.stopRunning();
    }

    public void doStep() {
        this.ising.doOneMCStep();
        this.plotFrame.append(0, this.ising.mcs, this.ising.nLeft);
        this.plotFrame.append(1, this.ising.mcs, this.ising.nRight);
    }

    public void stopRunning() {
        this.control.println("mcs = " + this.ising.mcs);
        this.control.println("Number of particles in the left = " + this.ising.nLeft);
        this.control.println("Number of particles in the right = " + this.ising.nRight);
        this.control.println();
    }

    public void startRunning() {
        this.ising.temperature = this.control.getDouble("temperature");
        this.ising.chemicalPotentialLeft = this.control.getDouble("left chemical potential");
        this.ising.chemicalPotentialRight = this.control.getDouble("right chemical potential");
        this.ising.setBoltzmannArrays();
    }

    public void reset() {
        this.control.setValue("L", 32);
        this.control.setAdjustableValue("temperature", 1.0);
        this.control.setAdjustableValue("left chemical potential", -1);
        this.control.setAdjustableValue("right chemical potential", -2);
        this.control.setValue("density of particles on right", 0.04);
        this.control.setValue("density of particles on left", 0.2);
        this.enableStepsPerDisplay(true);
    }

    public void zeroAverages() {
        this.ising.resetData();
        this.plotFrame.clearData();
        GUIUtils.repaintOSPFrames();
        this.control.clearMessages();
    }

    public void switchGUI() {
        this.stopSimulation();
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = IsingLG2App.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(IsingLG2App.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                IsingLG2WRApp isingLG2WRApp = new IsingLG2WRApp();
                IsingLG2Control isingLG2Control = new IsingLG2Control(isingLG2WRApp, isingLG2WRApp.displayFrame, null);
                isingLG2Control.getMainFrame().setDefaultCloseOperation(n);
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        isingLG2Control.getMainFrame().addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                isingLG2Control.loadXML(xMLControlElement, true);
                isingLG2WRApp.customize();
                isingLG2WRApp.initialize();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    void customize() {
        OSPFrame oSPFrame = this.getMainFrame();
        if (oSPFrame == null || !oSPFrame.isDisplayable()) {
            return;
        }
        JMenu jMenu = oSPFrame.getMenu("Display");
        JMenuItem jMenuItem = new JMenuItem("Switch GUI");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IsingLG2App.this.switchGUI();
            }
        });
        jMenu.add(jMenuItem);
        this.addChildFrame(this.displayFrame);
        this.addChildFrame(this.plotFrame);
    }

    public static void main(String[] stringArray) {
        IsingLG2App isingLG2App = new IsingLG2App();
        SimulationControl simulationControl = SimulationControl.createApp(isingLG2App, stringArray);
        simulationControl.addButton("zeroAverages", "Zero averages");
        isingLG2App.customize();
    }
}

