/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.lj;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.OSPCombo;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.frames.DisplayFrame;
import org.opensourcephysics.frames.HistogramFrame;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.lj.LJfluid;
import org.opensourcephysics.stp.lj.LJfluidControl;
import org.opensourcephysics.stp.lj.LJfluidWRApp;
import org.opensourcephysics.stp.util.Rdf;

public class LJfluidApp
extends AbstractSimulation {
    LJfluid md = new LJfluid();
    PlotFrame pressureData = new PlotFrame("time", "PA/NkT", "Mean pressure");
    PlotFrame temperatureData = new PlotFrame("time", "temperature", "Temperature");
    HistogramFrame xVelocityHistogram = new HistogramFrame("vx", "H(vx)", "Velocity histogram");
    DisplayFrame displayFrame = new DisplayFrame("x", "y", "Lennard-Jones system");
    DrawingPanel displayPanel;
    PlotFrame grFrame = new PlotFrame("r", "g(r)", "Radial distribution function");
    Rdf gr = new Rdf();
    public double[] x;
    public double[] y;

    public LJfluidApp() {
        this.displayPanel = this.displayFrame.getDrawingPanel();
    }

    public void initialize() {
        String string = this.control.getString("number of particles");
        if (string == "64") {
            this.md.N = 64;
            this.md.nx = 8;
            this.md.ny = 8;
        } else if (string == "144") {
            this.md.N = 144;
            this.md.nx = 12;
            this.md.ny = 12;
        } else {
            this.md.N = 256;
            this.md.nx = 16;
            this.md.ny = 16;
        }
        this.x = new double[this.md.N];
        this.y = new double[this.md.N];
        this.md.initialKineticEnergy = this.control.getDouble("initial KE per particle");
        this.md.Lx = this.control.getDouble("L");
        this.md.Ly = this.control.getDouble("L");
        this.md.initialConfiguration = "rectangular";
        this.md.dt = this.control.getDouble("\u0394t");
        this.md.initialize();
        this.displayPanel.addDrawable(this.md);
        this.displayPanel.setPreferredMinMax(0.0, this.md.Lx, 0.0, this.md.Ly);
        this.xVelocityHistogram.setBinWidth(2.0 * this.md.initialKineticEnergy / (double)this.md.N);
        this.grFrame.setPreferredMinMaxX(0.0, 10.0);
        this.grFrame.setAutoscaleX(true);
        this.grFrame.setPreferredMinMaxY(0.0, 10.0);
        this.grFrame.setAutoscaleY(true);
        this.gr.initialize(this.md.Lx, this.md.Lx, 0.1);
    }

    public void doStep() {
        this.md.quench(this.control.getDouble("velocity rescaling"));
        double d = 0.0;
        this.md.step(this.xVelocityHistogram);
        int n = 0;
        while (n < this.md.N) {
            this.x[n] = this.md.state[4 * n];
            this.y[n] = this.md.state[4 * n + 2];
            d += this.md.state[4 * n + 1] * this.md.state[4 * n + 1] + this.md.state[4 * n + 3] * this.md.state[4 * n + 3];
            ++n;
        }
        this.gr.append(this.x, this.y);
        this.temperatureData.append(0, this.md.t, d /= 2.0 * (double)this.md.N);
        this.pressureData.append(0, this.md.t, this.md.getMeanPressure());
        this.gr.normalize();
        this.grFrame.clearData();
        this.grFrame.append(0, this.gr.rx, this.gr.ngr);
    }

    public void stop() {
        this.control.println("Density = " + this.decimalFormat.format(this.md.rho));
        this.control.println("Number of time steps = " + this.md.steps);
        this.control.println("Time step dt = " + this.decimalFormat.format(this.md.dt));
        this.control.println("<T>= " + this.decimalFormat.format(this.md.getMeanTemperature()));
        this.control.println("<E> = " + this.decimalFormat.format(this.md.getMeanEnergy()));
        this.control.println("Heat capacity = " + this.decimalFormat.format(this.md.getHeatCapacity()));
        this.control.println("<PA/NkT> = " + this.decimalFormat.format(this.md.getMeanPressure()));
    }

    public void startRunning() {
        this.md.dt = this.control.getDouble("\u0394t");
        double d = this.control.getDouble("L");
        double d2 = this.control.getDouble("L");
        if (d != this.md.Lx || d2 != this.md.Ly) {
            this.md.Lx = d;
            this.md.Ly = d2;
            this.md.computeAcceleration();
            this.displayPanel.setPreferredMinMax(0.0, d, 0.0, d2);
            this.resetData();
        }
    }

    public void reset() {
        OSPCombo oSPCombo = new OSPCombo(new String[]{"64", "144", "256"}, 0);
        this.control.setValue("number of particles", oSPCombo);
        this.control.setAdjustableValue("L", 20.0);
        this.control.setValue("initial KE per particle", 1.0);
        this.control.setAdjustableValue("\u0394t", 0.01);
        this.control.setAdjustableValue("velocity rescaling", 1.0);
        this.enableStepsPerDisplay(true);
        super.setStepsPerDisplay(10);
        this.displayPanel.setSquareAspect(true);
    }

    public void resetData() {
        this.md.resetAverages();
        GUIUtils.clearDrawingFrameData(false);
    }

    public void switchGUI() {
        this.stopSimulation();
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = LJfluidApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(LJfluidApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                LJfluidWRApp lJfluidWRApp = new LJfluidWRApp();
                LJfluidControl lJfluidControl = new LJfluidControl(lJfluidWRApp, (DrawingFrame)lJfluidWRApp.displayFrame, null);
                lJfluidControl.getMainFrame().setDefaultCloseOperation(n);
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        lJfluidControl.getMainFrame().addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                lJfluidControl.loadXML(xMLControlElement, true);
                lJfluidWRApp.customize();
                lJfluidControl.resetSimulation();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    void customize() {
        OSPFrame oSPFrame = this.getMainFrame();
        if (oSPFrame == null || !oSPFrame.isDisplayable()) {
            return;
        }
        JMenu jMenu = oSPFrame.getMenu("Display");
        JMenuItem jMenuItem = new JMenuItem("Switch GUI");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LJfluidApp.this.switchGUI();
            }
        });
        jMenu.add(jMenuItem);
        this.addChildFrame(this.displayFrame);
        this.addChildFrame(this.xVelocityHistogram);
        this.addChildFrame(this.grFrame);
        this.addChildFrame(this.pressureData);
        this.addChildFrame(this.temperatureData);
    }

    public static void main(String[] stringArray) {
        LJfluidApp lJfluidApp = new LJfluidApp();
        SimulationControl simulationControl = SimulationControl.createApp(lJfluidApp, stringArray);
        simulationControl.addButton("resetData", "Reset Data");
        lJfluidApp.customize();
    }
}

