/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.percolation;

import java.util.Random;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.frames.DisplayFrame;
import org.opensourcephysics.stp.percolation.HoshenKopelman;
import org.opensourcephysics.stp.percolation.PercolationLattice;
import org.opensourcephysics.stp.percolation.PercolationMouseListener;

public class PercolationAlgorithmApp
extends AbstractSimulation {
    DisplayFrame displayFrame = new DisplayFrame("");
    int L;
    double p;
    String mode = "";
    HoshenKopelman algorithm;
    Random random;
    PercolationLattice lattice = new PercolationLattice();
    PercolationMouseListener mouseListener;

    public PercolationAlgorithmApp() {
        this.random = new Random();
        this.displayFrame.setSquareAspect(true);
        this.displayFrame.setSize(600, 600);
        this.displayFrame.addDrawable(this.lattice);
        this.mouseListener = new PercolationMouseListener(this.displayFrame, this.lattice);
    }

    public void initialize() {
        this.displayFrame.removeMouseListener(this.mouseListener);
        this.mouseListener.setControl(this.control);
        this.random.setSeed(System.currentTimeMillis());
        this.L = this.control.getInt("L");
        this.p = this.control.getDouble("p");
        this.lattice.initialize(this.L, this.p, this.random);
        this.algorithm = new HoshenKopelman(this.lattice, this.L);
        this.displayFrame.repaint();
    }

    public void reset() {
        this.control.setValue("L", 20);
        this.control.setValue("p", 0.5);
    }

    public static void main(String[] stringArray) {
        SimulationControl simulationControl = SimulationControl.createApp(new PercolationAlgorithmApp());
        simulationControl.addButton("step_all", "calculate all");
    }

    public void step_all() {
        while (!this.algorithm.isComplete()) {
            this.lattice.currentSite = this.algorithm.singleStep();
        }
        this.doStep();
    }

    protected void doStep() {
        if (this.algorithm.isComplete()) {
            this.lattice.currentSite = null;
            this.control.clearMessages();
            this.stopSimulation();
            this.displayFrame.getDrawingPanel().addMouseListener(this.mouseListener);
            this.control.calculationDone("Labelling finished.\nClick on a cluster with the mouse.");
        } else {
            this.lattice.currentSite = this.algorithm.singleStep();
        }
        String string = this.algorithm.getMode();
        if (!this.mode.equals(string)) {
            this.mode = string;
            this.control.clearMessages();
            this.control.println(this.mode);
        }
    }
}

