/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.percolation;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.Random;
import org.opensourcephysics.controls.AbstractCalculation;
import org.opensourcephysics.controls.CalculationControl;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.InteractiveMouseHandler;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.frames.DisplayFrame;

public class PercolationApp
extends AbstractCalculation
implements InteractiveMouseHandler,
Drawable {
    int[][] rsite;
    static final int OCCUPIED = 1;
    static final int EMPTY = 0;
    double p;
    DisplayFrame displayFrame = new DisplayFrame("");
    int[] np;
    int L;
    final Color OCCUPIED_COLOR = Color.black;
    final Color EMPTY_COLOR = Color.white;
    Color selectedColor;
    int NONE;
    int selectedCluster = this.NONE = -99;
    Random random = new Random();

    public PercolationApp() {
        this.displayFrame.setSquareAspect(true);
        this.displayFrame.setInteractiveMouseHandler(this);
        this.displayFrame.addDrawable(this);
    }

    public void calculate() {
        this.random.setSeed(1239012312L);
        this.L = this.control.getInt("L");
        this.p = this.control.getDouble("p");
        this.rsite = new int[this.L + 1][this.L + 1];
        this.selectedCluster = this.NONE;
        this.displayFrame.setPreferredMinMax(0.0, this.L + 2, this.L + 2, 0.0);
        this.fill();
        this.compute();
        this.displayFrame.repaint();
    }

    public void reset() {
        this.control.setValue("L", 20);
        this.control.setValue("p", 0.5);
        this.calculate();
    }

    public void compute() {
        int n;
        this.np = new int[this.rsite.length * this.rsite.length];
        int n2 = 0;
        int n3 = 1;
        while (n3 <= this.L) {
            n = 1;
            while (n <= this.L) {
                if (this.rsite[n][n3] == 1) {
                    int n4 = n3 - 1;
                    int n5 = n - 1;
                    if (this.rsite[n][n4] + this.rsite[n5][n3] == 0) {
                        this.rsite[n][n3] = ++n2;
                        this.np[n2] = n2;
                    } else {
                        this.neighbor(n, n3);
                    }
                }
                ++n;
            }
            ++n3;
        }
        n3 = 1;
        while (n3 <= this.L) {
            n = 1;
            while (n <= this.L) {
                if (this.rsite[n][n3] != 0) {
                    this.rsite[n][n3] = this.proper(this.rsite[n][n3]);
                }
                ++n;
            }
            ++n3;
        }
    }

    void neighbor(int n, int n2) {
        int n3 = n2 - 1;
        int n4 = n - 1;
        if (this.rsite[n][n3] * this.rsite[n4][n2] > 0) {
            this.labelMin(n, n2, n4, n3);
        } else {
            this.rsite[n][n2] = this.rsite[n][n3] > 0 ? this.rsite[n][n3] : this.rsite[n4][n2];
        }
    }

    void labelMin(int n, int n2, int n3, int n4) {
        if (this.rsite[n3][n2] == this.rsite[n][n4]) {
            this.rsite[n][n2] = this.rsite[n3][n2];
        } else {
            int n5;
            int n6 = this.proper(this.rsite[n3][n2]);
            int n7 = this.proper(this.rsite[n][n4]);
            int n8 = Math.max(n6, n7);
            this.rsite[n][n2] = n5 = Math.min(n6, n7);
            if (n5 != n8) {
                this.np[n8] = n5;
            }
        }
    }

    int proper(int n) {
        if (this.np[n] == n) {
            return n;
        }
        return this.proper(this.np[n]);
    }

    public void fill() {
        int n = 1;
        while (n <= this.L) {
            int n2 = 1;
            while (n2 <= this.L) {
                double d = this.random.nextDouble();
                this.rsite[n2][n] = d < this.p ? 1 : 0;
                ++n2;
            }
            ++n;
        }
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.rsite == null) {
            return;
        }
        int n = 1 + (drawingPanel.xToPix(this.L + 1) - drawingPanel.xToPix(1.0)) / this.L;
        int n2 = 1 + (drawingPanel.yToPix(this.L + 1) - drawingPanel.yToPix(1.0)) / this.L;
        int n3 = 1;
        while (n3 <= this.L) {
            int n4 = 1;
            while (n4 <= this.L) {
                int n5 = this.rsite[n3][n4];
                if (n5 == this.selectedCluster) {
                    graphics.setColor(this.selectedColor);
                } else if (n5 == 0) {
                    graphics.setColor(this.EMPTY_COLOR);
                } else {
                    graphics.setColor(this.OCCUPIED_COLOR);
                }
                int n6 = drawingPanel.xToPix(n3);
                int n7 = drawingPanel.yToPix(n4);
                graphics.fillRect(n6, n7, n, n2);
                ++n4;
            }
            ++n3;
        }
    }

    public static void main(String[] stringArray) {
        CalculationControl.createApp(new PercolationApp(), stringArray);
    }

    public void handleMouseAction(InteractivePanel interactivePanel, MouseEvent mouseEvent) {
        if (interactivePanel.getMouseAction() != 1) {
            return;
        }
        int n = (int)this.displayFrame.getDrawingPanel().pixToX(mouseEvent.getX());
        int n2 = (int)this.displayFrame.getDrawingPanel().pixToY(mouseEvent.getY());
        int n3 = 0;
        if (n <= this.L && n2 <= this.L && n2 >= 1 && n >= 1) {
            this.selectedCluster = this.rsite[n][n2];
            if (this.selectedCluster == 0) {
                return;
            }
            this.selectedColor = new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0));
            int n4 = 1;
            while (n4 <= this.L) {
                int n5 = 1;
                while (n5 <= this.L) {
                    if (this.rsite[n5][n4] == this.selectedCluster) {
                        ++n3;
                    }
                    ++n5;
                }
                ++n4;
            }
        }
        this.control.clearMessages();
        this.control.println("Selected cluster size = " + n3);
        this.displayFrame.repaint();
    }
}

