/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.percolation;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.frames.DisplayFrame;
import org.opensourcephysics.stp.percolation.PercolationLattice;

public class PercolationMouseListener
extends MouseAdapter {
    DrawingPanel drawingPanel;
    PercolationLattice lattice;
    Control control;

    public PercolationMouseListener(DisplayFrame displayFrame, PercolationLattice percolationLattice) {
        this.drawingPanel = displayFrame.getDrawingPanel();
        this.lattice = percolationLattice;
    }

    public PercolationMouseListener(DrawingPanel drawingPanel, PercolationLattice percolationLattice) {
        this.drawingPanel = drawingPanel;
        this.lattice = percolationLattice;
    }

    public void setControl(Control control) {
        this.control = control;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        System.out.println("mouse clicked");
        int n = (int)this.drawingPanel.pixToX(mouseEvent.getX());
        int n2 = (int)this.drawingPanel.pixToY(mouseEvent.getY());
        int n3 = 0;
        if (n <= this.lattice.L && n2 <= this.lattice.L && n2 >= 1 && n >= 1) {
            this.lattice.selectedCluster = this.lattice.rsite[n][n2];
            if (this.lattice.selectedCluster == 0) {
                return;
            }
            int n4 = 1;
            while (n4 <= this.lattice.L) {
                int n5 = 1;
                while (n5 <= this.lattice.L) {
                    if (this.lattice.rsite[n5][n4] == this.lattice.selectedCluster) {
                        ++n3;
                    }
                    ++n5;
                }
                ++n4;
            }
        }
        this.control.clearMessages();
        this.control.println("Selected cluster size = " + n3);
        this.drawingPanel.repaint();
    }
}

