/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.qmc;

import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.ControlUtils;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.display3d.simple3d.ElementEllipsoid;
import org.opensourcephysics.frames.Display3DFrame;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.qmc.QMC;

public class QMCApp
extends AbstractSimulation {
    Display3DFrame frame = new Display3DFrame("Phase Space");
    QMC qmc = new QMC();
    PlotFrame distribution = new PlotFrame("energy", "n(E)", "distribution");
    PlotFrame energyDistribution = new PlotFrame("energy", "E n(E) D(E)", "energy distribution");
    PlotFrame dos = new PlotFrame("energy", "D(E)", "Density of States (number of states per unit energy)");
    PlotFrame particleState = new PlotFrame("particle label", "energy", "energy level diagram");
    int statistics;
    ElementEllipsoid[] sites;
    double dE;

    public void initialize() {
        this.distribution.setPreferredMinMax(0.0, 1.0, 0.0, 1.0);
        this.distribution.setAutoscaleX(true);
        this.distribution.setAutoscaleY(true);
        this.distribution.setConnected(1, true);
        this.energyDistribution.setPreferredMinMax(0.0, 1.0, 0.0, 1.0);
        this.energyDistribution.setAutoscaleX(true);
        this.energyDistribution.setAutoscaleY(true);
        double d = this.control.getDouble("momentum exponent p");
        int n = this.control.getInt("maximum k");
        int n2 = this.control.getInt("dimension");
        this.statistics = 1;
        String string = this.control.getString("statistics:FD, BE, MB");
        if (string.equalsIgnoreCase("FD")) {
            this.statistics = 1;
        } else if (string.equalsIgnoreCase("BE")) {
            this.statistics = 2;
        } else if (string.equalsIgnoreCase("MB")) {
            this.statistics = 3;
        }
        int n3 = this.control.getInt("number of particles");
        this.dE = this.control.getDouble("dE");
        this.qmc.beta = 1.0 / this.control.getDouble("temperature");
        this.particleState.setPreferredMinMax(0.0, n3, 0.0, 1.0);
        this.particleState.setAutoscaleX(true);
        this.particleState.setAutoscaleY(true);
        this.qmc.initial(n2, n, d, n3, this.statistics, this.dE);
        this.sites = new ElementEllipsoid[n3];
        this.frame.getDrawingPanel3D().removeAllElements();
        int n4 = 0;
        while (n4 < n3) {
            this.sites[n4] = new ElementEllipsoid();
            this.sites[n4].setXYZ(0.0, 0.0, 0.0);
            this.sites[n4].setSizeXYZ(0.2, 0.2, 0.2);
            this.frame.addElement(this.sites[n4]);
            ++n4;
        }
        this.frame.setPreferredMinMax(-n, n, -n, n, -n, n);
        this.dos.clearData();
        n4 = 0;
        while (n4 < (int)((double)this.qmc.maxEnergy / this.dE)) {
            this.dos.append(0, this.dE * (double)n4, this.qmc.densityOfStates[n4] / this.dE);
            ++n4;
        }
        this.dos.render();
    }

    public void reset() {
        this.control.setValue("momentum exponent p", 2);
        this.control.setValue("maximum k", 10);
        this.control.setValue("dimension", 3);
        this.control.setValue("statistics:FD, BE, MB", "FD");
        this.control.setValue("number of particles", 100);
        this.control.setValue("temperature", 10);
        this.control.setAdjustableValue("dE", 4);
        this.control.setAdjustableValue("steps per display", 10);
    }

    protected void doStep() {
        int n = this.control.getInt("steps per display");
        int n2 = 0;
        while (n2 < n) {
            switch (this.statistics) {
                case 1: {
                    this.qmc.stepFD();
                    break;
                }
                case 2: {
                    this.qmc.stepBE();
                    break;
                }
                default: {
                    this.qmc.stepMB();
                }
            }
            ++n2;
        }
        this.displayData();
    }

    protected void displayData() {
        this.dE = this.control.getDouble("dE");
        this.frame.setMessage("mcs = " + this.qmc.mcs);
        this.distribution.clearData();
        this.energyDistribution.clearData();
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = this.dE;
        double d4 = 0.0;
        int n2 = 0;
        while (n2 < this.qmc.occupiedIndexMax) {
            if (this.qmc.occupationAccum[n2] > 0) {
                d2 = this.qmc.energy[n2];
                if (d2 > d3) {
                    this.energyDistribution.append(0, d3 - 0.5 * this.dE, d4 / this.dE);
                    d3 += this.dE;
                    d4 = 0.0;
                }
                ++n;
                double d5 = 1.0 * (double)this.qmc.occupationAccum[n2] / (double)this.qmc.mcs;
                d += d5;
                this.distribution.append(0, d2, d5);
                d4 += d2 * d5;
                if (Math.abs(d2 - this.qmc.energy[n2 + 1]) > 0.001) {
                    this.distribution.append(1, d2, d / (double)n);
                    n = 0;
                    d = 0.0;
                }
            }
            ++n2;
        }
        this.distribution.append(1, d2, d / (double)n);
        double d6 = this.qmc.energyAccum / (double)this.qmc.mcs;
        double d7 = this.qmc.energySqAccum / (double)this.qmc.mcs;
        double d8 = this.qmc.beta * this.qmc.beta * (d7 - d6 * d6) / (double)this.qmc.np;
        this.distribution.setMessage("E/N = " + ControlUtils.f2(d6 / (double)this.qmc.np) + " c=" + ControlUtils.f2(d8));
        this.particleState.clearData();
        int n3 = 0;
        while (n3 < this.qmc.np) {
            this.particleState.append(0, n3, this.qmc.energy[this.qmc.state[n3]]);
            ++n3;
        }
    }

    public void stop() {
        int n = 0;
        while (n < this.qmc.np) {
            this.sites[n].setXYZ(this.qmc.x[this.qmc.state[n]], this.qmc.y[this.qmc.state[n]], this.qmc.z[this.qmc.state[n]]);
            ++n;
        }
        this.frame.render();
    }

    public void resetData() {
        this.qmc.resetData();
        this.distribution.clearData();
        this.particleState.clearData();
        this.distribution.render();
        this.particleState.render();
        this.control.clearMessages();
    }

    public static void main(String[] stringArray) {
        SimulationControl simulationControl = SimulationControl.createApp(new QMCApp());
        simulationControl.addButton("resetData", "Reset Data");
    }
}

