/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.randomwalk.randomwalk1;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.text.NumberFormat;
import java.util.Random;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.randomwalk.randomwalk1.OneDimensionalWalkWRApp;
import org.opensourcephysics.stp.randomwalk.randomwalk1.OneDimensionalWalkWRAppControl;

public class OneDimensionalWalkApp
extends AbstractSimulation {
    int N;
    double p;
    int trials;
    int x;
    double xcum;
    double x2cum;
    PlotFrame histogramFrame = new PlotFrame("x", "H(x)", "Histogram");
    NumberFormat numberFormat = NumberFormat.getInstance();
    int[] H;
    Random random;

    public OneDimensionalWalkApp() {
        this.numberFormat.setMaximumFractionDigits(2);
        this.random = new Random();
        this.histogramFrame.setXYColumnNames(0, "x", "H(x)");
    }

    public void initialize() {
        this.N = this.control.getInt("N");
        this.H = new int[2 * this.N + 1];
        this.p = this.control.getDouble("p");
        this.p = Math.min(this.p, 1.0);
        this.p = Math.max(this.p, 0.0);
        this.control.setValue("p", this.p);
        this.trials = 0;
        this.x = 0;
        this.xcum = 0.0;
        this.x2cum = 0.0;
        this.histogramFrame.setAutoscaleX(true);
        this.histogramFrame.setAutoscaleY(true);
        this.histogramFrame.limitAutoscaleX(this.x - this.N, this.x + this.N);
        this.histogramFrame.limitAutoscaleY(0.0, 10.0);
        this.random.setSeed(System.currentTimeMillis());
        this.histogramFrame.clearData();
    }

    public void reset() {
        this.N = 16;
        this.p = 0.5;
        this.trials = 0;
        this.control.setAdjustableValue("N", this.N);
        this.control.setAdjustableValue("p", this.p);
        this.enableStepsPerDisplay(true);
        this.initialize();
    }

    protected void doStep() {
        int n = 0;
        while (n < this.N) {
            this.x = this.random.nextDouble() < this.p ? ++this.x : --this.x;
            ++n;
        }
        ++this.trials;
        int n2 = this.N + this.x;
        this.H[n2] = this.H[n2] + 1;
        this.xcum += (double)this.x;
        this.x2cum += (double)(this.x * this.x);
        this.x = 0;
        this.histogramFrame.clearData();
        n = 0;
        while (n < 2 * this.N + 1) {
            if (this.H[n] > 0) {
                this.histogramFrame.append(0, n - this.N, this.H[n]);
            }
            ++n;
        }
    }

    public void stopRunning() {
        this.control.clearMessages();
        if (this.trials == 0) {
            return;
        }
        double d = this.xcum / (double)this.trials;
        double d2 = this.x2cum / (double)this.trials;
        this.control.println("trials = " + this.trials);
        this.control.println("<x> = " + this.numberFormat.format(d));
        this.control.println("<x^2> = " + this.numberFormat.format(d2));
    }

    public void switchGUI() {
        this.stopSimulation();
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = OneDimensionalWalkApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(OneDimensionalWalkApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                OneDimensionalWalkWRApp oneDimensionalWalkWRApp = new OneDimensionalWalkWRApp();
                OneDimensionalWalkWRAppControl oneDimensionalWalkWRAppControl = new OneDimensionalWalkWRAppControl(oneDimensionalWalkWRApp, (DrawingFrame)oneDimensionalWalkWRApp.histogramFrame, null);
                oneDimensionalWalkWRAppControl.getMainFrame().setDefaultCloseOperation(n);
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        oneDimensionalWalkWRAppControl.getMainFrame().addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                oneDimensionalWalkWRAppControl.loadXML(xMLControlElement, true);
                oneDimensionalWalkWRApp.customize();
                oneDimensionalWalkWRAppControl.resetSimulation();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    void customize() {
        OSPFrame oSPFrame = this.getMainFrame();
        if (oSPFrame == null || !oSPFrame.isDisplayable()) {
            return;
        }
        JMenu jMenu = oSPFrame.getMenu("Display");
        JMenuItem jMenuItem = new JMenuItem("Switch GUI");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OneDimensionalWalkApp.this.switchGUI();
            }
        });
        jMenu.add(jMenuItem);
        this.addChildFrame(this.histogramFrame);
    }

    public static void main(String[] stringArray) {
        OneDimensionalWalkApp oneDimensionalWalkApp = new OneDimensionalWalkApp();
        SimulationControl.createApp(oneDimensionalWalkApp, stringArray);
        oneDimensionalWalkApp.customize();
    }
}

