/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.randomwalk.randomwalk2;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.text.NumberFormat;
import java.util.Random;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.ControlUtils;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.frames.DisplayFrame;
import org.opensourcephysics.frames.HistogramFrame;
import org.opensourcephysics.stp.randomwalk.randomwalk2.TwoDimensionalWalkWRApp;
import org.opensourcephysics.stp.randomwalk.randomwalk2.TwoDimensionalWalkWRAppControl;

public class TwoDimensionalWalkApp
extends AbstractSimulation
implements Drawable {
    int nwalkers;
    int xmax;
    int ymax;
    int xmin;
    int ymin;
    int time = 0;
    int[] xpositions;
    int[] ypositions;
    double xbar;
    double ybar;
    double x2;
    double y2;
    double r2;
    DisplayFrame displayFrame = new DisplayFrame("Walkers");
    DrawingPanel displayPanel;
    HistogramFrame histogramFrame = new HistogramFrame("r", "H(r)", "H(r) versus r");
    Random random;
    double pRight;
    double pLeft;
    double pDown;
    NumberFormat numberFormat = NumberFormat.getInstance();

    public TwoDimensionalWalkApp() {
        this.numberFormat.setMaximumFractionDigits(2);
        this.displayFrame.addDrawable(this);
        this.displayPanel = this.displayFrame.getDrawingPanel();
        this.displayPanel.setPreferredMinMax(-100.0, 100.0, -100.0, 100.0);
        this.displayPanel.setAutoscaleX(false);
        this.displayPanel.setAutoscaleY(false);
        this.random = new Random();
        this.histogramFrame.setBinWidth(0.01);
        this.histogramFrame.setAutoscaleX(true);
        this.histogramFrame.setAutoscaleY(true);
        this.histogramFrame.limitAutoscaleX(0.0, 10.0);
        this.histogramFrame.limitAutoscaleY(0.0, 10.0);
    }

    public boolean isMeasured() {
        return true;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getYMax() {
        return this.ymax;
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getYMin() {
        return this.ymin;
    }

    public void initialize() {
        this.nwalkers = this.control.getInt("number of walkers");
        this.pLeft = this.control.getDouble("p left");
        this.pRight = this.control.getDouble("p right");
        this.pDown = this.control.getDouble("p down");
        double d = this.pLeft + this.pRight + this.pDown;
        if (d > 1.0) {
            this.pLeft /= d;
            this.pRight /= d;
            this.pDown /= d;
        }
        this.r2 = 0.0;
        this.y2 = 0.0;
        this.x2 = 0.0;
        this.ybar = 0.0;
        this.xbar = 0.0;
        this.xpositions = new int[this.nwalkers];
        this.ypositions = new int[this.nwalkers];
        this.random.setSeed(System.currentTimeMillis());
        this.time = 0;
        this.displayPanel.setMessage("time = " + this.time);
    }

    public void reset() {
        this.xmax = 0;
        this.ymax = 0;
        this.xmin = 0;
        this.ymin = 0;
        this.pRight = 0.25;
        this.pDown = 0.25;
        this.pLeft = 0.25;
        this.control.setValue("number of walkers", 1000);
        this.control.setValue("p left", this.pLeft);
        this.control.setValue("p right", this.pRight);
        this.control.setValue("p down", this.pDown);
        this.histogramFrame.clearData();
        this.time = 0;
        this.displayPanel.setMessage("time = " + this.time);
        this.enableStepsPerDisplay(true);
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        int n = 4;
        graphics.setColor(Color.red);
        int n2 = 0;
        while (n2 < this.nwalkers) {
            double d = this.xpositions[n2];
            double d2 = this.ypositions[n2];
            int n3 = drawingPanel.xToPix(d) - n / 2;
            int n4 = drawingPanel.yToPix(d2) - n / 2;
            graphics.fillRect(n3, n4, n, n);
            ++n2;
        }
    }

    public void move() {
        ++this.time;
        if (this.time % 10 == 1) {
            this.histogramFrame.clearData();
        }
        int n = 0;
        while (n < this.nwalkers) {
            double d = this.random.nextDouble();
            if (d <= this.pRight) {
                this.xpositions[n] = this.xpositions[n] + 1;
            } else if (d < this.pRight + this.pLeft) {
                this.xpositions[n] = this.xpositions[n] - 1;
            } else {
                this.ypositions[n] = d < this.pRight + this.pLeft + this.pDown ? this.ypositions[n] - 1 : this.ypositions[n] + 1;
            }
            if (this.time % 10 == 1) {
                this.histogramFrame.append(Math.sqrt(this.xpositions[n] * this.xpositions[n] + this.ypositions[n] * this.ypositions[n]));
            }
            this.xmax = Math.max(this.xpositions[n], this.xmax);
            this.ymax = Math.max(this.ypositions[n], this.ymax);
            this.xmin = Math.min(this.xpositions[n], this.xmin);
            this.ymin = Math.min(this.ypositions[n], this.ymin);
            ++n;
        }
    }

    public void getAverages() {
        this.r2 = 0.0;
        this.y2 = 0.0;
        this.x2 = 0.0;
        this.ybar = 0.0;
        this.xbar = 0.0;
        int n = 0;
        while (n < this.nwalkers) {
            this.xbar += (double)this.xpositions[n];
            this.ybar += (double)this.ypositions[n];
            this.x2 += (double)(this.xpositions[n] * this.xpositions[n]);
            this.y2 += (double)(this.ypositions[n] * this.ypositions[n]);
            this.r2 += (double)(this.xpositions[n] * this.xpositions[n] + this.ypositions[n] * this.ypositions[n]);
            ++n;
        }
        this.xbar /= (double)this.nwalkers;
        this.ybar /= (double)this.nwalkers;
        this.x2 /= (double)this.nwalkers;
        this.y2 /= (double)this.nwalkers;
        this.r2 /= (double)this.nwalkers;
    }

    public void stopRunning() {
        this.control.clearMessages();
        this.control.println("time = " + this.time);
        this.control.println("<x> = " + ControlUtils.f2(this.xbar) + "\t\t<y> = " + ControlUtils.f2(this.ybar));
        this.control.println("<x\u00b2> = " + ControlUtils.f2(this.x2) + "\t\t<y\u00b2> = " + ControlUtils.f2(this.y2));
        this.control.println("<r\u00b2> = " + ControlUtils.f2(this.r2));
    }

    protected void doStep() {
        this.move();
        this.getAverages();
        this.displayPanel.setMessage("time = " + this.time);
    }

    public void switchGUI() {
        this.stopSimulation();
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = TwoDimensionalWalkApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(TwoDimensionalWalkApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                TwoDimensionalWalkWRApp twoDimensionalWalkWRApp = new TwoDimensionalWalkWRApp();
                TwoDimensionalWalkWRAppControl twoDimensionalWalkWRAppControl = new TwoDimensionalWalkWRAppControl(twoDimensionalWalkWRApp, (DrawingFrame)twoDimensionalWalkWRApp.displayFrame, null);
                twoDimensionalWalkWRAppControl.getMainFrame().setDefaultCloseOperation(n);
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        twoDimensionalWalkWRAppControl.getMainFrame().addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                twoDimensionalWalkWRAppControl.loadXML(xMLControlElement, true);
                twoDimensionalWalkWRApp.customize();
                twoDimensionalWalkWRAppControl.resetSimulation();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    void customize() {
        OSPFrame oSPFrame = this.getMainFrame();
        if (oSPFrame == null || !oSPFrame.isDisplayable()) {
            return;
        }
        JMenu jMenu = oSPFrame.getMenu("Display");
        JMenuItem jMenuItem = new JMenuItem("Switch GUI");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TwoDimensionalWalkApp.this.switchGUI();
            }
        });
        jMenu.add(jMenuItem);
        this.addChildFrame(this.displayFrame);
        this.addChildFrame(this.histogramFrame);
    }

    public static void main(String[] stringArray) {
        TwoDimensionalWalkApp twoDimensionalWalkApp = new TwoDimensionalWalkApp();
        SimulationControl.createApp(twoDimensionalWalkApp, stringArray);
        twoDimensionalWalkApp.customize();
    }
}

