/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.randomwalk.randomwalkcontinuous;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.text.NumberFormat;
import java.util.Random;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.frames.HistogramFrame;
import org.opensourcephysics.stp.randomwalk.randomwalkcontinuous.VariableStepLengthWalkAppControl;
import org.opensourcephysics.stp.randomwalk.randomwalkcontinuous.VariableStepLengthWalkWRApp;

public class VariableStepLengthWalkApp
extends AbstractSimulation {
    int N;
    double p;
    int trials;
    double xcum;
    double x2cum;
    HistogramFrame histogramFrame = new HistogramFrame("x", "H(x)", "Histogram");
    DrawingPanel drawingPanel = this.histogramFrame.getDrawingPanel();
    NumberFormat numberFormat = NumberFormat.getInstance();
    Random random;

    public VariableStepLengthWalkApp() {
        this.numberFormat.setMaximumFractionDigits(2);
        this.random = new Random();
        this.histogramFrame.setBinStyle((short)1);
        this.histogramFrame.setDiscrete(false);
        this.histogramFrame.setBinColor(null, Color.red);
    }

    public void initialize() {
        this.N = this.control.getInt("N");
        this.p = this.control.getDouble("p");
        this.trials = 0;
        this.xcum = 0.0;
        this.x2cum = 0.0;
        this.histogramFrame.setBinWidth(this.control.getDouble("bin width"));
        this.drawingPanel.setAutoscaleX(true);
        this.drawingPanel.setAutoscaleY(true);
        this.drawingPanel.limitAutoscaleX(-this.N, this.N);
        this.drawingPanel.limitAutoscaleY(0.0, 10.0);
        this.random.setSeed(System.currentTimeMillis());
    }

    public void reset() {
        this.N = 16;
        this.p = 0.5;
        this.trials = 0;
        this.control.setAdjustableValue("N", this.N);
        this.control.setAdjustableValue("p", this.p);
        this.control.setAdjustableValue("bin width", 0.5);
        this.histogramFrame.clearData();
        this.enableStepsPerDisplay(true);
    }

    public double sample_x_exponential() {
        return -0.5 * Math.log(1.0 - Math.random());
    }

    public double sample_x_uniform() {
        return Math.random();
    }

    protected void doStep() {
        double d = 0.0;
        int n = 0;
        while (n < this.N) {
            d = this.random.nextDouble() < this.p ? (d += this.sample_x_uniform()) : (d -= this.sample_x_uniform());
            ++n;
        }
        ++this.trials;
        this.histogramFrame.append(d);
        this.xcum += d;
        this.x2cum += d * d;
    }

    public void stopRunning() {
        this.control.clearMessages();
        if (this.trials == 0) {
            return;
        }
        double d = this.xcum / (double)this.trials;
        double d2 = this.x2cum / (double)this.trials;
        this.control.println("trials = " + this.trials);
        this.control.println("<x> = " + this.numberFormat.format(d));
        this.control.println("<x^2> = " + this.numberFormat.format(d2));
    }

    public void switchGUI() {
        this.stopSimulation();
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = VariableStepLengthWalkApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(VariableStepLengthWalkApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                VariableStepLengthWalkWRApp variableStepLengthWalkWRApp = new VariableStepLengthWalkWRApp();
                VariableStepLengthWalkAppControl variableStepLengthWalkAppControl = new VariableStepLengthWalkAppControl(variableStepLengthWalkWRApp, (DrawingFrame)variableStepLengthWalkWRApp.histogramFrame, null);
                variableStepLengthWalkAppControl.getMainFrame().setDefaultCloseOperation(n);
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        variableStepLengthWalkAppControl.getMainFrame().addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                variableStepLengthWalkAppControl.loadXML(xMLControlElement, true);
                variableStepLengthWalkWRApp.customize();
                variableStepLengthWalkAppControl.resetSimulation();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    void customize() {
        OSPFrame oSPFrame = this.getMainFrame();
        if (oSPFrame == null || !oSPFrame.isDisplayable()) {
            return;
        }
        JMenu jMenu = oSPFrame.getMenu("Display");
        JMenuItem jMenuItem = new JMenuItem("Switch GUI");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VariableStepLengthWalkApp.this.switchGUI();
            }
        });
        jMenu.add(jMenuItem);
        this.addChildFrame(this.histogramFrame);
    }

    public static void main(String[] stringArray) {
        VariableStepLengthWalkApp variableStepLengthWalkApp = new VariableStepLengthWalkApp();
        SimulationControl.createApp(variableStepLengthWalkApp, stringArray);
        variableStepLengthWalkApp.customize();
    }
}

