/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.randomwalk.randomwalkcontinuous;

import java.awt.event.WindowListener;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.ejs.control.EjsSimulationControl;
import org.opensourcephysics.stp.randomwalk.randomwalkcontinuous.VariableStepLengthWalkApp;
import org.opensourcephysics.stp.randomwalk.randomwalkcontinuous.VariableStepLengthWalkAppControl;

public class VariableStepLengthWalkWRApp
extends VariableStepLengthWalkApp {
    public void switchGUI() {
        this.stopSimulation();
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = VariableStepLengthWalkWRApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(VariableStepLengthWalkWRApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                VariableStepLengthWalkApp variableStepLengthWalkApp = new VariableStepLengthWalkApp();
                SimulationControl simulationControl = SimulationControl.createApp(variableStepLengthWalkApp);
                simulationControl.setDefaultCloseOperation(n);
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        simulationControl.addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                simulationControl.loadXML(xMLControlElement, true);
                simulationControl.setValue("model", null);
                variableStepLengthWalkApp.customize();
                variableStepLengthWalkApp.initialize();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    public void doStep() {
        super.doStep();
        this.stopRunning();
    }

    public void stopRunning() {
        if (this.control == null || this.trials == 0) {
            ((EjsSimulationControl)this.control).getControl("trialsNumber").setProperty("value", "0");
            ((EjsSimulationControl)this.control).getControl("xNumber").setProperty("value", "");
            ((EjsSimulationControl)this.control).getControl("x2Number").setProperty("value", "");
            return;
        }
        double d = this.xcum / (double)this.trials;
        double d2 = this.x2cum / (double)this.trials;
        ((EjsSimulationControl)this.control).getControl("trialsNumber").setProperty("value", "" + this.trials);
        ((EjsSimulationControl)this.control).getControl("xNumber").setProperty("value", this.numberFormat.format(d));
        ((EjsSimulationControl)this.control).getControl("x2Number").setProperty("value", this.numberFormat.format(d2));
    }

    public void setParameter() {
        this.histogramFrame.clearData();
        this.initialize();
        GUIUtils.repaintOSPFrames();
    }

    public static void main(String[] stringArray) {
        VariableStepLengthWalkWRApp variableStepLengthWalkWRApp = new VariableStepLengthWalkWRApp();
        new VariableStepLengthWalkAppControl(variableStepLengthWalkWRApp, (DrawingFrame)variableStepLengthWalkWRApp.histogramFrame, stringArray);
        variableStepLengthWalkWRApp.customize();
    }
}

