/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.randomwalk.saw;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.randomwalk.saw.Flat;
import org.opensourcephysics.stp.randomwalk.saw.FlatAppControl;
import org.opensourcephysics.stp.randomwalk.saw.FlatWRApp;
import org.opensourcephysics.stp.randomwalk.saw.OneWalker;

public class FlatApp
extends AbstractSimulation {
    Flat walkers = new Flat();
    PlotFrame xyFrame = new PlotFrame("time", "", "<x>,<y>");
    PlotFrame x2y2Frame = new PlotFrame("ln time", "x^2, y^2", "ln <x^2>,ln <y^2>");
    PlotFrame r2Frame = new PlotFrame("ln time", "r^2", "ln <r^2>");
    DatasetManager datasets;
    DrawingPanel drawingPanel;
    int step;
    int nstep;
    int maxStep;

    public FlatApp() {
        this.xyFrame.setXYColumnNames(0, "t", "<x>");
        this.xyFrame.setXYColumnNames(1, "t", "<y>");
        this.x2y2Frame.setXYColumnNames(0, "ln t", "ln <x^2>");
        this.x2y2Frame.setXYColumnNames(1, "ln t", "ln <y^2>");
        this.x2y2Frame.setAutoscaleX(true);
        this.x2y2Frame.setAutoscaleY(true);
        this.x2y2Frame.limitAutoscaleX(0.0, 10.0);
        this.x2y2Frame.limitAutoscaleY(0.0, 10.0);
        this.xyFrame.setAutoscaleX(true);
        this.xyFrame.setAutoscaleY(true);
        this.xyFrame.limitAutoscaleX(0.0, 10.0);
        this.xyFrame.limitAutoscaleY(0.0, 10.0);
        this.datasets = this.r2Frame.getDatasetManager();
        this.datasets.setXYColumnNames(0, "ln t", "ln <r^2>");
        this.drawingPanel = this.r2Frame.getDrawingPanel();
        this.drawingPanel.setAutoscaleX(true);
        this.drawingPanel.setAutoscaleY(true);
        this.drawingPanel.limitAutoscaleX(0.0, 10.0);
        this.drawingPanel.limitAutoscaleY(0.0, 10.0);
    }

    public void initialize() {
        this.walkers.numberOfWalkers = this.control.getInt("number of initial walkers");
        this.maxStep = this.control.getInt("number of steps");
        OneWalker.s0 = (short)(this.maxStep / 2);
        this.walkers.initialize();
        this.step = 0;
        this.nstep = 2;
        this.drawingPanel.setMessage("time = " + this.step);
    }

    public void doStep() {
        if (this.nstep <= this.maxStep) {
            int n;
            int n2 = n = this.step;
            while (n2 < this.nstep) {
                this.walkers.step();
                ++this.step;
                ++n2;
            }
            this.nstep *= 2;
            double d = this.walkers.norm;
            double d2 = this.walkers.xAccum / d;
            double d3 = this.walkers.xSquaredAccum / d;
            double d4 = this.walkers.yAccum / d;
            double d5 = this.walkers.ySquaredAccum / d;
            this.xyFrame.append(0, this.step, d2);
            this.xyFrame.append(1, this.step, d4);
            this.x2y2Frame.append(0, Math.log(this.step), Math.log(d3 - d2 * d2));
            this.x2y2Frame.append(1, Math.log(this.step), Math.log(d5 - d4 * d4));
            this.datasets.append(0, Math.log(this.step), Math.log(d3 - d2 * d2 + d5 - d4 * d4));
            this.xyFrame.setMessage("# walkers = " + this.walkers.numberOfWalkers);
            this.drawingPanel.setMessage("time = " + this.step);
        }
    }

    public void reset() {
        this.control.setValue("number of initial walkers", 100);
        this.control.setValue("number of steps", 1024);
        this.xyFrame.clearData();
        this.datasets.clear();
        this.x2y2Frame.clearData();
    }

    public void switchGUI() {
        this.stopSimulation();
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                OSPRuntime.disableAllDrawing = true;
                OSPFrame oSPFrame = FlatApp.this.getMainFrame();
                XMLControlElement xMLControlElement = new XMLControlElement(FlatApp.this.getOSPApp());
                WindowListener[] windowListenerArray = oSPFrame.getWindowListeners();
                int n = oSPFrame.getDefaultCloseOperation();
                oSPFrame.setDefaultCloseOperation(2);
                oSPFrame.setKeepHidden(true);
                oSPFrame.dispose();
                FlatWRApp flatWRApp = new FlatWRApp();
                FlatAppControl flatAppControl = new FlatAppControl(flatWRApp, (DrawingFrame)flatWRApp.r2Frame, null);
                flatAppControl.getMainFrame().setDefaultCloseOperation(n);
                int n2 = 0;
                int n3 = windowListenerArray.length;
                while (n2 < n3) {
                    if (windowListenerArray[n2].getClass().getName().equals("org.opensourcephysics.tools.Launcher$FrameCloser")) {
                        flatAppControl.getMainFrame().addWindowListener(windowListenerArray[n2]);
                    }
                    ++n2;
                }
                flatAppControl.loadXML(xMLControlElement, true);
                flatWRApp.customize();
                flatAppControl.resetSimulation();
                System.gc();
                OSPRuntime.disableAllDrawing = false;
                GUIUtils.showDrawingAndTableFrames();
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    void customize() {
        OSPFrame oSPFrame = this.getMainFrame();
        if (oSPFrame == null || !oSPFrame.isDisplayable()) {
            return;
        }
        JMenu jMenu = oSPFrame.getMenu("Display");
        JMenuItem jMenuItem = new JMenuItem("Switch GUI");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FlatApp.this.switchGUI();
            }
        });
        jMenu.add(jMenuItem);
        this.addChildFrame(this.xyFrame);
        this.addChildFrame(this.x2y2Frame);
        this.addChildFrame(this.r2Frame);
    }

    public static void main(String[] stringArray) {
        FlatApp flatApp = new FlatApp();
        SimulationControl.createApp(flatApp);
        flatApp.customize();
    }
}

