/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.randomwalk.saw;

import org.opensourcephysics.stp.randomwalk.saw.Flat;

public class OneWalker {
    double weight;
    static short s0 = (short)512;
    int[] xVisited = new int[2 * s0 + 1];
    int[] yVisited = new int[2 * s0 + 1];
    int[] moveX = new int[4];
    int[] moveY = new int[4];
    boolean[] occupied = new boolean[4];
    int[] goodMoveX = new int[3];
    int[] goodMoveY = new int[3];
    int x;
    int y;
    int m;
    int t;

    public void copyWalker(OneWalker oneWalker, double d) {
        int n = oneWalker.xVisited.length;
        this.xVisited = new int[n];
        this.yVisited = new int[n];
        System.arraycopy(oneWalker.xVisited, 0, this.xVisited, 0, n);
        System.arraycopy(oneWalker.yVisited, 0, this.yVisited, 0, n);
        this.weight = d;
        this.x = oneWalker.x;
        this.y = oneWalker.y;
        this.t = oneWalker.t;
    }

    public void newWalker(Flat flat) {
        this.x = s0;
        this.y = s0;
        this.weight = 1.0;
        this.xVisited[0] = this.x++;
        this.yVisited[0] = this.y++;
        double d = Math.random();
        if (d < 0.25 || d < 0.5 || !(d < 0.75)) {
            // empty if block
        }
        this.xVisited[1] = --this.x;
        this.yVisited[1] = --this.y;
        flat.xAccum += (double)(this.x - s0);
        flat.xSquaredAccum += (double)((this.x - s0) * (this.x - s0));
        flat.yAccum += (double)(this.y - s0);
        flat.ySquaredAccum += (double)((this.y - s0) * (this.y - s0));
        flat.norm += 1.0;
        this.t = 2;
    }

    public void step(Flat flat) {
        if (this.t < 2 * s0 + 1 && this.t < this.xVisited.length) {
            this.m = 0;
            int n = 0;
            while (n < 4) {
                this.occupied[n] = false;
                this.moveX[n] = this.x;
                this.moveY[n] = this.y;
                ++n;
            }
            this.moveX[0] = this.moveX[0] + 1;
            this.moveX[1] = this.moveX[1] - 1;
            this.moveY[2] = this.moveY[2] + 1;
            this.moveY[3] = this.moveY[3] - 1;
            n = 0;
            while (n < this.t) {
                int n2 = 0;
                while (n2 < 4) {
                    if (this.xVisited[n] == this.moveX[n2] && this.yVisited[n] == this.moveY[n2]) {
                        this.occupied[n2] = true;
                    }
                    ++n2;
                }
                ++n;
            }
            n = 0;
            while (n < 4) {
                if (!this.occupied[n] && this.m < 3) {
                    this.goodMoveX[this.m] = this.moveX[n];
                    this.goodMoveY[this.m] = this.moveY[n];
                    ++this.m;
                }
                ++n;
            }
            if (this.m == 0) {
                this.weight = 0.0;
                return;
            }
            n = (int)(Math.random() * (double)this.m);
            this.weight *= (double)this.m / 3.0;
            this.x = this.goodMoveX[n];
            this.y = this.goodMoveY[n];
            this.xVisited[this.t] = this.x;
            this.yVisited[this.t] = this.y;
            ++this.t;
            flat.xAccum += (double)(this.x - s0) * this.weight;
            flat.xSquaredAccum += (double)((this.x - s0) * (this.x - s0)) * this.weight;
            flat.yAccum += (double)(this.y - s0) * this.weight;
            flat.ySquaredAccum += (double)((this.y - s0) * (this.y - s0)) * this.weight;
            flat.norm += this.weight;
        }
    }
}

