/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.thermalcontact;

public class LJSimulation {
    public double[] x;
    public double[] y;
    public double[] vx;
    public double[] vy;
    double[] ax;
    double[] ay;
    double Lx;
    double Ly;
    public int Na;
    public int Nb;
    public int N;
    double sigma_aa = 1.0;
    double sigma_bb = 1.0;
    double sigma_ab = 1.0;
    double sigma_w = 1.0;
    double epsilon_aa = 1.0;
    double epsilon_bb = 1.0;
    double epsilon_ab = 1.0;
    double dt;
    double r_cutoff = Double.MAX_VALUE;
    public double Ka;
    public double Kb;
    public double Va;
    public double Vb;

    public LJSimulation(int n, int n2, double d, double d2, double d3) {
        this.Lx = d;
        this.Ly = d2;
        this.Na = n;
        this.Nb = n2;
        this.N = this.Na + this.Nb;
        this.dt = d3;
        this.x = new double[this.N];
        this.y = new double[this.N];
        this.vx = new double[this.N];
        this.vy = new double[this.N];
        this.ax = new double[this.N];
        this.ay = new double[this.N];
        this.setHexagonalPositions();
    }

    public void setInteractionCoefficients(double d, double d2, double d3, double d4, double d5) {
        this.sigma_aa = d;
        this.sigma_bb = d2;
        this.sigma_ab = 0.5 * (this.sigma_aa + this.sigma_bb);
        this.sigma_w = d3;
        this.epsilon_aa = d4;
        this.epsilon_bb = d5;
        this.epsilon_ab = 0.5 * (this.epsilon_aa + this.epsilon_bb);
    }

    public void setTimeStep(double d) {
        this.dt = d;
    }

    void setHexagonalPositions() {
        double d = Math.sqrt((double)this.N * this.Lx * Math.sqrt(3.0) / (this.Ly * 2.0));
        double d2 = (double)this.N / d;
        int n = (int)Math.ceil(d - 1.0E-7);
        int n2 = (int)Math.ceil(d2 - 1.0E-7);
        double d3 = this.Lx / ((double)n + 1.5);
        double d4 = this.Ly / (double)(n2 + 1);
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                if (n3 >= this.N) {
                    return;
                }
                this.x[n3] = ((double)(1 + n5) + 0.5 * (double)(n4 % 2)) * d3;
                this.y[n3] = (double)(1 + n4) * d4;
                ++n3;
                ++n5;
            }
            ++n4;
        }
    }

    double[] wallAccel(double d, double d2) {
        double d3;
        double[] dArray = new double[2];
        if (d < this.r_cutoff && d < d2 / 2.0) {
            d3 = d;
        } else if (d2 - d < this.r_cutoff && d > d2 / 2.0) {
            d3 = d - d2;
        } else {
            return dArray;
        }
        double d4 = this.sigma_w * this.sigma_w / (d3 * d3);
        double d5 = d4 * d4 * d4;
        dArray[0] = (48.0 * d5 - 24.0) * d5 / d3;
        dArray[1] = (4.0 * d5 - 4.0) * d5;
        return dArray;
    }

    double sigma2(int n, int n2) {
        if (n < this.Na && n2 < this.Na) {
            return this.sigma_aa * this.sigma_aa;
        }
        if (n < this.Na) {
            return this.sigma_ab * this.sigma_ab;
        }
        return this.sigma_bb * this.sigma_bb;
    }

    double epsilon(int n, int n2) {
        if (n < this.Na && n2 < this.Na) {
            return this.epsilon_aa;
        }
        if (n < this.Na) {
            return this.epsilon_ab;
        }
        return this.epsilon_bb;
    }

    double[] particleAccel(int n, int n2) {
        double[] dArray = new double[3];
        double d = this.x[n] - this.x[n2];
        double d2 = this.y[n] - this.y[n2];
        double d3 = d * d + d2 * d2;
        if (d3 < this.r_cutoff * this.r_cutoff) {
            double d4 = this.epsilon(n, n2);
            double d5 = this.sigma2(n, n2) / d3;
            double d6 = d5 * d5 * d5;
            dArray[0] = d4 * ((48.0 * d6 - 24.0) * d6 / d3) * d;
            dArray[1] = d4 * ((48.0 * d6 - 24.0) * d6 / d3) * d2;
            dArray[2] = d4 * (4.0 * d6 - 4.0) * d6;
        }
        return dArray;
    }

    public void accel() {
        double[] dArray;
        int n = 0;
        while (n < this.N) {
            double[] dArray2 = this.wallAccel(this.x[n], this.Lx);
            dArray = this.wallAccel(this.y[n], this.Ly);
            this.ax[n] = dArray2[0];
            this.ay[n] = dArray[0];
            if (n < this.Na) {
                this.Va += dArray2[1] + dArray[1];
            } else {
                this.Vb += dArray2[1] + dArray[1];
            }
            ++n;
        }
        n = 0;
        while (n < this.N - 1) {
            int n2 = n + 1;
            while (n2 < this.N) {
                dArray = this.particleAccel(n, n2);
                int n3 = n;
                this.ax[n3] = this.ax[n3] + dArray[0];
                int n4 = n;
                this.ay[n4] = this.ay[n4] + dArray[1];
                int n5 = n2;
                this.ax[n5] = this.ax[n5] - dArray[0];
                int n6 = n2;
                this.ay[n6] = this.ay[n6] - dArray[1];
                double d = (n < this.Na ? 0.5 : 0.0) + (n2 < this.Na ? 0.5 : 0.0);
                this.Va += dArray[2] * d;
                this.Vb += dArray[2] * (1.0 - d);
                ++n2;
            }
            ++n;
        }
    }

    public void step() {
        this.Kb = 0.0;
        this.Ka = 0.0;
        this.Vb = 0.0;
        this.Va = 0.0;
        int n = 0;
        while (n < this.N) {
            int n2 = n;
            this.x[n2] = this.x[n2] + (this.vx[n] * this.dt + this.ax[n] * this.dt * this.dt / 2.0);
            int n3 = n;
            this.y[n3] = this.y[n3] + (this.vy[n] * this.dt + this.ay[n] * this.dt * this.dt / 2.0);
            int n4 = n;
            this.vx[n4] = this.vx[n4] + this.ax[n] * this.dt / 2.0;
            int n5 = n;
            this.vy[n5] = this.vy[n5] + this.ay[n] * this.dt / 2.0;
            ++n;
        }
        this.accel();
        n = 0;
        while (n < this.N) {
            int n6 = n;
            this.vx[n6] = this.vx[n6] + this.ax[n] * this.dt / 2.0;
            int n7 = n;
            this.vy[n7] = this.vy[n7] + this.ay[n] * this.dt / 2.0;
            double d = (this.vx[n] * this.vx[n] + this.vy[n] * this.vy[n]) / 2.0;
            if (n < this.Na) {
                this.Ka += d;
            } else {
                this.Kb += d;
            }
            ++n;
        }
    }
}

