/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.thermalcontact;

import java.awt.Color;
import java.text.NumberFormat;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.ControlUtils;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.frames.DisplayFrame;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.thermalcontact.LJSimulation;
import org.opensourcephysics.stp.thermalcontact.ParticleBoard;
import org.opensourcephysics.stp.util.DoubleArray;

public class ThermalContactApp
extends AbstractSimulation {
    PlotFrame kinFrame;
    PlotFrame potFrame;
    DisplayFrame boardFrame = new DisplayFrame("particle display");
    ParticleBoard board1;
    ParticleBoard board2;
    LJSimulation sim1;
    LJSimulation sim2;
    double time;
    NumberFormat numberformat = NumberFormat.getInstance();

    public void initialize() {
        this.boardFrame.removeDrawable(this.board1);
        this.boardFrame.removeDrawable(this.board2);
        double d = this.control.getDouble("L");
        double d2 = Math.sqrt(3.0) / 2.0 * d;
        int n = this.control.getInt("number of yellow particles");
        int n2 = this.control.getInt("number of blue particles");
        double d3 = this.control.getDouble("\u2206t");
        this.time = 0.0;
        this.sim1 = new LJSimulation(n, 0, d, d2, d3);
        this.sim2 = new LJSimulation(0, n2, d, d2, d3);
        this.board1 = new ParticleBoard(n, 0, d, d2, 0.5);
        this.board1.pos_x = this.sim1.x;
        this.board1.pos_y = this.sim1.y;
        this.board2 = new ParticleBoard(0, n2, d, d2, 0.5);
        this.board2.pos_x = this.sim2.x;
        this.board2.pos_y = this.sim2.y;
        this.board2.Bx = d + 0.2;
        this.boardFrame.addDrawable(this.board1);
        this.boardFrame.addDrawable(this.board2);
        this.boardFrame.repaint();
        this.kinFrame.clearData();
        this.kinFrame.setPreferredMinMaxY(0.0, 10.0);
        this.kinFrame.setAutoscaleY(true);
        this.kinFrame.repaint();
        this.potFrame.clearData();
        this.potFrame.repaint();
    }

    public void reset() {
        double d = 12.0;
        this.control.setValue("L", d);
        this.control.setValue("number of yellow particles", 81);
        this.control.setValue("number of blue particles", 64);
        this.control.setValue("\u2206t", 0.01);
        this.control.clearMessages();
        this.boardFrame.removeDrawable(this.board1);
        this.boardFrame.removeDrawable(this.board2);
        this.board1 = new ParticleBoard(0, 0, d, d * Math.sqrt(3.0) / 2.0, 0.5);
        this.board2 = new ParticleBoard(0, 0, d, d * Math.sqrt(3.0) / 2.0, 0.5);
        this.board2.Bx = d + 0.2;
        this.boardFrame.addDrawable(this.board1);
        this.boardFrame.addDrawable(this.board2);
        this.boardFrame.repaint();
        this.kinFrame.clearData();
        this.kinFrame.repaint();
        this.potFrame.clearData();
        this.potFrame.repaint();
        this.enableStepsPerDisplay(true);
    }

    public void doStep() {
        double d;
        double d2 = 1.0;
        double d3 = 1.2;
        double d4 = 1.0;
        double d5 = 1.0;
        double d6 = 1.5;
        double d7 = this.control.getDouble("\u2206t");
        int n = this.sim1.N;
        this.sim1.setInteractionCoefficients(d2, d3, d4, d5, d6);
        this.sim1.setTimeStep(d7);
        if (this.sim2 != null) {
            n = Math.max(n, this.sim2.N);
            this.sim2.setInteractionCoefficients(d2, d3, d4, d5, d6);
            this.sim2.setTimeStep(d7);
        }
        int n2 = 0;
        while ((double)n2 < 100000.0 / (double)(n * n)) {
            this.sim1.step();
            if (this.sim2 != null) {
                this.sim2.step();
            }
            this.time += d7;
            ++n2;
        }
        if (this.sim2 != null) {
            this.kinFrame.append(0, this.time, this.sim1.Ka / (double)this.sim1.Na);
            this.kinFrame.append(1, this.time, this.sim2.Kb / (double)this.sim2.Nb);
            this.potFrame.append(0, this.time, this.sim1.Va / (double)this.sim1.Na);
            this.potFrame.append(1, this.time, this.sim2.Vb / (double)this.sim2.Nb);
            d = this.sim1.Ka + this.sim2.Kb + this.sim1.Va + this.sim2.Vb;
        } else {
            this.kinFrame.append(0, this.time, this.sim1.Ka / (double)this.sim1.Na);
            this.kinFrame.append(1, this.time, this.sim1.Kb / (double)this.sim1.Nb);
            this.potFrame.append(0, this.time, this.sim1.Va / (double)this.sim1.Na);
            this.potFrame.append(1, this.time, this.sim1.Vb / (double)this.sim1.Nb);
            d = this.sim1.Ka + this.sim1.Kb + this.sim1.Va + this.sim1.Vb;
        }
        this.control.clearMessages();
        this.control.println("Time = " + ControlUtils.f2(this.time));
        this.control.println("Total energy = " + ControlUtils.f2(d));
    }

    public void connectBoxes() {
        if (this.sim2 == null) {
            return;
        }
        double d = this.control.getDouble("\u2206t");
        double d2 = 1.0;
        double d3 = 1.2;
        int n = this.board1.Na;
        int n2 = this.board2.Nb;
        double d4 = this.board1.Lx + this.board2.Lx;
        double d5 = this.board1.Ly;
        LJSimulation lJSimulation = new LJSimulation(n, n2, d4, d5, d);
        lJSimulation.x = DoubleArray.concat(this.sim1.x, this.sim2.x);
        lJSimulation.y = DoubleArray.concat(this.sim1.y, this.sim2.y);
        lJSimulation.vx = DoubleArray.concat(this.sim1.vx, this.sim2.vx);
        lJSimulation.vy = DoubleArray.concat(this.sim1.vy, this.sim2.vy);
        double d6 = DoubleArray.max(this.sim1.x);
        double d7 = DoubleArray.min(this.sim2.x);
        int n3 = 0;
        while (n3 < n) {
            int n4 = n3++;
            lJSimulation.x[n4] = lJSimulation.x[n4] + (this.board1.Lx - d6 - (d2 + d3) / 4.0);
        }
        n3 = n;
        while (n3 < n + n2) {
            int n5 = n3++;
            lJSimulation.x[n5] = lJSimulation.x[n5] + (this.board1.Lx - d7 + (d2 + d3) / 4.0);
        }
        ParticleBoard particleBoard = new ParticleBoard(n, n2, d4, d5, 0.5);
        particleBoard.pos_x = lJSimulation.x;
        particleBoard.pos_y = lJSimulation.y;
        this.boardFrame.removeDrawable(this.board1);
        this.boardFrame.removeDrawable(this.board2);
        this.boardFrame.addDrawable(particleBoard);
        this.boardFrame.repaint();
        this.sim1 = lJSimulation;
        this.sim2 = null;
        this.board1 = particleBoard;
        this.board2 = null;
    }

    public ThermalContactApp() {
        this.boardFrame.setSize(640, 360);
        this.kinFrame = new PlotFrame("Time", "Kinetic Energy / Particle", "Kinetic Energy Per Particle");
        this.kinFrame.limitAutoscaleX(0.0, 0.1);
        this.kinFrame.setMarkerColor(0, Color.yellow);
        this.kinFrame.setMarkerColor(1, Color.blue);
        this.potFrame = new PlotFrame("Time", "Potential Energy / Particle", "Potential Energy Per Particle");
        this.potFrame.limitAutoscaleX(0.0, 0.1);
        this.potFrame.setMarkerColor(0, Color.yellow);
        this.potFrame.setMarkerColor(1, Color.blue);
        this.numberformat.setMaximumIntegerDigits(4);
        this.numberformat.setMinimumIntegerDigits(4);
    }

    public static void main(String[] stringArray) {
        SimulationControl simulationControl = SimulationControl.createApp(new ThermalContactApp(), stringArray);
        simulationControl.addButton("connectBoxes", "Contact");
    }
}

