/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.util;

public class MyMath {
    private MyMath() {
    }

    public static double logBase10(double d) {
        return Math.log(d) / Math.log(10.0);
    }

    public static int factorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Can't compute the factorial of a number less than 0");
        }
        int n2 = 1;
        int n3 = n;
        while (n3 > 1) {
            n2 *= n3;
            --n3;
        }
        return n2;
    }

    public static double factorial(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Can't compute the factorial of a number less than 0");
        }
        double d2 = 1.0;
        double d3 = d;
        while (d3 > 1.0) {
            d2 *= d3;
            d3 -= 1.0;
        }
        return d2;
    }

    public static double stirling(int n) {
        if (n == 0) {
            return 0.0;
        }
        double d = (double)n * Math.log(n) - (double)n + 0.5 * Math.log(Math.PI * 2 * (double)n);
        return d;
    }
}

