/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.util;

public class Rdf {
    public double bin = 0.1;
    public double[] x;
    public double[] y;
    public double Lx;
    public double Ly;
    public double rmax;
    public int N;
    public int nbins;
    public boolean pbc = true;
    public int ncorr = 0;
    double[] gr;
    public double[] rx;
    public double[] ngr;

    public Rdf() {
    }

    public Rdf(double d, double d2) {
        this.initialize(d, d2, 0.1);
    }

    public void initialize(double d, double d2, double d3) {
        this.Lx = d;
        this.Ly = d2;
        this.rmax = this.Lx > this.Ly ? 0.5 * this.Lx : 0.5 * this.Ly;
        this.bin = d3;
        this.nbins = (int)Math.ceil(this.rmax / this.bin);
        this.gr = new double[this.nbins];
        this.ngr = new double[this.nbins];
        this.rx = new double[this.nbins];
        int n = 0;
        while (n < this.nbins) {
            this.rx[n] = (double)n * this.bin;
            this.gr[n] = 0.0;
            ++n;
        }
    }

    public void reset() {
        int n = 0;
        while (n < this.nbins) {
            this.rx[n] = (double)n * this.bin;
            this.gr[n] = 0.0;
            ++n;
        }
        this.ncorr = 0;
    }

    public void append(double[] dArray, double[] dArray2) {
        this.N = dArray.length;
        ++this.ncorr;
        int n = 0;
        while (n < this.N) {
            int n2 = n + 1;
            while (n2 < this.N) {
                double d = dArray[n] - dArray[n2];
                double d2 = dArray2[n] - dArray2[n2];
                if (this.pbc) {
                    d = this.separation(d, this.Lx);
                    d2 = this.separation(d2, this.Ly);
                }
                double d3 = d * d + d2 * d2;
                int n3 = (int)(((d3 = Math.sqrt(d3)) + 1.0E-7) / this.bin);
                if (n3 < this.nbins) {
                    int n4 = n3;
                    this.gr[n4] = this.gr[n4] + 1.0;
                }
                ++n2;
            }
            ++n;
        }
    }

    public void normalize() {
        double d = Math.PI;
        int n = 0;
        int n2 = (int)(this.rmax / this.bin);
        double d2 = (double)this.N / this.Lx / this.Ly;
        double d3 = 0.5 * d2 * (double)this.ncorr * (double)this.N;
        while (n < n2) {
            double d4 = (double)n * this.bin;
            double d5 = d * ((d4 + this.bin) * (d4 + this.bin) - d4 * d4);
            this.ngr[n] = this.gr[n] / (d5 *= d3);
            ++n;
        }
    }

    public void setBinSize(double d) {
        this.bin = d;
        this.nbins = (int)(this.rmax / this.bin) + 1;
    }

    public void setPbc(boolean bl) {
        this.pbc = bl;
    }

    public double separation(double d, double d2) {
        if (d > 0.5 * d2) {
            return d - d2;
        }
        if (d < -0.5 * d2) {
            return d + d2;
        }
        return d;
    }
}

