/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.widom;

import java.text.DecimalFormat;
import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.frames.DisplayFrame;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.widom.Widom;
import org.opensourcephysics.stp.widom.WidomLoader;

public class WidomApp
extends AbstractSimulation {
    Widom mc = new Widom();
    PlotFrame cpData = new PlotFrame("mcs", "mu*", "Mean excess chemical potential");
    DisplayFrame display = new DisplayFrame("x", "y", "Lennard-Jones system");

    public void initialize() {
        this.decimalFormat = new DecimalFormat("#.###");
        this.mc.temperature = this.control.getDouble("temperature");
        this.mc.ds = 2.0 * this.control.getDouble("maximum change \u03b4");
        this.mc.Lx = this.control.getDouble("L");
        this.mc.Ly = this.control.getDouble("L");
        this.mc.N = this.control.getInt("number of particles");
        this.mc.initialize();
        this.display.addDrawable(this.mc);
        this.display.setPreferredMinMax(0.0, this.mc.Lx, 0.0, this.mc.Ly);
        this.cpData.setPreferredMinMax(0.0, 10.0, 0.0, 10.0);
        this.cpData.setAutoscaleX(true);
        this.cpData.setAutoscaleY(true);
        int n = 0;
        while (n < 100) {
            this.mc.step();
            ++n;
        }
        this.resetData();
    }

    public void doStep() {
        this.mc.step();
        this.cpData.append(0, this.mc.steps, this.mc.getMeanChemicalPotential());
    }

    public void stop() {
        this.control.println("Density = " + this.decimalFormat.format(this.mc.rho));
        this.control.println("Number of MC steps per particle = " + this.mc.steps);
        this.control.println("<E> = " + this.decimalFormat.format(this.mc.getMeanEnergy()));
        this.control.println("Specific heat = " + this.decimalFormat.format(this.mc.getHeatCapacity()));
        this.control.println("<P - P(ideal)> = " + this.decimalFormat.format(this.mc.getMeanPressure()));
        this.control.println("<mu*> = " + this.decimalFormat.format(this.mc.getMeanChemicalPotential()));
        this.control.println("acceptance ratio = " + this.decimalFormat.format(this.mc.accept / (double)(this.mc.steps * this.mc.N)));
    }

    public void startRunning() {
        double d = this.control.getDouble("L");
        double d2 = this.control.getDouble("L");
        if (d != this.mc.Lx || d2 != this.mc.Ly) {
            this.mc.Lx = d;
            this.mc.Ly = d2;
            this.display.setPreferredMinMax(0.0, d, 0.0, d2);
            this.resetData();
        }
    }

    public void reset() {
        this.control.setValue("number of particles", 100);
        this.control.setAdjustableValue("L", 20.0);
        this.control.setValue("temperature", 1.0);
        this.control.setValue("maximum change \u03b4", 0.2);
        this.enableStepsPerDisplay(true);
        this.setStepsPerDisplay(10);
        this.display.setSquareAspect(true);
    }

    public void resetData() {
        this.mc.resetAverages();
        GUIUtils.clearDrawingFrameData(false);
    }

    public static XML.ObjectLoader getLoader() {
        return new WidomLoader();
    }

    public static void main(String[] stringArray) {
        SimulationControl simulationControl = SimulationControl.createApp(new WidomApp());
        simulationControl.addButton("resetData", "Reset Data");
    }
}

