/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.xymodel;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.Random;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Measurable;
import org.opensourcephysics.stp.util.Util;

public class XYModel
implements Measurable {
    public static final double J = 1.0;
    public static final double TWOPI = Math.PI * 2;
    double beta;
    double temperature;
    double deltatemperature;
    int time;
    double energyAccumulator;
    double energySquaredAccumulator;
    int L;
    int numberOfSpins;
    int[] nnOffSetX;
    int[] nnOffSetY;
    double[] correlation;
    double[] norm;
    double energy;
    double magnetizationX;
    double magnetizationY;
    double magnetizationXAccumulator;
    double magnetizationYAccumulator;
    double magnetizationSquaredAccumulator;
    double magnetizationAccumulator;
    double[][] spin;
    int mcs;
    int nequil = 0;
    int acceptAccumulator;
    double dThetaMax;
    int cellSizeX;
    int cellSizeY;
    GeneralPath vectorpath;
    Random random = new Random();
    boolean vorticityDisplay = false;
    int vortexAccumulator;
    boolean keepVorticity = true;
    long seed;
    String initialConfiguration;

    public XYModel() {
        this.setSeed(System.currentTimeMillis());
        this.setLinearDimension(10);
        this.setTemperature(2.0);
        this.setDThetaMax(Math.PI * 2);
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[2] = -1;
        this.nnOffSetX = nArray;
        int[] nArray2 = new int[4];
        nArray2[1] = 1;
        nArray2[3] = -1;
        this.nnOffSetY = nArray2;
    }

    public void fillSpinsUp() {
        int n = 0;
        while (n < this.spin.length) {
            int n2 = 0;
            while (n2 < this.spin[0].length) {
                this.spin[n][n2] = Math.PI * 2;
                ++n2;
            }
            ++n;
        }
    }

    public void setNequil(int n) {
        this.nequil = n;
    }

    public void setKeepVorticity(boolean bl) {
        this.keepVorticity = bl;
    }

    public void setTemperature(double d) {
        this.temperature = d >= 0.0 && d <= 1.0E-6 ? 1.0E-7 : Math.max(0.0, d);
        this.beta = 1.0 / this.temperature;
    }

    public void setDThetaMax(double d) {
        this.dThetaMax = d;
    }

    public void showVortex(boolean bl) {
        this.vorticityDisplay = bl;
    }

    public void setMcs(int n) {
        this.mcs = n;
    }

    public void setSeed(long l) {
        this.seed = l;
        this.random.setSeed(this.seed);
    }

    public int getMcs() {
        return this.mcs;
    }

    public boolean isCompleted() {
        return this.time > this.mcs;
    }

    public void setLinearDimension(int n) {
        this.L = n;
        this.spin = new double[this.L][this.L];
        this.numberOfSpins = this.L * this.L;
        this.correlation = new double[this.L];
        this.norm = new double[this.L];
    }

    public double getTotalEnergy() {
        double d = 0.0;
        int n = 0;
        while (n < this.L) {
            int n2 = 0;
            while (n2 < this.L) {
                d += Math.cos(this.spin[n][n2] - this.spin[Util.pbc(n + 1, this.L)][n2]);
                d += Math.cos(this.spin[n][n2] - this.spin[n][Util.pbc(n2 + 1, this.L)]);
                ++n2;
            }
            ++n;
        }
        return -1.0 * d;
    }

    public void correlationFunction() {
        int n = this.L / 2;
        int n2 = 0;
        while (n2 < this.L) {
            int n3 = 0;
            while (n3 < this.L) {
                int n4 = 0;
                while (n4 < this.L) {
                    int n5 = 0;
                    while (n5 < this.L) {
                        int n6;
                        int n7;
                        int n8 = Math.abs(n4 - n2);
                        if (n8 > n) {
                            n8 -= this.L;
                        }
                        if ((n7 = Math.abs(n5 - n3)) > n) {
                            n7 -= this.L;
                        }
                        int n9 = n6 = (int)Math.sqrt(0.2 + (double)(n8 * n8) + (double)(n7 * n7));
                        this.correlation[n9] = this.correlation[n9] + Math.cos(this.spin[n2][n3] - this.spin[n4][n5]);
                        int n10 = n6;
                        this.norm[n10] = this.norm[n10] + 1.0;
                        ++n5;
                    }
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
    }

    public void setSpin(int n, int n2, double d) {
        while (d < 0.0) {
            d += Math.PI * 2;
        }
        this.spin[n][n2] = d % (Math.PI * 2);
    }

    public void updateStatistics(double d, double d2, double d3) {
        this.energyAccumulator += d;
        this.energySquaredAccumulator += d * d;
        this.magnetizationSquaredAccumulator += d2 * d2 + d3 * d3;
        this.magnetizationAccumulator += Math.sqrt(d2 * d2 + d3 * d3);
        this.magnetizationXAccumulator += d2;
        this.magnetizationYAccumulator += d3;
    }

    public double boltzmannProbability(double d) {
        return Math.exp(-this.beta * d);
    }

    public double deltaEnergy(int n, int n2, double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        int n3 = 0;
        while (n3 < this.nnOffSetY.length) {
            d2 += Math.cos(this.spin[n][n2] - this.spin[Util.pbc(n + this.nnOffSetX[n3], this.L)][Util.pbc(n2 + this.nnOffSetY[n3], this.L)]);
            d3 += Math.cos(d - this.spin[Util.pbc(n + this.nnOffSetX[n3], this.L)][Util.pbc(n2 + this.nnOffSetY[n3], this.L)]);
            ++n3;
        }
        return -1.0 * (d3 - d2);
    }

    public void initialize() {
        int n;
        int n2;
        if (this.initialConfiguration.equals("random")) {
            n2 = 0;
            while (n2 < this.spin.length) {
                n = 0;
                while (n < this.spin[0].length) {
                    this.spin[n2][n] = this.random.nextDouble() * (Math.PI * 2);
                    ++n;
                }
                ++n2;
            }
        } else {
            n2 = 0;
            while (n2 < this.spin.length) {
                n = 0;
                while (n < this.spin[0].length) {
                    this.spin[n2][n] = 0.0;
                    ++n;
                }
                ++n2;
            }
        }
        this.energy = this.getTotalEnergy();
        this.calculateMagnetization();
        n2 = 0;
        while (n2 < this.nequil) {
            this.metropolis();
            ++n2;
        }
        this.clearData();
    }

    public void step() {
        this.metropolis();
        this.updateStatistics(this.energy, this.magnetizationX, this.magnetizationY);
        ++this.time;
        if (this.keepVorticity) {
            this.vortexAccumulator += this.getTotalNumberOfVortices();
        }
    }

    public void compute() {
        this.initialize();
        while (!this.isCompleted()) {
            this.step();
        }
    }

    public void metropolis() {
        int n = 1;
        while (n <= this.numberOfSpins) {
            int n2 = this.random.nextInt(this.L);
            int n3 = this.random.nextInt(this.L);
            double d = this.spin[n2][n3];
            double d2 = (2.0 * this.random.nextDouble() - 1.0) * this.dThetaMax;
            double d3 = d + d2;
            double d4 = this.deltaEnergy(n2, n3, d3);
            if (this.random.nextDouble() < this.boltzmannProbability(d4)) {
                double d5 = Math.cos(d3) - Math.cos(this.spin[n2][n3]);
                double d6 = Math.sin(d3) - Math.sin(this.spin[n2][n3]);
                this.setSpin(n2, n3, d3);
                ++this.acceptAccumulator;
                this.energy += d4;
                this.magnetizationX += d5;
                this.magnetizationY += d6;
            }
            ++n;
        }
    }

    public void clearData() {
        this.energyAccumulator = 0.0;
        this.energySquaredAccumulator = 0.0;
        this.acceptAccumulator = 0;
        if (this.keepVorticity) {
            this.vortexAccumulator = 0;
        }
        this.magnetizationXAccumulator = 0.0;
        this.magnetizationYAccumulator = 0.0;
        this.magnetizationSquaredAccumulator = 0.0;
        this.magnetizationAccumulator = 0.0;
        this.time = 0;
        int n = 0;
        while (n < this.L) {
            this.correlation[n] = 0.0;
            ++n;
        }
    }

    public double getTemperature() {
        return this.temperature;
    }

    public double getSeed() {
        return this.seed;
    }

    public int getTime() {
        return this.time;
    }

    public double getAcceptanceProbability() {
        return (double)this.acceptAccumulator / ((double)this.time * (double)this.numberOfSpins);
    }

    public double getMeanEnergy() {
        return this.energyAccumulator * 1.0 / (double)this.time;
    }

    public double getMeanEnergySquared() {
        return this.energySquaredAccumulator / (double)this.time;
    }

    public double getMeanMagnetizationX() {
        return this.magnetizationXAccumulator / (double)this.time;
    }

    public double getMeanMagnetizationY() {
        return this.magnetizationYAccumulator / (double)this.time;
    }

    public double getMeanMagnetizationSquared() {
        return this.magnetizationSquaredAccumulator / (double)this.time;
    }

    public double getMeanMagnetization() {
        return this.magnetizationAccumulator / (double)this.time;
    }

    public double getHeatCapacity() {
        return 1.0 / (this.getTemperature() * this.getTemperature()) * (this.getMeanEnergySquared() - this.getMeanEnergy() * this.getMeanEnergy());
    }

    public double getSusceptibility() {
        return (this.getMeanMagnetizationSquared() - this.getMeanMagnetization() * this.getMeanMagnetization()) / this.getTemperature();
    }

    public int getTotalNumberOfVortices() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.L) {
            int n3 = 0;
            while (n3 < this.L) {
                n += Math.abs(this.identifyVortex(n2, n3));
                ++n3;
            }
            ++n2;
        }
        return n;
    }

    public double getMeanNumberOfVortices() {
        if (!this.keepVorticity) {
            return -1.0;
        }
        return (double)this.vortexAccumulator / (double)this.time;
    }

    public double getVorticity() {
        if (!this.keepVorticity) {
            return -1.0;
        }
        return this.getMeanNumberOfVortices() / (double)(this.L * this.L);
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.spin == null) {
            return;
        }
        float f = Math.max(1.0f, (float)drawingPanel.getSize().width / (float)this.spin.length / 2.0f);
        f = Math.min(20.0f, f);
        this.vectorpath = XYModel.newFilledVectorPath(f);
        this.cellSizeX = 1 + (drawingPanel.xToPix(this.L) - drawingPanel.xToPix(0.0)) / this.L;
        this.cellSizeY = 1 + (drawingPanel.yToPix(this.L) - drawingPanel.yToPix(0.0)) / this.L;
        int n = 0;
        int n2 = 0;
        while (n2 < this.L) {
            int n3 = 0;
            while (n3 < this.L) {
                this.drawSpin(drawingPanel, graphics, n2, n3);
                if (this.vorticityDisplay) {
                    n = this.identifyVortex(n2, n3);
                    if (n == 1) {
                        this.drawBox(graphics, drawingPanel, Color.red, n2, n3);
                    } else if (n == -1) {
                        this.drawBox(graphics, drawingPanel, Color.blue, n2, n3);
                    }
                }
                ++n3;
            }
            ++n2;
        }
    }

    public double getXMin() {
        return 0.0;
    }

    public double getYMin() {
        return 0.0;
    }

    public double getXMax() {
        return this.L;
    }

    public double getYMax() {
        return this.L;
    }

    public boolean isMeasured() {
        return this.spin != null;
    }

    public void setdeltatemperature(double d) {
        this.deltatemperature = d;
    }

    public double getdeltatemperature() {
        return this.deltatemperature;
    }

    protected void calculateMagnetization() {
        this.magnetizationX = 0.0;
        this.magnetizationY = 0.0;
        int n = 0;
        while (n < this.L) {
            int n2 = 0;
            while (n2 < this.L) {
                this.magnetizationX += Math.cos(this.spin[n][n2]);
                this.magnetizationY += Math.sin(this.spin[n][n2]);
                ++n2;
            }
            ++n;
        }
    }

    protected int identifyVortex(int n, int n2) {
        double d = 0.0;
        double[] dArray = new double[]{this.spin[n][n2], this.spin[n][Util.pbc(n2 + 1, this.L)], this.spin[Util.pbc(n + 1, this.L)][Util.pbc(n2 + 1, this.L)], this.spin[Util.pbc(n + 1, this.L)][n2]};
        int n3 = 0;
        while (n3 < 3) {
            double d2 = dArray[n3 + 1] - dArray[n3];
            d = d2 <= Math.PI && d2 > -Math.PI ? (d += d2) : (d2 > Math.PI ? (d += d2 - Math.PI * 2) : (d += d2 + Math.PI * 2));
            ++n3;
        }
        if (d > Math.PI) {
            return 1;
        }
        if (d < -Math.PI) {
            return -1;
        }
        return 0;
    }

    protected void drawSpin(DrawingPanel drawingPanel, Graphics graphics, int n, int n2) {
        double d = this.spin[n][n2];
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.black);
        AffineTransform affineTransform = new AffineTransform(d2, -d3, d3, d2, (double)(drawingPanel.xToPix(n) + this.cellSizeX / 2), (double)(drawingPanel.yToPix(n2) + this.cellSizeY / 2));
        Shape shape = this.vectorpath.createTransformedShape(affineTransform);
        graphics2D.fill(shape);
        graphics2D.draw(shape);
    }

    static GeneralPath newFilledVectorPath(float f) {
        float f2 = 1.0f + f / 5.0f;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(-f / 2.0f, 1.0f);
        generalPath.lineTo(f / 2.0f - f2, 1.0f);
        generalPath.lineTo(f / 2.0f - f2, 2.0f * f2 / 3.0f);
        generalPath.lineTo(f / 2.0f, 0.0f);
        generalPath.lineTo(f / 2.0f - f2, -2.0f * f2 / 3.0f);
        generalPath.lineTo(f / 2.0f - f2, -1.0f);
        generalPath.moveTo(-f / 2.0f, -1.0f);
        return generalPath;
    }

    private void drawBox(Graphics graphics, DrawingPanel drawingPanel, Color color, int n, int n2) {
        graphics.setColor(color);
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        if (Util.pbc(n + 1, this.L) == n + 1 && Util.pbc(n2 + 1, this.L) == n2 + 1) {
            nArray[0] = drawingPanel.xToPix(n) + this.cellSizeX / 2;
            nArray2[0] = drawingPanel.yToPix(n2) + this.cellSizeY / 2;
            nArray[1] = drawingPanel.xToPix(Util.pbc(n + 1, this.L)) + this.cellSizeX / 2;
            nArray2[1] = drawingPanel.yToPix(n2) + this.cellSizeY / 2;
            nArray[2] = drawingPanel.xToPix(Util.pbc(n + 1, this.L)) + this.cellSizeX / 2;
            nArray2[2] = drawingPanel.yToPix(Util.pbc(n2 + 1, this.L)) + this.cellSizeY / 2;
            nArray[3] = drawingPanel.xToPix(n) + this.cellSizeX / 2;
            nArray2[3] = drawingPanel.yToPix(Util.pbc(n2 + 1, this.L)) + this.cellSizeY / 2;
            graphics.drawPolygon(nArray, nArray2, 4);
        } else if (Util.pbc(n + 1, this.L) != n + 1 && Util.pbc(n2 + 1, this.L) == n2 + 1) {
            nArray[0] = drawingPanel.xToPix(n) + this.cellSizeX / 2;
            nArray2[0] = drawingPanel.yToPix(n2) + this.cellSizeY / 2;
            nArray[1] = drawingPanel.xToPix(drawingPanel.getXMax());
            nArray2[1] = drawingPanel.yToPix(n2) + this.cellSizeY / 2;
            nArray[2] = drawingPanel.xToPix(drawingPanel.getXMax());
            nArray2[2] = drawingPanel.yToPix(Util.pbc(n2 + 1, this.L)) + this.cellSizeY / 2;
            nArray[3] = drawingPanel.xToPix(n) + this.cellSizeX / 2;
            nArray2[3] = drawingPanel.yToPix(Util.pbc(n2 + 1, this.L)) + this.cellSizeY / 2;
            graphics.drawPolygon(nArray, nArray2, 4);
            nArray[0] = drawingPanel.xToPix(drawingPanel.getXMin());
            nArray2[0] = drawingPanel.yToPix(n2) + this.cellSizeY / 2;
            nArray[1] = drawingPanel.xToPix(Util.pbc(n + 1, this.L)) + this.cellSizeX / 2;
            nArray2[1] = drawingPanel.yToPix(n2) + this.cellSizeY / 2;
            nArray[2] = drawingPanel.xToPix(Util.pbc(n + 1, this.L)) + this.cellSizeX / 2;
            nArray2[2] = drawingPanel.yToPix(Util.pbc(n2 + 1, this.L)) + this.cellSizeY / 2;
            nArray[3] = drawingPanel.xToPix(drawingPanel.getXMin());
            nArray2[3] = drawingPanel.yToPix(Util.pbc(n2 + 1, this.L)) + this.cellSizeY / 2;
            graphics.drawPolygon(nArray, nArray2, 4);
        } else if (Util.pbc(n + 1, this.L) == n + 1 && Util.pbc(n2 + 1, this.L) != n2 + 1) {
            nArray[0] = drawingPanel.xToPix(n) + this.cellSizeX / 2;
            nArray2[0] = drawingPanel.yToPix(n2) + this.cellSizeY / 2;
            nArray[1] = drawingPanel.xToPix(Util.pbc(n + 1, this.L)) + this.cellSizeX / 2;
            nArray2[1] = drawingPanel.yToPix(n2) + this.cellSizeY / 2;
            nArray[2] = drawingPanel.xToPix(Util.pbc(n + 1, this.L)) + this.cellSizeX / 2;
            nArray2[2] = drawingPanel.yToPix(drawingPanel.getYMax());
            nArray[3] = drawingPanel.xToPix(n) + this.cellSizeX / 2;
            nArray2[3] = drawingPanel.yToPix(drawingPanel.getYMax());
            graphics.drawPolygon(nArray, nArray2, 4);
            nArray[0] = drawingPanel.xToPix(n) + this.cellSizeX / 2;
            nArray2[0] = drawingPanel.yToPix(Util.pbc(n2 + 1, this.L)) + this.cellSizeY / 2;
            nArray[1] = drawingPanel.xToPix(Util.pbc(n + 1, this.L)) + this.cellSizeX / 2;
            nArray2[1] = drawingPanel.yToPix(Util.pbc(n2 + 1, this.L)) + this.cellSizeY / 2;
            nArray[2] = drawingPanel.xToPix(Util.pbc(n + 1, this.L)) + this.cellSizeX / 2;
            nArray2[2] = drawingPanel.yToPix(drawingPanel.getYMin());
            nArray[3] = drawingPanel.xToPix(n) + this.cellSizeX / 2;
            nArray2[3] = drawingPanel.yToPix(drawingPanel.getYMin());
            graphics.drawPolygon(nArray, nArray2, 4);
        }
    }
}

