/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.stp.xymodel;

import org.opensourcephysics.controls.AbstractSimulation;
import org.opensourcephysics.controls.ControlUtils;
import org.opensourcephysics.controls.SimulationControl;
import org.opensourcephysics.frames.PlotFrame;
import org.opensourcephysics.stp.xymodel.XYModel;

public class XYScanApp
extends AbstractSimulation {
    XYModel xyModel = new XYModel();
    PlotFrame heatFrame = new PlotFrame("temperature", "C", "C(t) v T");
    PlotFrame vortexFrame = new PlotFrame("temperature", "vorticty", "Vorticity versus T");
    PlotFrame chiFrame = new PlotFrame("temperature", "Chi", "Chi versus T");
    int N;

    public XYScanApp() {
        this.xyModel = new XYModel();
    }

    public void initialize() {
        int n = this.control.getInt("linear dimension of lattice");
        this.N = n * n;
        double d = this.control.getDouble("start temperature");
        double d2 = this.control.getDouble("temperature interval");
        int n2 = this.control.getInt("MC steps per spin for equilibrium");
        int n3 = this.control.getInt("MC steps per spin for data");
        double d3 = this.control.getDouble("Maximum angle change");
        this.xyModel.initialConfiguration = this.control.getString("initial configuration");
        this.heatFrame.setAnimated(true);
        this.xyModel.setdeltatemperature(d2);
        this.xyModel.setLinearDimension(n);
        this.xyModel.setKeepVorticity(true);
        this.xyModel.setMcs(n3);
        this.xyModel.setNequil(n2);
        this.xyModel.setDThetaMax(d3);
        this.xyModel.setTemperature(d);
        this.xyModel.fillSpinsUp();
        this.xyModel.initialize();
    }

    public void reset() {
        this.control.setValue("linear dimension of lattice", 20);
        this.control.setValue("start temperature", 0.5);
        this.control.setAdjustableValue("temperature interval", 0.1);
        this.control.setValue("initial configuration", "ordered");
        this.control.setValue("MC steps per spin for equilibrium", 100);
        this.control.setValue("MC steps per spin for data", 10000);
        this.control.setValue("Maximum angle change", 1.5);
        this.enableStepsPerDisplay(true);
    }

    public static void main(String[] stringArray) {
        SimulationControl.createApp(new XYScanApp(), stringArray);
    }

    protected void doStep() {
        double d = this.xyModel.getTemperature();
        this.xyModel.setTemperature(d += this.xyModel.getdeltatemperature());
        this.xyModel.initialize();
        this.xyModel.compute();
        this.heatFrame.append(0, d, this.xyModel.getHeatCapacity() / (double)this.N);
        this.vortexFrame.append(0, d, this.xyModel.getVorticity() / (double)this.N);
        this.chiFrame.append(0, d, this.xyModel.getSusceptibility() / (double)this.N);
        this.control.clearMessages();
        this.control.println("temperature = " + ControlUtils.f2(this.xyModel.getTemperature()));
    }
}

