/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.opensourcephysics.controls.ListChooser;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.tools.DataFunctionPanel;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.DataToolTab;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBuilder
extends FunctionTool {
    private DataTool dataTool;
    private JButton loadButton;
    private JButton saveButton;

    public DataBuilder(DataTool dataTool) {
        super((Component)dataTool);
        this.dataTool = dataTool;
        this.setHelpPath("data_builder_help.html");
        this.createButtons();
        this.setToolbarComponents(new Component[]{this.loadButton, this.saveButton});
    }

    private void createButtons() {
        String string = "/org/opensourcephysics/resources/tools/images/open.gif";
        ImageIcon imageIcon = ResourceLoader.getIcon(string);
        this.loadButton = new JButton(imageIcon);
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = OSPRuntime.createChooser(ToolsRes.getString("DataBuilder.Load.Title"), ToolsRes.getString("FileChooser.Filter.XMLFiles"), new String[]{"xml"});
                int n = jFileChooser.showOpenDialog(DataBuilder.this.dataTool);
                if (n == 0) {
                    OSPRuntime.chooserDir = jFileChooser.getCurrentDirectory().toString();
                    String string = jFileChooser.getSelectedFile().getAbsolutePath();
                    XMLControlElement xMLControlElement = new XMLControlElement(string);
                    if (xMLControlElement.failedToRead()) {
                        JOptionPane.showMessageDialog(DataBuilder.this.dataTool, ToolsRes.getString("Dialog.Invalid.Message"), ToolsRes.getString("Dialog.Invalid.Title"), 0);
                        return;
                    }
                    Class<?> clazz = xMLControlElement.getObjectClass();
                    if (DataFunctionPanel.class.isAssignableFrom(clazz)) {
                        if (DataBuilder.this.chooseDataFunctions(xMLControlElement, "Load", null)) {
                            xMLControlElement.loadObject(DataBuilder.this.getSelectedPanel());
                        }
                    } else {
                        JOptionPane.showMessageDialog(DataBuilder.this.dataTool, ToolsRes.getString("DataBuilder.Dialog.WrongType.Message"), ToolsRes.getString("DataBuilder.Dialog.WrongType.Title"), 0);
                    }
                }
            }
        });
        string = "/org/opensourcephysics/resources/tools/images/save.gif";
        ImageIcon imageIcon2 = ResourceLoader.getIcon(string);
        this.saveButton = new JButton(imageIcon2);
        this.saveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser;
                int n;
                XMLControlElement xMLControlElement = new XMLControlElement(DataBuilder.this.getSelectedPanel());
                if (DataBuilder.this.chooseDataFunctions(xMLControlElement, "Save", null) && (n = (jFileChooser = OSPRuntime.createChooser(ToolsRes.getString("DataBuilder.Save.Title"), ToolsRes.getString("FileChooser.Filter.XMLFiles"), new String[]{"xml"})).showSaveDialog(DataBuilder.this.dataTool)) == 0) {
                    int n2;
                    OSPRuntime.chooserDir = jFileChooser.getCurrentDirectory().toString();
                    File file = jFileChooser.getSelectedFile();
                    String string = file.getAbsolutePath();
                    if (!"xml".equals(XML.getExtension(string))) {
                        string = String.valueOf(XML.stripExtension(string)) + ".xml";
                        file = new File(string);
                    }
                    if (file.exists() && (n2 = JOptionPane.showConfirmDialog(DataBuilder.this.dataTool, " \"" + file.getName() + "\" " + MediaRes.getString("VideoIO.Dialog.FileExists.Message"), MediaRes.getString("VideoIO.Dialog.FileExists.Title"), 2)) != 0) {
                        return;
                    }
                    xMLControlElement.write(string);
                }
            }
        });
    }

    @Override
    protected void refreshGUI() {
        super.refreshGUI();
        this.dropdown.setToolTipText(ToolsRes.getString("DataTool.DataBuilder.Dropdown.Tooltip"));
        this.setTitle(ToolsRes.getString("DataTool.DataBuilder.Title"));
        if (this.loadButton != null) {
            FunctionPanel functionPanel = this.getSelectedPanel();
            this.loadButton.setEnabled(functionPanel != null);
            this.saveButton.setEnabled(functionPanel != null);
            this.loadButton.setToolTipText(ToolsRes.getString("DataBuilder.Button.Load.Tooltip"));
            this.saveButton.setToolTipText(ToolsRes.getString("DataBuilder.Button.Save.Tooltip"));
        }
    }

    protected void refreshPanels() {
        Object object;
        Iterator iterator;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.dataTool.tabbedPane.getTabCount()) {
            iterator = this.dataTool.getTab(n);
            arrayList.add(((Component)((Object)iterator)).getName());
            if (this.getPanel(((Component)((Object)iterator)).getName()) == null) {
                object = new DataFunctionPanel(((DataToolTab)((Object)iterator)).dataManager);
                this.addPanel(((Component)((Object)iterator)).getName(), (FunctionPanel)object);
            }
            ++n;
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        iterator = this.panels.keySet().iterator();
        while (iterator.hasNext()) {
            object = ((String)iterator.next()).toString();
            if (arrayList.contains(object)) continue;
            arrayList2.add(object);
        }
        iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            object = ((String)iterator.next()).toString();
            this.removePanel((String)object);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean chooseDataFunctions(XMLControl xMLControl, String string, Collection<String[]> collection) {
        void e;
        Object object2;
        ListChooser listChooser = new ListChooser(ToolsRes.getString("DataBuilder." + string + ".Title"), ToolsRes.getString("DataBuilder." + string + ".Message"), this);
        listChooser.setSeparator(" = ");
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        ArrayList arrayList5 = (ArrayList)xMLControl.getObject("functions");
        for (Object object2 : arrayList5) {
            String[] stringArray = (String[])object2;
            arrayList.add(stringArray);
            arrayList2.add(stringArray);
            arrayList3.add(stringArray[0]);
            arrayList4.add(stringArray[1]);
        }
        object2 = new boolean[arrayList2.size()];
        boolean n = false;
        while (e < ((E)object2).length) {
            object2[e] = true;
            ++e;
        }
        if (listChooser.choose((Collection<?>)arrayList2, (Collection<String>)arrayList3, (Collection<?>)arrayList4, (boolean[])object2)) {
            for (Object e2 : arrayList) {
                if (arrayList2.contains(e2)) continue;
                arrayList5.remove(e2);
            }
            xMLControl.setValue("functions", arrayList5);
            return true;
        }
        return false;
    }
}

