/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.DiagnosticsForXuggle;
import org.opensourcephysics.tools.ToolsRes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionsManager {
    private static final ExtensionsManager MANAGER = new ExtensionsManager();
    private static boolean isReady = false;
    private static Set<File> allJavaExtensionDirectories = new TreeSet<File>();
    private static int vmsFound = 0;
    private static Timer timer;
    String xuggleHome = System.getenv("XUGGLE_HOME");
    ExtensionsFilter extFilter = new ExtensionsFilter();

    public static void main(String[] stringArray) {
        timer = new Timer(30000, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                int n = JOptionPane.showConfirmDialog(null, String.valueOf(ToolsRes.getString("ExtensionsManager.Dialog.SlowSearch.Message1")) + "\n" + ToolsRes.getString("ExtensionsManager.Dialog.SlowSearch.Message2") + " " + vmsFound + ".\n" + ToolsRes.getString("ExtensionsManager.Dialog.SlowSearch.Message3"), ToolsRes.getString("ExtensionsManager.Dialog.SlowSearch.Title"), 0);
                if (n == 1) {
                    Set set = allJavaExtensionDirectories;
                    synchronized (set) {
                        ExtensionsManager.printExtensionDirectoriesForBitrock(allJavaExtensionDirectories);
                    }
                    System.exit(0);
                } else {
                    timer.restart();
                }
            }
        });
        timer.setRepeats(true);
        timer.start();
        System.exit(0);
    }

    public static ExtensionsManager getManager() {
        return MANAGER;
    }

    public static boolean isReady() {
        return isReady;
    }

    private ExtensionsManager() {
    }

    /*
     * WARNING - void declaration
     */
    private static void printExtensionDirectoriesForBitrock(Set<File> set) {
        void var3_7;
        String string = " ";
        StringBuffer stringBuffer = new StringBuffer(2);
        for (File object2 : set) {
            String string2 = XML.forwardSlash(object2.getPath());
            stringBuffer.append("\"" + string2 + "\"" + string);
        }
        String string3 = stringBuffer.toString();
        if (string3.length() >= string.length()) {
            String string4 = string3.substring(0, string3.length() - string.length());
        }
        System.out.print((String)var3_7);
    }

    public boolean copyXuggleJarsTo(File file) {
        if (this.xuggleHome == null || file == null) {
            return false;
        }
        if (!new File(String.valueOf(this.xuggleHome) + "/share/java/jars/xuggle-xuggler.jar").exists()) {
            return false;
        }
        File file2 = new File(String.valueOf(this.xuggleHome) + "/share/java/jars");
        String[] stringArray = DiagnosticsForXuggle.xuggleJarNames;
        File file3 = new File(file2, stringArray[0]);
        long l = file3.length();
        File file4 = new File(file, stringArray[0]);
        if (!file4.exists() || file4.length() != l) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                file3 = new File(file2, string);
                file4 = new File(file, string);
                if (!this.copyFile(file3, file4)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public File getXuggleJar() {
        if (this.xuggleHome == null) {
            return null;
        }
        File file = new File(String.valueOf(this.xuggleHome) + "/share/java/jars/xuggle-xuggler.jar");
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public boolean copyQTJavaTo(File file) {
        File file2 = this.getQTJavaZip();
        if (file2 == null) {
            return false;
        }
        File file3 = new File(file, file2.getName());
        long l = file2.lastModified();
        if (!file3.exists() || file3.lastModified() < l) {
            return this.copyFile(file2, file3);
        }
        return false;
    }

    public File getQTJavaZip() {
        String string = "QTJava.zip";
        String string2 = OSPRuntime.getLaunchJarPath();
        string2 = string2 != null ? XML.getDirectoryPath(string2) : ".";
        String[] stringArray = new String[]{string2, "C:/Program Files/QuickTime/QTSystem", "C:/Program Files (x86)/QuickTime/QTSystem", "C:/windows/system32", "C:/windows/system", "C:/winNT/system32", "system/library/java/extensions"};
        long l = 0L;
        File file = null;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            long l2;
            String string3 = stringArray2[n2];
            File file2 = new File(string3, string);
            if (file2.exists() && (l2 = file2.lastModified()) > l) {
                l = l2;
                file = file2;
            }
            ++n2;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<File> findAllJavaExtensionDirectories() {
        if (!isReady) {
            CharSequence charSequence;
            vmsFound = 0;
            TreeSet<CharSequence> treeSet = new TreeSet<CharSequence>();
            TreeSet<Object> treeSet2 = new TreeSet<Object>();
            try {
                Object object;
                Object object2;
                charSequence = XML.forwardSlash(System.getProperty("java.ext.dirs"));
                String object3 = System.getProperty("path.separator");
                int n = ((String)charSequence).indexOf(object3);
                while (n > -1) {
                    treeSet.add(((String)charSequence).substring(0, n));
                    charSequence = ((String)charSequence).substring(n + 1);
                    n = ((String)charSequence).indexOf(object3);
                }
                if (!"".equals(charSequence)) {
                    treeSet.add(charSequence);
                }
                block6: for (String string : treeSet) {
                    object2 = new File(string);
                    if (!((File)object2).exists()) continue;
                    object = allJavaExtensionDirectories;
                    synchronized (object) {
                        allJavaExtensionDirectories.add((File)object2);
                        ++vmsFound;
                    }
                    if (OSPRuntime.isMac()) {
                        while (object2 != null && ((File)object2).getPath().indexOf("/JavaVirtualMachines") > -1) {
                            if (((File)object2).getName().equals("JavaVirtualMachines")) {
                                treeSet2.add(object2);
                                continue block6;
                            }
                            object2 = ((File)object2).getParentFile();
                        }
                        continue;
                    }
                    if (!OSPRuntime.isLinux()) continue;
                    while (object2 != null && ((File)object2).getPath().indexOf("/jvm") > -1) {
                        if (((File)object2).getName().equals("jvm")) {
                            treeSet2.add(object2);
                            continue block6;
                        }
                        object2 = ((File)object2).getParentFile();
                    }
                }
                if (OSPRuntime.isWindows()) {
                    String string = System.getenv("ProgramFiles");
                    String string2 = System.getenv("ProgramW6432");
                    object2 = System.getenv("ProgramFiles(x86)");
                    if (string != null && ((File)(object = new File(string, "Java"))).exists()) {
                        treeSet2.add(object);
                    }
                    if (string2 != null && ((File)(object = new File(string2, "Java"))).exists()) {
                        treeSet2.add(object);
                    }
                    if (object2 != null && ((File)(object = new File((String)object2, "Java"))).exists()) {
                        treeSet2.add(object);
                    }
                }
                for (File file : treeSet2) {
                    this.findJavaExtensionDirectories(file, allJavaExtensionDirectories);
                }
                isReady = true;
            }
            catch (Exception exception) {}
            charSequence = new StringBuffer("Java extension directories: ");
            for (File file : allJavaExtensionDirectories) {
                ((StringBuffer)charSequence).append(String.valueOf(file.getAbsolutePath()) + ", ");
            }
            OSPLog.fine(((StringBuffer)charSequence).toString());
        }
        return new TreeSet<File>(allJavaExtensionDirectories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<File> findJavaExtensionDirectories() {
        Set<File> set = this.findAllJavaExtensionDirectories();
        TreeSet<File> treeSet = new TreeSet<File>();
        Set<File> set2 = set;
        synchronized (set2) {
            for (File file : set) {
                if (file.getParentFile() == null || file.getParentFile().getParentFile() == null) continue;
                File file2 = file.getParentFile().getParentFile();
                int n = file2.getPath().indexOf("jdk");
                n = Math.max(n, file2.getPath().indexOf("jre"));
                int n2 = file2.getPath().indexOf("1.5.");
                n2 = Math.max(n2, file2.getPath().indexOf("-5-"));
                n2 = Math.max(n2, file2.getPath().indexOf("1.4."));
                n2 = Math.max(n2, file2.getPath().indexOf("1.3."));
                n2 = Math.max(n2, file2.getPath().indexOf("1.2."));
                n2 = Math.max(n2, file2.getPath().indexOf("1.3."));
                n2 = Math.max(n2, file2.getPath().indexOf("1.2."));
                if (n <= -1 || n2 <= -1) continue;
                treeSet.add(file);
            }
            set.removeAll(treeSet);
            vmsFound -= treeSet.size() + 1;
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<File> findJavaExtensionDirectories(File file, Set<File> set) {
        if (file == null) {
            return set;
        }
        try {
            if (!file.getCanonicalPath().equals(file.getAbsolutePath())) {
                return set;
            }
        }
        catch (IOException iOException) {}
        String[] stringArray = file.list();
        if (stringArray != null && stringArray.length > 0) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                File file2 = new File(file, string);
                if (this.extFilter.accept(file2, file2.getName())) {
                    Set<File> set2 = set;
                    synchronized (set2) {
                        set.add(file2);
                        ++vmsFound;
                    }
                } else {
                    this.findJavaExtensionDirectories(file2, set);
                }
                ++n2;
            }
        }
        return set;
    }

    public boolean is32BitVM(String string) {
        if (OSPRuntime.isWindows()) {
            String string2 = System.getenv("ProgramFiles(x86)");
            if (string2 != null) {
                return string.contains(string2);
            }
            return true;
        }
        if (OSPRuntime.isMac()) {
            return true;
        }
        return OSPRuntime.getVMBitness() == 32;
    }

    public TreeSet<String> getPublicJREs(int n) {
        Object object;
        TreeSet<String> treeSet = this.getAllJREs(n);
        if (OSPRuntime.isWindows()) {
            object = treeSet.iterator();
            while (object.hasNext()) {
                String string = object.next();
                if (string.indexOf("jdk") <= -1) continue;
                object.remove();
            }
        }
        object = new StringBuffer(String.valueOf(n) + "-bit JREs: ");
        for (String string : treeSet) {
            ((StringBuffer)object).append(String.valueOf(string) + ", ");
        }
        OSPLog.fine(((StringBuffer)object).toString());
        return treeSet;
    }

    public TreeSet<String> getAllJREs(int n) {
        Object object;
        Object object2;
        Object object3;
        Set<File> set = this.findJavaExtensionDirectories();
        TreeSet<String> treeSet = new TreeSet<String>();
        try {
            object3 = System.getenv("ProgramFiles(x86)");
            for (File object4 : set) {
                object2 = object4.getParentFile().getParentFile();
                if (OSPRuntime.isWindows()) {
                    if (n == 32 && object3 != null && !object4.getPath().contains((CharSequence)object3) || n == 64 && object3 != null && object4.getPath().contains((CharSequence)object3) || !((File)(object2 = new File((File)object2, "bin/java.exe"))).exists()) continue;
                    try {
                        if (!((File)object2).getCanonicalPath().equals(((File)object2).getAbsolutePath())) {
                            continue;
                        }
                    }
                    catch (IOException iOException) {}
                    object = OSPRuntime.getJREPath((File)object2);
                    treeSet.add((String)object);
                    continue;
                }
                if (!((File)(object2 = new File((File)object2, "bin/java"))).exists()) continue;
                object = OSPRuntime.getJREPath((File)object2);
                if (n == 32 && !object.startsWith("/System/Library")) continue;
                treeSet.add((String)object);
            }
        }
        catch (Exception exception) {}
        if (OSPRuntime.isMac()) {
            object3 = new TreeSet();
            String[] stringArray = new String[]{"/System/Library", "/Library"};
            int n2 = 0;
            while (n2 < stringArray.length) {
                object2 = new File(stringArray[n2]);
                if (((File)object2).exists() && (object = ((File)object2).list()) != null && ((String[])object).length > 0) {
                    Object object4 = object;
                    int n3 = ((String[])object).length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String[] stringArray2;
                        String string = object4[n4];
                        File file = new File((File)object2, string);
                        if (string.contains("Java")) {
                            this.findJREHomes(file, (Set<File>)object3);
                        } else if (file.getName().contains("Internet Plug-Ins") && (stringArray2 = file.list()) != null && stringArray2.length > 0) {
                            String[] stringArray3 = stringArray2;
                            int n5 = stringArray2.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                String string2 = stringArray3[n6];
                                if (string2.contains("Java")) {
                                    this.findJREHomes(new File(file, string2), (Set<File>)object3);
                                }
                                ++n6;
                            }
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            object2 = object3.iterator();
            while (object2.hasNext()) {
                File file = (File)object2.next();
                if (n == 32 && !file.getAbsolutePath().startsWith("/System/Library")) continue;
                treeSet.add(file.getAbsolutePath());
            }
        }
        object3 = new StringBuffer(String.valueOf(n) + "-bit JREs: ");
        for (String string : treeSet) {
            ((StringBuffer)object3).append(String.valueOf(string) + ", ");
        }
        OSPLog.fine(((StringBuffer)object3).toString());
        return treeSet;
    }

    private void findJREHomes(File file, Set<File> set) {
        if (file == null || !file.exists() || !file.isDirectory() || set == null) {
            return;
        }
        try {
            if (!file.getCanonicalPath().equals(file.getAbsolutePath())) {
                return;
            }
        }
        catch (IOException iOException) {}
        File file2 = new File(file, "bin/java");
        if (file2.exists()) {
            set.add(file);
            return;
        }
        if (file.getName().contains(".plugin")) {
            File file3 = new File(file, "Contents");
            if (file3.exists()) {
                this.findJREHomes(new File(file3, "Home"), set);
            }
            return;
        }
        String[] stringArray = file.list();
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                this.findJREHomes(new File(file, string), set);
                ++n2;
            }
        }
    }

    public String getDefaultJRE(int n) {
        String string;
        String string2 = null;
        TreeSet<String> treeSet = this.getPublicJREs(n);
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            string2 = string = (String)iterator.next();
        }
        if (string2 == null) {
            treeSet = this.getAllJREs(n);
            iterator = treeSet.iterator();
            while (iterator.hasNext()) {
                string2 = string = (String)iterator.next();
            }
        }
        OSPLog.fine(String.valueOf(n) + "-bit default JRE: " + string2);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean copyFile(File file, File file2) {
        byte[] byArray = new byte[100000];
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            while (true) {
                byte[] byArray2 = byArray;
                // MONITORENTER : byArray
                int n = ((InputStream)fileInputStream).read(byArray);
                if (n == -1) {
                    // MONITOREXIT : byArray2
                    break;
                }
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
                // MONITOREXIT : byArray2
            }
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
            file2.setLastModified(file.lastModified());
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    static class ExtensionsFilter
    implements FilenameFilter {
        ExtensionsFilter() {
        }

        public boolean accept(File file, String string) {
            if (!file.isDirectory()) {
                return false;
            }
            String string2 = XML.forwardSlash(file.getPath());
            if (string2.endsWith("/lib/ext")) {
                if (string2.endsWith("/jre/lib/ext")) {
                    return true;
                }
                String string3 = XML.getName(string2.substring(0, string2.length() - 8));
                if (string3.indexOf("jre") > -1) {
                    return true;
                }
                if (string2.indexOf("jdk") > -1 && string2.indexOf("/Java/") > -1) {
                    return true;
                }
                if (string2.indexOf("jre") > -1 && string2.indexOf("/Java/") > -1) {
                    return true;
                }
            }
            if (string2.endsWith("java/packages/lib/ext")) {
                return true;
            }
            if (string2.endsWith("Java/lib/ext")) {
                return true;
            }
            return string2.endsWith("Java/Extensions");
        }
    }
}

