/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.SwingPropertyChangeSupport;

public class FontSizer {
    public static final Font TEXT_FONT = new JTextField().getFont();
    public static final Font BUTTON_FONT = new JButton().getFont();
    static Object levelObj = new FontSizer();
    static PropertyChangeSupport support = new SwingPropertyChangeSupport(levelObj);
    static int level;
    static double levelFactor;
    static Map<Font, Font> fontMap;

    static {
        levelFactor = 1.35;
        fontMap = new HashMap<Font, Font>();
    }

    private FontSizer() {
    }

    public static void setLevel(int n) {
        level = Math.max(n, 0);
        Font font = FontSizer.getResizedFont(TEXT_FONT, level);
        UIManager.put("OptionPane.messageFont", font);
        UIManager.put("TextField.font", font);
        UIManager.put("ToolTip.font", font);
        font = FontSizer.getResizedFont(BUTTON_FONT, level);
        UIManager.put("OptionPane.buttonFont", font);
        support.firePropertyChange("level", null, new Integer(level));
    }

    public static int getLevel() {
        return level;
    }

    public static void levelUp() {
        support.firePropertyChange("level", null, new Integer(++level));
    }

    public static void levelDown() {
        --level;
        level = Math.max(level, 0);
        support.firePropertyChange("level", null, new Integer(level));
    }

    public static void setFonts(Object object, int n) {
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n2 = objectArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Object object2 = objectArray[n3];
                FontSizer.setFonts(object2, n);
                ++n3;
            }
            return;
        }
        if (object instanceof Collection) {
            for (Object e : (Collection)object) {
                FontSizer.setFonts(e, n);
            }
            return;
        }
        double d = FontSizer.getFactor(n);
        if (object instanceof Container) {
            FontSizer.setFontFactor((Container)object, d);
        } else if (object instanceof TitledBorder) {
            FontSizer.setFontFactor((TitledBorder)object, d);
        } else if (object instanceof Component) {
            FontSizer.setFontFactor((Component)object, d);
        }
    }

    public static Font getResizedFont(Font font, int n) {
        return FontSizer.getResizedFont(font, FontSizer.getFactor(n));
    }

    public static Font getResizedFont(Font font, double d) {
        if (font == null) {
            return null;
        }
        Font font2 = fontMap.get(font);
        if (font2 == null) {
            font2 = font;
            fontMap.put(font, font2);
        }
        float f = (float)((double)font2.getSize() * d);
        font = font2.deriveFont(f);
        fontMap.put(font, font2);
        return font;
    }

    public static double getFactor(int n) {
        double d = 1.0;
        int n2 = 0;
        while (n2 < n) {
            d *= levelFactor;
            ++n2;
        }
        return d;
    }

    public static void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (string.equals("level")) {
            support.addPropertyChangeListener(string, propertyChangeListener);
        }
    }

    public static void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        support.removePropertyChangeListener(string, propertyChangeListener);
    }

    private static void setFontFactor(Container container, double d) {
        Border border;
        Font font = FontSizer.getResizedFont(container.getFont(), d);
        if (container instanceof JComponent && (border = ((JComponent)container).getBorder()) instanceof TitledBorder) {
            FontSizer.setFontFactor((TitledBorder)border, d);
        }
        if (container instanceof JMenu) {
            FontSizer.setMenuFont((JMenu)container, font);
        } else {
            container.setFont(font);
            int n = 0;
            while (n < container.getComponentCount()) {
                Component component = container.getComponent(n);
                if (component instanceof Container) {
                    FontSizer.setFontFactor((Container)component, d);
                } else {
                    FontSizer.setFontFactor(component, d);
                }
                ++n;
            }
        }
        container.repaint();
    }

    private static void setFontFactor(Component component, double d) {
        Border border;
        Font font = FontSizer.getResizedFont(component.getFont(), d);
        component.setFont(font);
        if (component instanceof JComponent && (border = ((JComponent)component).getBorder()) instanceof TitledBorder) {
            FontSizer.setFontFactor((TitledBorder)border, d);
        }
    }

    private static void setFontFactor(TitledBorder titledBorder, double d) {
        Font font = FontSizer.getResizedFont(titledBorder.getTitleFont(), d);
        titledBorder.setTitleFont(font);
    }

    private static void setMenuFont(JMenu jMenu, Font font) {
        jMenu.setFont(font);
        int n = 0;
        while (n < jMenu.getMenuComponentCount()) {
            jMenu.getMenuComponent(n).setFont(font);
            if (jMenu.getMenuComponent(n) instanceof JMenu) {
                FontSizer.setMenuFont((JMenu)jMenu.getMenuComponent(n), font);
            }
            ++n;
        }
    }
}

