/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Frame;
import java.text.DecimalFormat;
import java.util.Collection;
import javax.swing.JFrame;
import org.opensourcephysics.controls.Animation;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.MainFrame;
import org.opensourcephysics.controls.OSPApplication;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.OSPFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnimation
implements Animation,
Runnable {
    protected OSPFrame mainFrame;
    protected Control control;
    protected volatile Thread animationThread;
    protected int delayTime = 100;
    protected DecimalFormat decimalFormat = new DecimalFormat("0.00E0");

    @Override
    public void setControl(Control control) {
        this.control = control;
        this.mainFrame = null;
        if (control != null) {
            if (control instanceof MainFrame) {
                this.mainFrame = ((MainFrame)((Object)control)).getMainFrame();
            }
            control.setLockValues(true);
            this.resetAnimation();
            control.setLockValues(false);
            if (control instanceof Frame) {
                ((Frame)((Object)control)).pack();
            }
        }
    }

    public void setDelayTime(int n) {
        this.delayTime = n;
    }

    public int getDelayTime() {
        return this.delayTime;
    }

    public OSPFrame getMainFrame() {
        return this.mainFrame;
    }

    public OSPApplication getOSPApp() {
        if (this.control instanceof MainFrame) {
            return ((MainFrame)((Object)this.control)).getOSPApp();
        }
        return null;
    }

    public void addChildFrame(JFrame jFrame) {
        if (this.mainFrame == null || jFrame == null) {
            return;
        }
        this.mainFrame.addChildFrame(jFrame);
    }

    public void clearChildFrames() {
        if (this.mainFrame == null) {
            return;
        }
        this.mainFrame.clearChildFrames();
    }

    public Collection<JFrame> getChildFrames() {
        return this.mainFrame.getChildFrames();
    }

    public Control getControl() {
        return this.control;
    }

    @Override
    public void initializeAnimation() {
        this.control.clearMessages();
    }

    protected abstract void doStep();

    @Override
    public synchronized void stopAnimation() {
        if (this.animationThread == null) {
            return;
        }
        Thread thread = this.animationThread;
        this.animationThread = null;
        if (Thread.currentThread() == thread) {
            return;
        }
        try {
            thread.interrupt();
            thread.join(1000L);
        }
        catch (Exception exception) {}
    }

    public final boolean isRunning() {
        return this.animationThread != null;
    }

    @Override
    public synchronized void stepAnimation() {
        if (this.animationThread != null) {
            this.stopAnimation();
        }
        this.doStep();
    }

    @Override
    public synchronized void startAnimation() {
        if (this.animationThread != null) {
            return;
        }
        this.animationThread = new Thread(this);
        this.animationThread.setPriority(5);
        this.animationThread.setDaemon(true);
        this.animationThread.start();
    }

    @Override
    public void resetAnimation() {
        if (this.animationThread != null) {
            this.stopAnimation();
        }
        this.control.clearMessages();
    }

    @Override
    public void run() {
        long l = this.delayTime;
        while (this.animationThread == Thread.currentThread()) {
            long l2 = System.currentTimeMillis();
            this.doStep();
            l = Math.max(10L, (long)this.delayTime - (System.currentTimeMillis() - l2));
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new OSPAnimationLoader();
    }

    static class OSPAnimationLoader
    extends XMLLoader {
        OSPAnimationLoader() {
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            ((Animation)object).initializeAnimation();
            return object;
        }
    }
}

