/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Frame;
import java.util.Collection;
import org.opensourcephysics.controls.AbstractAnimation;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.MainFrame;
import org.opensourcephysics.controls.SimControl;
import org.opensourcephysics.controls.Simulation;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.GUIUtils;

public abstract class AbstractSimulation
extends AbstractAnimation
implements Simulation {
    protected SimControl control;
    protected boolean showStepsPerDisplay = false;
    protected int stepsPerDisplay = 1;
    protected int stepCounter = 0;

    public void setControl(Control control) {
        this.control = control instanceof SimControl ? (SimControl)control : new ShadowControl(control);
        ((AbstractAnimation)this).control = control;
        this.mainFrame = null;
        if (control != null) {
            if (control instanceof MainFrame) {
                this.mainFrame = ((MainFrame)((Object)control)).getMainFrame();
            }
            control.setLockValues(true);
            this.resetAnimation();
            control.setLockValues(false);
            if (control instanceof Frame) {
                ((Frame)((Object)control)).pack();
            }
        }
    }

    public Control getControl() {
        return this.control;
    }

    public void startRunning() {
    }

    public void stopRunning() {
    }

    public void startAnimation() {
        if (this.showStepsPerDisplay) {
            this.stepsPerDisplay = this.control.getInt("steps per display");
        }
        this.start();
        this.startRunning();
        super.startAnimation();
    }

    public final void startSimulation() {
        this.startAnimation();
    }

    public void start() {
    }

    public void stopAnimation() {
        super.stopAnimation();
        this.stopRunning();
        this.stop();
    }

    public final void stopSimulation() {
        this.stopAnimation();
    }

    public void stop() {
    }

    public final void stepAnimation() {
        if (this.showStepsPerDisplay) {
            this.stepsPerDisplay = this.control.getInt("steps per display");
        }
        this.startRunning();
        super.stepAnimation();
        ++this.stepCounter;
        this.stopRunning();
        GUIUtils.repaintAnimatedFrames();
    }

    public void initializeAnimation() {
        if (this.control == null) {
            return;
        }
        super.initializeAnimation();
        this.initialize();
        this.stepCounter = 0;
    }

    public int getStepCounter() {
        return this.stepCounter;
    }

    public void initialize() {
    }

    public void resetAnimation() {
        if (this.control == null) {
            return;
        }
        super.resetAnimation();
        this.stepsPerDisplay = 1;
        if (this.showStepsPerDisplay) {
            this.control.setAdjustableValue("steps per display", this.stepsPerDisplay);
        }
        this.reset();
    }

    public void enableStepsPerDisplay(boolean bl) {
        this.showStepsPerDisplay = bl;
        if (this.showStepsPerDisplay) {
            this.control.setAdjustableValue("steps per display", this.stepsPerDisplay);
        } else {
            this.control.removeParameter("steps per display");
        }
    }

    public void setStepsPerDisplay(int n) {
        this.stepsPerDisplay = Math.max(n, 1);
        if (this.showStepsPerDisplay) {
            this.control.setAdjustableValue("steps per display", this.stepsPerDisplay);
        }
    }

    public int getStepsPerDisplay() {
        return this.stepsPerDisplay;
    }

    public void reset() {
    }

    public void run() {
        GUIUtils.setAnimatedFrameIgnoreRepaint(true);
        long l = this.delayTime;
        while (this.animationThread == Thread.currentThread()) {
            long l2 = System.currentTimeMillis();
            int n = 0;
            while (n < this.stepsPerDisplay) {
                this.doStep();
                ++this.stepCounter;
                if (this.animationThread != Thread.currentThread()) break;
                Thread.yield();
                ++n;
            }
            GUIUtils.renderAnimatedFrames();
            l = Math.max(10L, (long)this.delayTime - (System.currentTimeMillis() - l2));
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {}
        }
        GUIUtils.setAnimatedFrameIgnoreRepaint(false);
    }

    public static XML.ObjectLoader getLoader() {
        return new OSPSimulationLoader();
    }

    static class OSPSimulationLoader
    extends XMLLoader {
        OSPSimulationLoader() {
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            ((Simulation)object).initializeAnimation();
            return object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ShadowControl
    implements SimControl {
        Control control;

        ShadowControl(Control control) {
            this.control = control;
        }

        @Override
        public void setAdjustableValue(String string, boolean bl) {
            this.control.setValue(string, bl);
        }

        @Override
        public void setAdjustableValue(String string, double d) {
            this.control.setValue(string, d);
        }

        @Override
        public void setAdjustableValue(String string, int n) {
            this.control.setValue(string, n);
        }

        @Override
        public void setAdjustableValue(String string, Object object) {
            this.control.setValue(string, object);
        }

        @Override
        public void removeParameter(String string) {
        }

        @Override
        public void setLockValues(boolean bl) {
            this.control.setLockValues(bl);
        }

        @Override
        public void setValue(String string, Object object) {
            this.control.setValue(string, object);
        }

        @Override
        public void setValue(String string, double d) {
            this.control.setValue(string, d);
        }

        @Override
        public void setValue(String string, int n) {
            this.control.setValue(string, n);
        }

        @Override
        public void setValue(String string, boolean bl) {
            this.control.setValue(string, bl);
        }

        @Override
        public int getInt(String string) {
            return this.control.getInt(string);
        }

        @Override
        public double getDouble(String string) {
            return this.control.getDouble(string);
        }

        @Override
        public Object getObject(String string) {
            return this.control.getObject(string);
        }

        @Override
        public String getString(String string) {
            return this.control.getString(string);
        }

        @Override
        public boolean getBoolean(String string) {
            return this.control.getBoolean(string);
        }

        @Override
        public Collection<String> getPropertyNames() {
            return this.control.getPropertyNames();
        }

        @Override
        public void println(String string) {
            this.control.println(string);
        }

        @Override
        public void println() {
            this.control.println();
        }

        @Override
        public void print(String string) {
            this.control.print(string);
        }

        @Override
        public void clearMessages() {
            this.control.clearMessages();
        }

        @Override
        public void clearValues() {
            this.control.clearValues();
        }

        @Override
        public void calculationDone(String string) {
            this.control.calculationDone(string);
        }

        @Override
        public void setParameterToFixed(String string, boolean bl) {
        }
    }
}

