/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.controls.Control;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TextFrame;
import org.opensourcephysics.tools.FontSizer;

public class ControlUtils {
    static DecimalFormat format2 = new DecimalFormat("#0.00");
    static DecimalFormat format3 = new DecimalFormat("#0.000");
    static DecimalFormat format4 = new DecimalFormat("#0.0000");
    static DecimalFormat format_E2 = new DecimalFormat("0.00E0");
    static DecimalFormat format_E3 = new DecimalFormat("0.000E0");
    static DecimalFormat format_E4 = new DecimalFormat("0.0000E0");
    protected static JFileChooser chooser;
    private static TextFrame sysPropFrame;

    public static String f2(double d) {
        return format2.format(d);
    }

    public static String f3(double d) {
        return format3.format(d);
    }

    public static String e2(double d) {
        return format_E2.format(d);
    }

    public static String e3(double d) {
        return format_E3.format(d);
    }

    public static String e4(double d) {
        return format_E4.format(d);
    }

    public static String f4(double d) {
        return format4.format(d);
    }

    private ControlUtils() {
    }

    public static JFrame showSystemProperties(boolean bl) {
        if (sysPropFrame == null) {
            sysPropFrame = new TextFrame(null, null);
            sysPropFrame.getTextPane().setText(ControlUtils.getSystemProperties());
            sysPropFrame.setSize(300, 400);
        }
        sysPropFrame.setVisible(bl);
        return sysPropFrame;
    }

    /*
     * Unable to fully structure code
     */
    public static String getSystemProperties() {
        block4: {
            var0 = new StringBuffer();
            try {
                var1_1 = System.getProperties();
                var2_3 = 0;
                var3_5 = var1_1.propertyNames();
                while (var3_5.hasMoreElements()) {
                    var4_6 = (String)var3_5.nextElement();
                    var0.append(String.valueOf(++var2_3) + ". " + var4_6 + " = " + var1_1.getProperty(var4_6) + "\n");
                }
                break block4;
            }
            catch (Exception v0) {
                var1_2 = new String[]{"java.version", "java.vendor", "java.class.version", "os.name", "os.arch", "os.version", "file.separator", "path.separator", "line.separator"};
                var2_4 = 0;
                ** while (var2_4 < var1_2.length)
            }
lbl-1000:
            // 1 sources

            {
                var0.append(String.valueOf(var2_4) + ". " + var1_2[var2_4] + " = " + System.getProperty(var1_2[var2_4]) + "\n");
                ++var2_4;
                continue;
            }
        }
        return var0.toString();
    }

    public static void loadParameters(Control control, Component component) {
        JFileChooser jFileChooser = new JFileChooser(new File(OSPRuntime.chooserDir));
        FontSizer.setFonts(jFileChooser, FontSizer.getLevel());
        int n = jFileChooser.showOpenDialog(component);
        if (n == 0) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(jFileChooser.getSelectedFile()));
                ControlUtils.readFile(control, bufferedReader);
                bufferedReader.close();
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        }
    }

    public static void saveToFile(Object object, Component component) {
        int n;
        JFileChooser jFileChooser = new JFileChooser(new File(OSPRuntime.chooserDir));
        FontSizer.setFonts(chooser, FontSizer.getLevel());
        int n2 = jFileChooser.showSaveDialog(component);
        if (n2 != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        if (file.exists() && (n = JOptionPane.showConfirmDialog(component, String.valueOf(ControlsRes.getString("OSPLog.ReplaceExisting_dialog_message")) + " " + file.getName() + ControlsRes.getString("OSPLog.question_mark"), ControlsRes.getString("OSPLog.ReplaceFile_dialog_title"), 1)) != 0) {
            return;
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            printWriter.print(object.toString());
            printWriter.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(component, ControlsRes.getString("Dialog.SaveError.Message"), ControlsRes.getString("Dialog.SaveError.Title"), 0);
        }
    }

    public static void saveXML(Object object) {
        int n = ControlUtils.getXMLFileChooser().showSaveDialog(null);
        if (n == 0) {
            int n2;
            File file = chooser.getSelectedFile();
            if (file.exists() && (n2 = JOptionPane.showConfirmDialog(null, String.valueOf(ControlsRes.getString("OSPLog.ReplaceExisting_dialog_message")) + " " + file.getName() + ControlsRes.getString("OSPLog.question_mark"), ControlsRes.getString("OSPLog.ReplaceFile_dialog_title"), 1)) != 0) {
                return;
            }
            String string = XML.getRelativePath(file.getAbsolutePath());
            if (string == null || string.trim().equals("")) {
                return;
            }
            int n3 = string.toLowerCase().lastIndexOf(".xml");
            if (n3 != string.length() - 4) {
                string = String.valueOf(string) + ".xml";
            }
            XMLControlElement xMLControlElement = new XMLControlElement(object);
            xMLControlElement.write(string);
        }
    }

    public static JFileChooser getXMLFileChooser() {
        if (chooser != null) {
            FontSizer.setFonts(chooser, FontSizer.getLevel());
            return chooser;
        }
        chooser = new JFileChooser(new File(OSPRuntime.chooserDir));
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file == null) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                String string = null;
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                if (n > 0 && n < string2.length() - 1) {
                    string = string2.substring(n + 1).toLowerCase();
                }
                return string != null && (string.equals("xml") || string.equals("osp"));
            }

            public String getDescription() {
                return "XML files";
            }
        };
        chooser.addChoosableFileFilter(fileFilter);
        FontSizer.setFonts(chooser, FontSizer.getLevel());
        return chooser;
    }

    private static void readFile(Control control, BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        while (string != null) {
            String string2 = ControlUtils.parseParameter(string);
            if (string2 != null && !string2.equals("")) {
                control.setValue(string2, ControlUtils.parseValue(string));
            }
            string = bufferedReader.readLine();
        }
    }

    private static String parseParameter(String string) {
        int n = string.indexOf(61);
        if (n < 1) {
            return null;
        }
        return string.substring(0, n).trim();
    }

    private static String parseValue(String string) {
        int n = string.indexOf(61);
        if (n >= string.length() - 1) {
            return "";
        }
        return string.substring(n + 1).trim();
    }
}

