/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.tools.ToolsRes;

public class MessageFrame
extends JFrame {
    static final Color DARK_GREEN = new Color(0, 128, 0);
    static final Color DARK_BLUE = new Color(0, 0, 128);
    static final Color DARK_RED = new Color(128, 0, 0);
    static Style black;
    static Style red;
    static Style blue;
    static Style green;
    static Style magenta;
    static Style gray;
    static volatile MessageFrame APPLET_MESSAGEFRAME;
    static int levelOSP;
    private static int SEVERE;
    private static int WARNING;
    private static int INFO;
    private static int CONFIG;
    private static int FINE;
    private static int FINER;
    private static int FINEST;
    private static ArrayList<JRadioButtonMenuItem> buttonList;
    private JTextPane textPane = new JTextPane();

    static {
        levelOSP = Level.CONFIG.intValue();
        SEVERE = Level.SEVERE.intValue();
        WARNING = Level.WARNING.intValue();
        INFO = Level.INFO.intValue();
        CONFIG = Level.CONFIG.intValue();
        FINE = Level.FINE.intValue();
        FINER = Level.FINER.intValue();
        FINEST = Level.FINEST.intValue();
        buttonList = new ArrayList();
    }

    private MessageFrame() {
        this.setTitle(ControlsRes.getString("MessageFrame.DefaultTitle"));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setPreferredSize(new Dimension(480, 240));
        this.setContentPane(jPanel);
        jPanel.setPreferredSize(new Dimension(200, 300));
        jPanel.setMinimumSize(new Dimension(100, 100));
        this.textPane.setEditable(false);
        this.textPane.setAutoscrolls(true);
        black = StyleContext.getDefaultStyleContext().getStyle("default");
        red = this.textPane.addStyle("red", black);
        StyleConstants.setForeground(red, DARK_RED);
        blue = this.textPane.addStyle("blue", black);
        StyleConstants.setForeground(blue, DARK_BLUE);
        green = this.textPane.addStyle("green", black);
        StyleConstants.setForeground(green, DARK_GREEN);
        magenta = this.textPane.addStyle("magenta", black);
        StyleConstants.setForeground(magenta, Color.MAGENTA);
        gray = this.textPane.addStyle("gray", black);
        StyleConstants.setForeground(gray, Color.GRAY);
        JScrollPane jScrollPane = new JScrollPane(this.textPane);
        jScrollPane.setWheelScrollingEnabled(true);
        jPanel.add((Component)jScrollPane, "Center");
        this.pack();
    }

    public static JFrame showLog(boolean bl) {
        if (APPLET_MESSAGEFRAME == null || !APPLET_MESSAGEFRAME.isDisplayable()) {
            MessageFrame.createAppletMessageFrame();
        }
        APPLET_MESSAGEFRAME.setVisible(bl);
        return APPLET_MESSAGEFRAME;
    }

    private static void createAppletMessageFrame() {
        APPLET_MESSAGEFRAME = new MessageFrame();
        APPLET_MESSAGEFRAME.setSize(300, 200);
        APPLET_MESSAGEFRAME.setDefaultCloseOperation(1);
        JMenuBar jMenuBar = new JMenuBar();
        APPLET_MESSAGEFRAME.setJMenuBar(jMenuBar);
        final JMenu jMenu = new JMenu(ControlsRes.getString("MessageFrame.Edit_menu"));
        jMenuBar.add(jMenu);
        final JMenuItem jMenuItem = new JMenuItem(ControlsRes.getString("MessageFrame.Clear_menu_item"));
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                APPLET_MESSAGEFRAME.textPane.setText("");
            }
        });
        final JMenu jMenu2 = new JMenu(ControlsRes.getString("MessageFrame.Level_menu"));
        jMenuBar.add(jMenu2);
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = 0;
        while (n < OSPLog.levels.length) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(OSPLog.levels[n].getName());
            buttonList.add(jRadioButtonMenuItem);
            jMenu2.add((Component)jRadioButtonMenuItem, 0);
            buttonGroup.add(jRadioButtonMenuItem);
            if (levelOSP == OSPLog.levels[n].intValue()) {
                jRadioButtonMenuItem.setSelected(true);
            }
            jRadioButtonMenuItem.setActionCommand(OSPLog.levels[n].getName());
            jRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MessageFrame.setLevel(Level.parse(actionEvent.getActionCommand()));
                }
            });
            ++n;
        }
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                APPLET_MESSAGEFRAME.setTitle(ControlsRes.getString("MessageFrame.DefaultTitle"));
                jMenu.setText(ControlsRes.getString("MessageFrame.Edit_menu"));
                jMenuItem.setText(ControlsRes.getString("MessageFrame.Clear_menu"));
                jMenu2.setText(ControlsRes.getString("MessageFrame.Level_menu"));
            }
        });
    }

    public static boolean isLogVisible() {
        if (APPLET_MESSAGEFRAME == null) {
            return false;
        }
        return APPLET_MESSAGEFRAME.isVisible();
    }

    public static void clear() {
        if (APPLET_MESSAGEFRAME != null) {
            MessageFrame.APPLET_MESSAGEFRAME.textPane.setText("");
        }
    }

    public static void setLevel(Level level) {
        levelOSP = level.intValue();
        int n = 0;
        int n2 = Math.min(OSPLog.levels.length, buttonList.size());
        while (n < n2) {
            if (levelOSP == OSPLog.levels[n].intValue()) {
                buttonList.get(n).setSelected(true);
            }
            ++n;
        }
    }

    public static int getLevelValue() {
        return levelOSP;
    }

    public static void severe(String string) {
        if (levelOSP <= SEVERE) {
            MessageFrame.appletLog(string, red);
        }
    }

    public static void warning(String string) {
        if (levelOSP <= WARNING) {
            MessageFrame.appletLog(string, red);
        }
    }

    public static void info(String string) {
        if (levelOSP <= INFO) {
            MessageFrame.appletLog(string, black);
        }
    }

    public static void config(String string) {
        if (levelOSP <= CONFIG) {
            MessageFrame.appletLog(string, green);
        }
    }

    public static void fine(String string) {
        if (levelOSP <= FINE) {
            MessageFrame.appletLog(string, blue);
        }
    }

    public static void finer(String string) {
        if (levelOSP <= FINER) {
            MessageFrame.appletLog(string, blue);
        }
    }

    public static void finest(String string) {
        if (levelOSP <= FINEST) {
            MessageFrame.appletLog(string, blue);
        }
    }

    private static void appletLog(final String string, final Style style) {
        if (APPLET_MESSAGEFRAME == null || !APPLET_MESSAGEFRAME.isDisplayable()) {
            MessageFrame.createAppletMessageFrame();
        }
        Runnable runnable = new Runnable(){

            public synchronized void run() {
                try {
                    Document document = APPLET_MESSAGEFRAME.textPane.getDocument();
                    document.insertString(document.getLength(), String.valueOf(string) + '\n', style);
                    Rectangle rectangle = APPLET_MESSAGEFRAME.textPane.getBounds();
                    rectangle.y = rectangle.height;
                    APPLET_MESSAGEFRAME.textPane.scrollRectToVisible(rectangle);
                }
                catch (BadLocationException badLocationException) {
                    System.err.println(badLocationException);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

