/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.davidson.applets;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import org.opensourcephysics.controls.MainFrame;
import org.opensourcephysics.controls.MessageFrame;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TextFrame;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationApplet
extends JApplet {
    JFrame mainFrame = null;
    JButton showFramesButton = new JButton("Show");
    String targetClassName;
    ArrayList<Frame> newFrames = new ArrayList();
    ArrayList<Frame> existingFrames = new ArrayList();
    Class<?> target;
    String[] args = null;
    boolean singleApp = false;
    String targetError = null;

    public String getParameter(String string, String string2) {
        return this.getParameter(string) != null ? this.getParameter(string) : string2;
    }

    @Override
    public void init() {
        super.init();
        OSPRuntime.applet = this;
        OSPRuntime.appletMode = false;
        if (this.getParameter("showLog", "false").toLowerCase().trim().equals("true")) {
            OSPLog.showLog();
        }
        String string = this.getParameter("xmldata", null);
        if ((string = this.getParameter("args[0]", string)) != null) {
            this.args = new String[1];
        }
        String string2 = this.getParameter("args[1]", null);
        String string3 = this.getParameter("args[2]", null);
        if (string3 != null) {
            this.args = new String[3];
            this.args[0] = string;
            this.args[1] = string2;
            this.args[2] = string3;
        } else if (string2 != null) {
            this.args = new String[2];
            this.args[0] = string;
            this.args[1] = string2;
        } else if (string != null) {
            this.args = new String[1];
            this.args[0] = string;
        }
        this.targetClassName = this.getParameter("target", null);
        if (this.targetClassName == null) {
            this.targetClassName = this.getParameter("app", null);
        }
        if (this.targetClassName == null) {
            this.readManifest();
        }
        String string4 = this.getParameter("title", null);
        this.singleApp = this.getParameter("singleapp", "false").trim().equalsIgnoreCase("true");
        if (string4 == null) {
            String[] stringArray = this.targetClassName.split("[.]");
            this.showFramesButton.setText(stringArray[stringArray.length - 1]);
        } else {
            this.showFramesButton.setText(string4);
        }
        this.getRootPane().getContentPane().add((Component)this.showFramesButton, "Center");
        this.showFramesButton.addActionListener(new DisplayBtnListener());
    }

    static boolean isLaunchable(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        try {
            clazz.getMethod("main", String[].class);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    @Override
    public void destroy() {
        this.disposeOwnedFrames();
        this.target = null;
        this.mainFrame = null;
        super.destroy();
    }

    private void readManifest() {
        String string = this.getParameter("archive", null);
        string = string.split(";")[0];
        OSPLog.finer("archive applet tag=" + string);
        if (string == null) {
            return;
        }
        String string2 = "META-INF/MANIFEST.MF";
        Resource resource = ResourceLoader.getResource(string, string2);
        if (resource == null) {
            OSPLog.fine("manifest not found in=" + string);
            return;
        }
        String string3 = resource.getString();
        String[] stringArray = string3.split("\n");
        int n = 0;
        int n2 = Math.min(10, stringArray.length);
        while (n < n2) {
            int n3 = stringArray[n].indexOf("Main-Class:");
            if (n3 >= 0) {
                this.targetClassName = stringArray[n].substring("Main-Class:".length() + n3).trim();
                OSPLog.fine("target class in manifest=" + this.targetClassName);
                return;
            }
            ++n;
        }
    }

    private Class<?> createTarget() {
        Class<?> clazz = null;
        this.targetError = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            clazz = classLoader.loadClass(this.targetClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Class not found: " + this.targetClassName);
            this.targetError = "Class not found: " + this.targetClassName;
            return null;
        }
        if (!ApplicationApplet.isLaunchable(clazz)) {
            System.err.println("Main method not found in " + this.targetClassName);
            this.targetError = "Main method not found in " + this.targetClassName;
            return null;
        }
        Frame[] frameArray = Frame.getFrames();
        this.existingFrames.clear();
        int n = 0;
        int n2 = frameArray.length;
        while (n < n2) {
            this.existingFrames.add(frameArray[n]);
            ++n;
        }
        String string = this.getParameter("htmldata", null);
        if (string != null) {
            TextFrame textFrame = new TextFrame(string, clazz);
            textFrame.setVisible(true);
        }
        try {
            Method method = clazz.getMethod("main", String[].class);
            method.invoke(clazz, new Object[]{this.args});
            frameArray = Frame.getFrames();
            int n3 = 0;
            int n4 = frameArray.length;
            while (n3 < n4) {
                if (frameArray[n3] instanceof MainFrame) {
                    this.mainFrame = (JFrame)frameArray[n3];
                }
                if (frameArray[n3] instanceof JFrame && ((JFrame)frameArray[n3]).getDefaultCloseOperation() == 3) {
                    ((JFrame)frameArray[n3]).setDefaultCloseOperation(1);
                    if (this.mainFrame == null) {
                        this.mainFrame = (JFrame)frameArray[n3];
                    }
                }
                if (!this.existingFrames.contains(frameArray[n3])) {
                    this.newFrames.add(frameArray[n3]);
                }
                ++n3;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println(noSuchMethodException);
            this.targetError = noSuchMethodException.toString();
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println(invocationTargetException);
            System.err.println(invocationTargetException.getStackTrace());
            this.targetError = invocationTargetException.toString();
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println(illegalAccessException);
            this.targetError = illegalAccessException.toString();
        }
        return clazz;
    }

    private void disposeOwnedFrames() {
        Frame[] frameArray = Frame.getFrames();
        int n = 0;
        int n2 = frameArray.length;
        while (n < n2) {
            if (!frameArray[n].getClass().getName().startsWith("sun.plugin")) {
                if (frameArray[n] instanceof JFrame && ((JFrame)frameArray[n]).getDefaultCloseOperation() == 3) {
                    ((JFrame)frameArray[n]).setDefaultCloseOperation(2);
                }
                if (!this.existingFrames.contains(frameArray[n])) {
                    frameArray[n].setVisible(false);
                    frameArray[n].dispose();
                }
            }
            ++n;
        }
        this.newFrames.clear();
    }

    private class DisplayBtnListener
    implements ActionListener {
        private DisplayBtnListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ApplicationApplet.this.singleApp && OSPRuntime.applet != ApplicationApplet.this) {
                ApplicationApplet.this.disposeOwnedFrames();
                ApplicationApplet.this.target = null;
                ApplicationApplet.this.mainFrame = null;
                OSPRuntime.applet = ApplicationApplet.this;
            }
            if (ApplicationApplet.this.target == null) {
                ApplicationApplet.this.target = ApplicationApplet.this.createTarget();
                if (ApplicationApplet.this.targetError != null) {
                    ApplicationApplet.this.target = null;
                }
                return;
            }
            Frame[] frameArray = Frame.getFrames();
            int n = 0;
            int n2 = frameArray.length;
            while (n < n2) {
                if (!frameArray[n].isDisplayable()) {
                    ApplicationApplet.this.existingFrames.remove(frameArray[n]);
                    ApplicationApplet.this.newFrames.remove(frameArray[n]);
                } else if (!ApplicationApplet.this.existingFrames.contains(frameArray[n])) {
                    ApplicationApplet.this.newFrames.add(frameArray[n]);
                }
                if (frameArray[n] instanceof MainFrame && frameArray[n].isDisplayable()) {
                    ApplicationApplet.this.mainFrame = (JFrame)frameArray[n];
                }
                ++n;
            }
            for (Frame frame : ApplicationApplet.this.newFrames) {
                if (!frame.isDisplayable() || frame instanceof OSPLog || frame instanceof MessageFrame || frame instanceof Translator) continue;
                frame.setVisible(true);
            }
            if (ApplicationApplet.this.mainFrame != null) {
                ApplicationApplet.this.mainFrame.setState(0);
                ApplicationApplet.this.mainFrame.setVisible(true);
                ApplicationApplet.this.mainFrame.toFront();
            }
        }
    }
}

