/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.table.AbstractTableModel;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.LogMeasurable;
import org.opensourcephysics.display.Measurable;
import org.opensourcephysics.display.TeXParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dataset
extends AbstractTableModel
implements Measurable,
LogMeasurable,
Data {
    protected int datasetID = this.hashCode();
    protected int columnID = 0;
    public static final int NO_MARKER = 0;
    public static final int CIRCLE = 1;
    public static final int SQUARE = 2;
    public static final int AREA = 5;
    public static final int PIXEL = 6;
    public static final int BAR = 7;
    public static final int POST = 8;
    public static final int CUSTOM = -1;
    protected double[] xpoints;
    protected double[] ypoints;
    protected GeneralPath generalPath;
    protected double xmax;
    protected double ymax;
    protected double xmin;
    protected double ymin;
    protected double xmaxLogscale;
    protected double ymaxLogscale;
    protected double xminLogscale;
    protected double yminLogscale;
    protected int index;
    protected boolean sorted = false;
    private int initialSize;
    private int markerSize = 2;
    private int markerShape = 2;
    private Color lineColor;
    private Color fillColor;
    private Color edgeColor;
    private Color errorBarColor;
    private boolean connected;
    private String name = null;
    private String xColumnName;
    private String yColumnName;
    protected String xColumnDescription;
    protected String yColumnDescription;
    private boolean[] colVisible = new boolean[2];
    protected boolean visible = true;
    private int stride = 1;
    protected int maxPoints = 16384;
    protected ArrayList<ErrorBar> errorBars = new ArrayList();
    protected Shape customMarker = new Rectangle2D.Double(-this.markerSize / 2, -this.markerSize / 2, this.markerSize, this.markerSize);

    public Dataset() {
        this(Color.black, Color.black, false);
    }

    public Dataset(Color color) {
        this(color, Color.black, false);
    }

    public Dataset(Color color, Color color2, boolean bl) {
        this.fillColor = color;
        this.edgeColor = color;
        this.errorBarColor = color;
        this.lineColor = color2;
        this.connected = bl;
        this.markerSize = 2;
        this.initialSize = 10;
        this.xColumnName = "x";
        this.yColumnName = "y";
        this.generalPath = new GeneralPath();
        this.index = 0;
        Arrays.fill(this.colVisible, true);
        this.clear();
    }

    @Override
    public void setID(int n) {
        this.datasetID = n;
    }

    @Override
    public int getID() {
        return this.datasetID;
    }

    public void setColumnID(int n) {
        this.columnID = n;
    }

    public int getColumnID() {
        return this.columnID;
    }

    public void setSorted(boolean bl) {
        this.sorted = bl;
        if (this.sorted) {
            this.insertionSort();
        }
    }

    public void setConnected(boolean bl) {
        this.connected = bl;
        if (this.connected) {
            this.recalculatePath();
        }
    }

    public void setMarkerColor(Color color) {
        this.fillColor = color;
        this.edgeColor = color;
        this.errorBarColor = color;
    }

    public void setMarkerColor(Color color, Color color2) {
        this.fillColor = color;
        this.edgeColor = color2;
        this.errorBarColor = color2;
    }

    public void setMarkerColor(Color color, Color color2, Color color3) {
        this.fillColor = color;
        this.edgeColor = color2;
        this.errorBarColor = color3;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    @Override
    public Color[] getFillColors() {
        return new Color[]{Color.BLACK, this.fillColor};
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    @Override
    public Color[] getLineColors() {
        return new Color[]{Color.BLACK, this.lineColor};
    }

    public void setCustomMarker(Shape shape) {
        this.customMarker = shape;
        if (this.customMarker == null) {
            this.markerShape = 2;
            this.customMarker = new Rectangle2D.Double(-this.markerSize / 2, -this.markerSize / 2, this.markerSize, this.markerSize);
        } else {
            this.markerShape = -1;
        }
    }

    public void setMarkerShape(int n) {
        this.markerShape = n;
    }

    public int getMarkerShape() {
        return this.markerShape;
    }

    public void setMarkerSize(int n) {
        this.markerSize = n;
    }

    public void setMaximumPoints(int n) {
        this.maxPoints = n;
    }

    public int getMarkerSize() {
        return this.markerSize;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public void setXYColumnNames(String string, String string2) {
        this.xColumnName = TeXParser.parseTeX(string);
        this.yColumnName = TeXParser.parseTeX(string2);
    }

    public void setXYColumnNames(String string, String string2, String string3) {
        this.setXYColumnNames(string, string2);
        this.name = TeXParser.parseTeX(string3);
    }

    public String getXColumnName() {
        return this.xColumnName;
    }

    public String getYColumnName() {
        return this.yColumnName;
    }

    public String getXColumnDescription() {
        return this.xColumnDescription;
    }

    public void setXColumnDescription(String string) {
        this.xColumnDescription = string;
    }

    public String getYColumnDescription() {
        return this.yColumnDescription;
    }

    public void setYColumnDescription(String string) {
        this.yColumnDescription = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Data> getDataList() {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{this.xColumnName, this.yColumnName};
    }

    @Override
    public boolean isMeasured() {
        if (this.visible) {
            return this.ymin < Double.MAX_VALUE;
        }
        return false;
    }

    @Override
    public double getXMin() {
        return this.xmin;
    }

    @Override
    public double getXMax() {
        return this.xmax;
    }

    @Override
    public double getYMin() {
        return this.ymin;
    }

    @Override
    public double getYMax() {
        return this.ymax;
    }

    @Override
    public double getXMinLogscale() {
        return this.xminLogscale;
    }

    @Override
    public double getXMaxLogscale() {
        return this.xmaxLogscale;
    }

    @Override
    public double getYMinLogscale() {
        return this.yminLogscale;
    }

    @Override
    public double getYMaxLogscale() {
        return this.ymaxLogscale;
    }

    public double[][] getPoints() {
        double[][] dArray = new double[this.index][2];
        int n = 0;
        while (n < this.index) {
            dArray[n] = new double[]{this.xpoints[n], this.ypoints[n]};
            ++n;
        }
        return dArray;
    }

    @Override
    public double[][] getData2D() {
        double[][] dArray = new double[2][this.index];
        dArray[0] = this.getXPoints();
        dArray[1] = this.getYPoints();
        return dArray;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        ArrayList<Dataset> arrayList = new ArrayList<Dataset>();
        arrayList.add(this);
        return arrayList;
    }

    public double[] getXPoints() {
        double[] dArray = new double[this.index];
        System.arraycopy(this.xpoints, 0, dArray, 0, this.index);
        return dArray;
    }

    public double[] getYPoints() {
        double[] dArray = new double[this.index];
        System.arraycopy(this.ypoints, 0, dArray, 0, this.index);
        return dArray;
    }

    public double[] getValidXPoints() {
        return this.getValidPoints(this.getXPoints());
    }

    public double[] getValidYPoints() {
        return this.getValidPoints(this.getYPoints());
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public int getColumnCount() {
        return Dataset.countColumnsVisible(this.colVisible);
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public int getRowCount() {
        return (this.index + this.stride - 1) / this.stride;
    }

    @Override
    public String getColumnName(int n) {
        if ((n = Dataset.convertTableColumnIndex(this.colVisible, n)) == 0) {
            return this.xColumnName;
        }
        return this.yColumnName;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        n2 = Dataset.convertTableColumnIndex(this.colVisible, n2);
        n *= this.stride;
        if (n2 == 0) {
            return new Double(this.xpoints[n]);
        }
        if (Double.isNaN(this.ypoints[n])) {
            return null;
        }
        return new Double(this.ypoints[n]);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return Double.class;
    }

    public void append(double d, double d2, double d3, double d4) {
        this.errorBars.add(new ErrorBar(d, d2, d3, d4));
        this.append(d, d2);
    }

    public void append(double d, double d2) {
        if (Double.isNaN(d) || Double.isInfinite(d) || Double.isInfinite(d2)) {
            return;
        }
        if (this.index >= this.xpoints.length) {
            this.increaseCapacity(this.xpoints.length * 2);
        }
        this.xpoints[this.index] = d;
        this.ypoints[this.index] = d2;
        if (!Double.isNaN(d2)) {
            Point2D point2D = this.generalPath.getCurrentPoint();
            if (point2D == null) {
                this.generalPath.moveTo((float)d, (float)d2);
            } else {
                this.generalPath.lineTo((float)d, (float)d2);
            }
            this.ymax = Math.max(d2, this.ymax);
            this.ymin = Math.min(d2, this.ymin);
            if (d2 > 0.0) {
                this.ymaxLogscale = Math.max(d2, this.ymaxLogscale);
                this.yminLogscale = Math.min(d2, this.yminLogscale);
            }
        }
        this.xmax = Math.max(d, this.xmax);
        this.xmin = Math.min(d, this.xmin);
        if (d > 0.0) {
            this.xmaxLogscale = Math.max(d, this.xmaxLogscale);
            this.xminLogscale = Math.min(d, this.xminLogscale);
        }
        ++this.index;
        if (this.sorted && this.index > 1 && d < this.xpoints[this.index - 2]) {
            this.moveDatum(this.index - 1);
            this.recalculatePath();
        }
    }

    public void append(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n = 0;
        int n2 = dArray.length;
        while (n < n2) {
            this.errorBars.add(new ErrorBar(dArray[n], dArray2[n], dArray3[n], dArray4[n]));
            ++n;
        }
        this.append(dArray, dArray2);
    }

    public void append(double[] dArray, double[] dArray2) {
        boolean bl = false;
        int n = 0;
        while (n < dArray.length) {
            double d = dArray[n];
            double d2 = dArray2[n];
            if (Double.isNaN(d) || Double.isInfinite(d) || Double.isInfinite(d2)) {
                bl = true;
            } else {
                this.xmax = Math.max(d, this.xmax);
                this.xmin = Math.min(d, this.xmin);
                if (d > 0.0) {
                    this.xmaxLogscale = Math.max(d, this.xmaxLogscale);
                    this.xminLogscale = Math.min(d, this.xminLogscale);
                }
                if (!Double.isNaN(d2)) {
                    Point2D point2D;
                    this.ymax = Math.max(d2, this.ymax);
                    this.ymin = Math.min(d2, this.ymin);
                    if (d2 > 0.0) {
                        this.ymaxLogscale = Math.max(d2, this.ymaxLogscale);
                        this.yminLogscale = Math.min(d2, this.yminLogscale);
                    }
                    if ((point2D = this.generalPath.getCurrentPoint()) == null) {
                        this.generalPath.moveTo((float)d, (float)d2);
                    } else {
                        this.generalPath.lineTo((float)d, (float)d2);
                    }
                }
            }
            ++n;
        }
        n = dArray.length;
        int n2 = this.xpoints.length - this.index;
        boolean bl2 = false;
        if (n > n2) {
            this.increaseCapacity(this.xpoints.length + n);
            bl2 = true;
        }
        n = Math.min(n, this.maxPoints);
        System.arraycopy(dArray, Math.max(0, dArray.length - n), this.xpoints, this.index, n);
        System.arraycopy(dArray2, Math.max(0, dArray.length - n), this.ypoints, this.index, n);
        this.index += n;
        if (bl) {
            this.removeBadData();
        }
        if (this.sorted) {
            this.insertionSort();
        }
        if (bl2) {
            this.resetXYMinMax();
        }
    }

    public void read(String string) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if ((string2 = string2.trim()).length() == 0 || string2.charAt(0) == '#') continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "\t");
                switch (stringTokenizer.countTokens()) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        this.append(Double.parseDouble(stringTokenizer.nextToken()), Double.parseDouble(stringTokenizer.nextToken()));
                        break;
                    }
                    default: {
                        throw new IOException();
                    }
                }
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File " + string + " not found.");
        }
        catch (IOException iOException) {
            System.err.println("Error reading file " + string);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("Error reading file " + string);
        }
    }

    public void write(String string) {
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
            int n = 0;
            while (n < this.index) {
                printWriter.println(String.valueOf(this.xpoints[n]) + "\t" + this.ypoints[n]);
                ++n;
            }
            printWriter.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File " + string + " not found.");
        }
        catch (IOException iOException) {
            System.err.println("Error writing file " + string);
        }
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.markerShape != 0) {
                this.drawScatterPlot(drawingPanel, graphics2D);
            }
            if (this.connected) {
                this.drawLinePlot(drawingPanel, graphics2D);
            }
        }
        catch (Exception exception) {}
    }

    public void clear() {
        this.index = 0;
        this.xpoints = new double[this.initialSize];
        this.ypoints = new double[this.initialSize];
        this.generalPath.reset();
        this.errorBars.clear();
        this.resetXYMinMax();
    }

    public String toString() {
        if (this.index == 0) {
            return "No data in dataset.";
        }
        String string = String.valueOf(this.xpoints[0]) + " " + this.ypoints[0] + "\n";
        StringBuffer stringBuffer = new StringBuffer(this.index * string.length());
        int n = 0;
        while (n < this.index) {
            stringBuffer.append(this.xpoints[n]);
            String string2 = "\n";
            try {
                string2 = System.getProperty("line.separator", "\n");
            }
            catch (SecurityException securityException) {}
            stringBuffer.append(" ");
            if (Double.isNaN(this.ypoints[n])) {
                stringBuffer.append("null");
            } else {
                stringBuffer.append(this.ypoints[n]);
            }
            stringBuffer.append(string2);
            ++n;
        }
        return stringBuffer.toString();
    }

    public static int countColumnsVisible(boolean[] blArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < blArray.length) {
            if (blArray[n2]) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public static int convertTableColumnIndex(boolean[] blArray, int n) {
        if (n == 0 && !blArray[0]) {
            ++n;
        } else if (n == 1 && !blArray[1]) {
            --n;
        }
        return n;
    }

    public void setXColumnVisible(boolean bl) {
        this.colVisible[0] = bl;
    }

    public void setYColumnVisible(boolean bl) {
        this.colVisible[1] = bl;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setStride(int n) {
        this.stride = n;
    }

    public boolean isXColumnVisible() {
        return this.colVisible[0];
    }

    public boolean isYColumnVisible() {
        return this.colVisible[1];
    }

    protected void insertionSort() {
        boolean bl = false;
        if (this.index < 2) {
            return;
        }
        int n = 1;
        while (n < this.index) {
            if (this.xpoints[n] < this.xpoints[n - 1]) {
                bl = true;
                this.moveDatum(n);
            }
            ++n;
        }
        if (bl) {
            this.recalculatePath();
        }
    }

    protected void recalculatePath() {
        this.generalPath.reset();
        if (this.index < 1) {
            return;
        }
        int n = 0;
        while (n < this.index) {
            if (!Double.isNaN(this.ypoints[n])) {
                this.generalPath.moveTo((float)this.xpoints[n], (float)this.ypoints[n]);
                break;
            }
            ++n;
        }
        int n2 = n + 1;
        while (n2 < this.index) {
            if (!Double.isNaN(this.ypoints[n2])) {
                this.generalPath.lineTo((float)this.xpoints[n2], (float)this.ypoints[n2]);
            }
            ++n2;
        }
    }

    protected void moveDatum(int n) {
        if (n < 1) {
            return;
        }
        double d = this.xpoints[n];
        double d2 = this.ypoints[n];
        int n2 = 0;
        while (n2 < this.index) {
            if (this.xpoints[n2] > d) {
                System.arraycopy(this.xpoints, n2, this.xpoints, n2 + 1, n - n2);
                this.xpoints[n2] = d;
                System.arraycopy(this.ypoints, n2, this.ypoints, n2 + 1, n - n2);
                this.ypoints[n2] = d2;
                return;
            }
            ++n2;
        }
    }

    protected void drawLinePlot(DrawingPanel drawingPanel, Graphics2D graphics2D) {
        boolean bl = true;
        int n = 0;
        while (n < this.index) {
            bl = Double.isNaN(this.ypoints[n]);
            if (!bl) break;
            ++n;
        }
        if (bl) {
            return;
        }
        AffineTransform affineTransform = drawingPanel.getPixelTransform();
        Shape shape = this.generalPath.createTransformedShape(affineTransform);
        graphics2D.setColor(this.lineColor);
        graphics2D.draw(shape);
    }

    protected void drawFilledPlot(DrawingPanel drawingPanel, Graphics2D graphics2D) {
        boolean bl = true;
        int n = 0;
        while (n < this.index) {
            bl = Double.isNaN(this.ypoints[n]);
            if (!bl) break;
            ++n;
        }
        if (bl) {
            return;
        }
        AffineTransform affineTransform = drawingPanel.getPixelTransform();
        Shape shape = this.generalPath.createTransformedShape(affineTransform);
        graphics2D.setColor(this.fillColor);
        graphics2D.fill(shape);
        graphics2D.setColor(this.edgeColor);
        graphics2D.draw(shape);
    }

    protected void drawScatterPlot(DrawingPanel drawingPanel, Graphics2D graphics2D) {
        if (this.markerShape == 5) {
            this.drawFilledPlot(drawingPanel, graphics2D);
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        RectangularShape rectangularShape = null;
        int n = this.markerSize * 2 + 1;
        Shape shape = graphics2D.getClip();
        graphics2D.setClip(drawingPanel.leftGutter - this.markerSize - 1, drawingPanel.topGutter - this.markerSize - 1, drawingPanel.getWidth() - drawingPanel.leftGutter - drawingPanel.rightGutter + 2 + 2 * this.markerSize, drawingPanel.getHeight() - drawingPanel.bottomGutter - drawingPanel.topGutter + 2 + 2 * this.markerSize);
        Rectangle rectangle = drawingPanel.getViewRect();
        if (rectangle != null) {
            graphics2D.clipRect(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        }
        int n2 = 0;
        while (n2 < this.index) {
            if (!(Double.isNaN(this.ypoints[n2]) || drawingPanel.isLogScaleX() && this.xpoints[n2] <= 0.0 || drawingPanel.isLogScaleY() && this.ypoints[n2] <= 0.0)) {
                d = drawingPanel.xToPix(this.xpoints[n2]);
                d2 = drawingPanel.yToPix(this.ypoints[n2]);
                switch (this.markerShape) {
                    case 7: {
                        double d3 = Math.min(drawingPanel.yToPix(0.0), drawingPanel.yToPix(drawingPanel.getYMin()));
                        double d4 = d3 - d2;
                        rectangularShape = d4 > 0.0 ? new Rectangle2D.Double(d - (double)this.markerSize, d2, n, d4) : new Rectangle2D.Double(d - (double)this.markerSize, d3, n, -d4);
                        graphics2D.setColor(this.fillColor);
                        graphics2D.fill(rectangularShape);
                        if (this.edgeColor == this.fillColor) break;
                        graphics2D.setColor(this.edgeColor);
                        graphics2D.draw(rectangularShape);
                        break;
                    }
                    case 8: {
                        double d3 = Math.min(drawingPanel.yToPix(0.0), drawingPanel.yToPix(drawingPanel.getYMin()));
                        rectangularShape = new Rectangle2D.Double(d - (double)this.markerSize, d2 - (double)this.markerSize, n, n);
                        graphics2D.setColor(this.edgeColor);
                        graphics2D.drawLine((int)d, (int)d2, (int)d, (int)d3);
                        graphics2D.setColor(this.fillColor);
                        graphics2D.fill(rectangularShape);
                        if (this.edgeColor == this.fillColor) break;
                        graphics2D.setColor(this.edgeColor);
                        graphics2D.draw(rectangularShape);
                        break;
                    }
                    case 2: {
                        rectangularShape = new Rectangle2D.Double(d - (double)this.markerSize, d2 - (double)this.markerSize, n, n);
                        graphics2D.setColor(this.fillColor);
                        graphics2D.fill(rectangularShape);
                        if (this.edgeColor == this.fillColor) break;
                        graphics2D.setColor(this.edgeColor);
                        graphics2D.draw(rectangularShape);
                        break;
                    }
                    case 1: {
                        rectangularShape = new Ellipse2D.Double(d - (double)this.markerSize, d2 - (double)this.markerSize, n, n);
                        graphics2D.setColor(this.fillColor);
                        graphics2D.fill(rectangularShape);
                        if (this.edgeColor == this.fillColor) break;
                        graphics2D.setColor(this.edgeColor);
                        graphics2D.draw(rectangularShape);
                        break;
                    }
                    case 6: {
                        rectangularShape = new Rectangle2D.Double(d, d2, 1.0, 1.0);
                        graphics2D.setColor(this.edgeColor);
                        graphics2D.draw(rectangularShape);
                        break;
                    }
                    case -1: {
                        Shape shape2 = AffineTransform.getTranslateInstance(d, d2).createTransformedShape(this.customMarker);
                        graphics2D.setColor(this.fillColor);
                        graphics2D.fill(shape2);
                        if (this.edgeColor == this.fillColor) break;
                        graphics2D.setColor(this.edgeColor);
                        graphics2D.draw(shape2);
                        break;
                    }
                    default: {
                        rectangularShape = new Rectangle2D.Double(d - (double)this.markerSize, d2 - (double)this.markerSize, n, n);
                        graphics2D.setColor(this.fillColor);
                        graphics2D.fill(rectangularShape);
                        if (this.edgeColor == this.fillColor) break;
                        graphics2D.setColor(this.edgeColor);
                        graphics2D.draw(rectangularShape);
                    }
                }
            }
            ++n2;
        }
        Iterator<ErrorBar> iterator = this.errorBars.iterator();
        while (iterator.hasNext()) {
            iterator.next().draw(drawingPanel, graphics2D);
        }
        graphics2D.setClip(shape);
    }

    private void removeBadData() {
        int n = 0;
        while (n < this.index) {
            if (Double.isNaN(this.xpoints[n]) || Double.isInfinite(this.xpoints[n]) || Double.isInfinite(this.ypoints[n])) {
                if (this.index == 1 || n == this.index - 1) {
                    --this.index;
                    break;
                }
                System.arraycopy(this.xpoints, n + 1, this.xpoints, n, this.index - n - 1);
                System.arraycopy(this.ypoints, n + 1, this.ypoints, n, this.index - n - 1);
                --this.index;
                --n;
            }
            ++n;
        }
    }

    private synchronized void increaseCapacity(int n) {
        int n2 = n - this.xpoints.length;
        n = Math.min(n, this.maxPoints);
        int n3 = Math.min(this.index, 3 * n / 4);
        if ((n3 = Math.min(n3, n - n2)) < 0) {
            n3 = 0;
        }
        double[] dArray = this.xpoints;
        this.xpoints = new double[n];
        System.arraycopy(dArray, this.index - n3, this.xpoints, 0, n3);
        double[] dArray2 = this.ypoints;
        this.ypoints = new double[n];
        System.arraycopy(dArray2, this.index - n3, this.ypoints, 0, n3);
        if (this.index != n3) {
            this.index = n3;
            this.resetXYMinMax();
            this.recalculatePath();
        }
        this.index = n3;
    }

    private void resetXYMinMax() {
        this.xmaxLogscale = -1.7976931348623157E308;
        this.xmax = -1.7976931348623157E308;
        this.ymaxLogscale = -1.7976931348623157E308;
        this.ymax = -1.7976931348623157E308;
        this.xminLogscale = Double.MAX_VALUE;
        this.xmin = Double.MAX_VALUE;
        this.yminLogscale = Double.MAX_VALUE;
        this.ymin = Double.MAX_VALUE;
        int n = 0;
        while (n < this.index) {
            if (!(Double.isNaN(this.xpoints[n]) || Double.isInfinite(this.xpoints[n]) || Double.isInfinite(this.ypoints[n]))) {
                double d;
                double d2 = this.xpoints[n];
                this.xmax = Math.max(d2, this.xmax);
                this.xmin = Math.min(d2, this.xmin);
                if (d2 > 0.0) {
                    this.xmaxLogscale = Math.max(d2, this.xmaxLogscale);
                    this.xminLogscale = Math.min(d2, this.xminLogscale);
                }
                if (!Double.isNaN(d = this.ypoints[n])) {
                    this.ymax = Math.max(d, this.ymax);
                    this.ymin = Math.min(d, this.ymin);
                    if (d > 0.0) {
                        this.ymaxLogscale = Math.max(d, this.ymaxLogscale);
                        this.yminLogscale = Math.min(d, this.yminLogscale);
                    }
                }
            }
            ++n;
        }
    }

    private double[] getValidPoints(double[] dArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < dArray.length) {
            if (n > 0) {
                dArray[n2 - n] = dArray[n2];
            }
            if (Double.isNaN(this.ypoints[n2])) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            return dArray;
        }
        double[] dArray2 = new double[this.index - n];
        System.arraycopy(dArray, 0, dArray2, 0, this.index - n);
        return dArray2;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    class ErrorBar
    implements Drawable {
        double x;
        double y;
        double delx;
        double dely;
        int tick = 3;

        ErrorBar(double d, double d2, double d3, double d4) {
            this.x = d;
            this.y = d2;
            this.delx = d3;
            this.dely = d4;
        }

        public void draw(DrawingPanel drawingPanel, Graphics graphics) {
            if (Double.isNaN(this.y)) {
                return;
            }
            int n = drawingPanel.xToPix(this.x);
            int n2 = drawingPanel.xToPix(this.x - this.delx);
            int n3 = drawingPanel.xToPix(this.x + this.delx);
            int n4 = drawingPanel.yToPix(this.y);
            int n5 = drawingPanel.yToPix(this.y - this.dely);
            int n6 = drawingPanel.yToPix(this.y + this.dely);
            graphics.setColor(Dataset.this.errorBarColor);
            graphics.drawLine(n2, n4, n3, n4);
            graphics.drawLine(n, n5, n, n6);
            graphics.drawLine(n2, n4 - this.tick, n2, n4 + this.tick);
            graphics.drawLine(n3, n4 - this.tick, n3, n4 + this.tick);
            graphics.drawLine(n - this.tick, n5, n + this.tick, n5);
            graphics.drawLine(n - this.tick, n6, n + this.tick, n6);
        }
    }

    protected static class Loader
    extends XMLLoader {
        protected Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            Dataset dataset = (Dataset)object;
            xMLControl.setValue("points", dataset.getPoints());
            xMLControl.setValue("index", dataset.index);
            xMLControl.setValue("marker_shape", dataset.getMarkerShape());
            xMLControl.setValue("marker_size", dataset.getMarkerSize());
            xMLControl.setValue("sorted", dataset.isSorted());
            xMLControl.setValue("connected", dataset.isConnected());
            xMLControl.setValue("name", dataset.name);
            xMLControl.setValue("x_name", dataset.xColumnName);
            xMLControl.setValue("y_name", dataset.yColumnName);
            xMLControl.setValue("x_description", dataset.xColumnDescription);
            xMLControl.setValue("y_description", dataset.yColumnDescription);
            xMLControl.setValue("line_color", dataset.lineColor);
            xMLControl.setValue("fill_color", dataset.fillColor);
            xMLControl.setValue("edge_color", dataset.edgeColor);
            xMLControl.setValue("errorbar_color", dataset.errorBarColor);
            xMLControl.setValue("datasetID", dataset.datasetID);
            xMLControl.setValue("visible", dataset.colVisible);
        }

        public Object createObject(XMLControl xMLControl) {
            Class<?> clazz = xMLControl.getObjectClass();
            if (Dataset.class.isAssignableFrom(clazz) && !Dataset.class.equals(clazz)) {
                try {
                    return clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
            return new Dataset();
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            Dataset dataset = (Dataset)object;
            double[][] dArray = (double[][])xMLControl.getObject("points");
            if (dArray != null && dArray.length > 0 && dArray[0] != null) {
                dataset.clear();
                int n = 0;
                while (n < dArray.length) {
                    dataset.append(dArray[n][0], dArray[n][1]);
                    ++n;
                }
            }
            double[] dArray2 = (double[])xMLControl.getObject("x_points");
            double[] dArray3 = (double[])xMLControl.getObject("y_points");
            if (dArray2 != null && dArray3 != null) {
                dataset.clear();
                dataset.append(dArray2, dArray3);
            }
            dataset.index = xMLControl.getInt("index");
            if (xMLControl.getPropertyNames().contains("marker_shape")) {
                dataset.setMarkerShape(xMLControl.getInt("marker_shape"));
            }
            if (xMLControl.getPropertyNames().contains("marker_size")) {
                dataset.setMarkerSize(xMLControl.getInt("marker_size"));
            }
            dataset.setSorted(xMLControl.getBoolean("sorted"));
            dataset.setConnected(xMLControl.getBoolean("connected"));
            dataset.name = xMLControl.getString("name");
            dataset.xColumnName = xMLControl.getString("x_name");
            dataset.yColumnName = xMLControl.getString("y_name");
            dataset.xColumnDescription = xMLControl.getString("x_description");
            dataset.yColumnDescription = xMLControl.getString("y_description");
            Color color = (Color)xMLControl.getObject("line_color");
            if (color != null) {
                dataset.lineColor = color;
            }
            if ((color = (Color)xMLControl.getObject("fill_color")) != null) {
                dataset.fillColor = color;
            }
            if ((color = (Color)xMLControl.getObject("edge_color")) != null) {
                dataset.edgeColor = color;
            }
            if ((color = (Color)xMLControl.getObject("errorbar_color")) != null) {
                dataset.errorBarColor = color;
            }
            dataset.setID(xMLControl.getInt("datasetID"));
            boolean[] blArray = (boolean[])xMLControl.getObject("visible");
            if (blArray != null) {
                dataset.colVisible = blArray;
            }
            return object;
        }
    }
}

