/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.Dimensioned;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.axes.CartesianAxes;
import org.opensourcephysics.display.axes.CartesianInteractive;
import org.opensourcephysics.display.axes.CustomAxes;
import org.opensourcephysics.display.axes.DrawableAxes;
import org.opensourcephysics.display.axes.PolarType2;
import org.opensourcephysics.numerics.FunctionTransform;
import org.opensourcephysics.numerics.LogBase10Function;

public class PlottingPanel
extends InteractivePanel {
    protected DrawableAxes axes;
    protected FunctionTransform functionTransform = new FunctionTransform();
    protected static final double log10 = Math.log(10.0);
    protected static final LogBase10Function logBase10Function = new LogBase10Function();

    public PlottingPanel(String string, String string2, String string3) {
        this(string, string2, string3, 0, 0);
    }

    public PlottingPanel(int n, int n2) {
        this("x", "y", DisplayRes.getString("PlottingPanel.DefaultTitle"), n, n2);
    }

    public PlottingPanel(String string, String string2, String string3, int n, int n2) {
        this.axes = new CartesianInteractive(this);
        this.axes.setXLabel(string, null);
        this.axes.setYLabel(string2, null);
        this.axes.setTitle(string3, null);
        this.functionTransform.setXFunction(logBase10Function);
        this.functionTransform.setYFunction(logBase10Function);
        if (n == 1) {
            this.logScaleX = true;
        }
        if (n2 == 1) {
            this.logScaleY = true;
        }
        this.setLogScale(this.logScaleX, this.logScaleY);
    }

    public Interactive getInteractive() {
        Interactive interactive = null;
        interactive = super.getInteractive();
        if (interactive == null && this.axes instanceof Interactive) {
            interactive = ((Interactive)((Object)this.axes)).findInteractive(this, this.mouseEvent.getX(), this.mouseEvent.getY());
        }
        return interactive;
    }

    public DrawableAxes getAxes() {
        return this.axes;
    }

    public void setAxes(DrawableAxes drawableAxes) {
        this.axes = drawableAxes;
        if (this.axes == null) {
            this.axes = new CustomAxes(this);
            this.setPreferredGutters(0, 0, 0, 0);
            this.setClipAtGutter(false);
            this.axes.setVisible(false);
        } else {
            this.setClipAtGutter(true);
        }
    }

    public void setPolar(String string, double d) {
        if (this.logScaleX || this.logScaleY) {
            System.err.println("The axes type cannot be swithed when using logarithmetic scales.");
            return;
        }
        PolarType2 polarType2 = new PolarType2(this);
        polarType2.setDeltaR(d);
        polarType2.setDeltaTheta(0.39269908169872414);
        this.setTitle(string);
        this.setSquareAspect(true);
        this.setClipAtGutter(true);
    }

    public void setCartesian(String string, String string2, String string3) {
        this.axes = new CartesianInteractive(this);
        this.axes.setXLabel(string, null);
        this.axes.setYLabel(string2, null);
        this.axes.setTitle(string3, null);
        this.setClipAtGutter(true);
    }

    public void setXLabel(String string) {
        this.axes.setXLabel(string, null);
    }

    public void setYLabel(String string) {
        this.axes.setYLabel(string, null);
    }

    public void setTitle(String string) {
        this.axes.setTitle(string, null);
    }

    public void setXLabel(String string, String string2) {
        this.axes.setXLabel(string, string2);
    }

    public void setYLabel(String string, String string2) {
        this.axes.setYLabel(string, string2);
    }

    public void setTitle(String string, String string2) {
        this.axes.setTitle(string, string2);
    }

    public void setAxesVisible(boolean bl) {
        this.axes.setVisible(bl);
    }

    public void setLogScale(boolean bl, boolean bl2) {
        if (this.axes instanceof CartesianAxes) {
            ((CartesianAxes)this.axes).setXLog(bl);
            this.logScaleX = bl;
        } else {
            this.logScaleX = false;
        }
        if (this.axes instanceof CartesianAxes) {
            ((CartesianAxes)this.axes).setYLog(bl2);
            this.logScaleY = bl2;
        } else {
            this.logScaleY = false;
        }
    }

    public void setLogScaleX(boolean bl) {
        if (this.axes instanceof CartesianAxes) {
            ((CartesianAxes)this.axes).setXLog(bl);
            this.logScaleX = bl;
        } else {
            this.logScaleX = false;
        }
    }

    public void setLogScaleY(boolean bl) {
        if (this.axes instanceof CartesianAxes) {
            ((CartesianAxes)this.axes).setYLog(bl);
            this.logScaleY = bl;
        } else {
            this.logScaleY = false;
        }
    }

    protected void computeGutters() {
        Dimension dimension;
        this.resetGutters();
        Dimension dimension2 = null;
        if (this.dimensionSetter != null) {
            dimension2 = this.dimensionSetter.getInterior(this);
        }
        if (this.axes instanceof Dimensioned && (dimension = ((Dimensioned)((Object)this.axes)).getInterior(this)) != null) {
            dimension2 = dimension;
        }
        if (dimension2 != null) {
            this.squareAspect = false;
            this.adjustableGutter = false;
            this.leftGutter = this.rightGutter = Math.max(0, this.getWidth() - dimension2.width) / 2;
            this.topGutter = this.bottomGutter = Math.max(0, this.getHeight() - dimension2.height) / 2;
        }
    }

    protected void paintFirst(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(Color.black);
        if (this.leftGutterPreferred > 0 || this.topGutterPreferred > 0 || this.rightGutterPreferred > 0 || this.bottomGutterPreferred > 0) {
            this.axes.draw(this, graphics);
        }
    }

    public double pixToX(int n) {
        if (this.logScaleX) {
            return Math.pow(10.0, super.pixToX(n));
        }
        return super.pixToX(n);
    }

    public int xToPix(double d) {
        if (this.logScaleX) {
            if (d <= 0.0) {
                d = Math.max((double)1.4E-45f, this.xmin);
            }
            return super.xToPix(PlottingPanel.logBase10(d));
        }
        return super.xToPix(d);
    }

    public float xToGraphics(double d) {
        if (this.logScaleX) {
            if (d <= 0.0) {
                d = Math.max((double)1.4E-45f, this.xmin);
            }
            return super.xToGraphics(PlottingPanel.logBase10(d));
        }
        return super.xToGraphics(d);
    }

    public double pixToY(int n) {
        if (this.logScaleY) {
            return Math.pow(10.0, super.pixToY(n));
        }
        return super.pixToY(n);
    }

    public int yToPix(double d) {
        if (this.logScaleY) {
            if (d <= 0.0) {
                d = Math.max((double)1.4E-45f, this.ymin);
            }
            return super.yToPix(PlottingPanel.logBase10(d));
        }
        return super.yToPix(d);
    }

    public float yToGraphics(double d) {
        if (this.logScaleY) {
            if (d <= 0.0) {
                d = Math.max((double)1.4E-45f, this.ymin);
            }
            return super.yToGraphics(PlottingPanel.logBase10(d));
        }
        return super.yToGraphics(d);
    }

    public int getBottomGutter() {
        return Math.max(this.bottomGutter, this.bottomGutterPreferred);
    }

    public int getTopGutter() {
        return Math.max(this.topGutter, this.topGutterPreferred);
    }

    public void setPixelScale() {
        this.xmin = this.xminPreferred;
        this.xmax = this.xmaxPreferred;
        this.ymin = this.yminPreferred;
        this.ymax = this.ymaxPreferred;
        if (this.dimensionSetter == null) {
            this.leftGutter = Math.max(this.leftGutter, this.leftGutterPreferred);
            this.topGutter = Math.max(this.topGutter, this.topGutterPreferred);
            this.rightGutter = Math.max(this.rightGutter, this.rightGutterPreferred);
            this.bottomGutter = Math.max(this.bottomGutter, this.bottomGutterPreferred);
        }
        if (this.logScaleX) {
            this.xmin = PlottingPanel.logBase10(Math.max(this.xmin, 1.0E-30));
            this.xmax = PlottingPanel.logBase10(Math.max(this.xmax, 1.0E-30));
            if (this.xmin == 0.0) {
                this.xmin = 1.0E-8;
            }
            if (this.xmax == 0.0) {
                this.xmax = Math.max(this.xmin + 1.0E-8, 1.0E-8);
            }
        }
        if (this.logScaleY) {
            this.ymin = PlottingPanel.logBase10(Math.max(this.ymin, 1.0E-30));
            this.ymax = PlottingPanel.logBase10(Math.max(this.ymax, 1.0E-30));
            if (this.ymin == 0.0) {
                this.ymin = 1.0E-8;
            }
            if (this.ymax == 0.0) {
                this.ymax = Math.max(this.ymin + 1.0E-8, 1.0E-8);
            }
        }
        this.width = this.getWidth();
        this.height = this.getHeight();
        if (this.fixedPixelPerUnit) {
            this.xmin = (this.xmaxPreferred + this.xminPreferred) / 2.0 - (double)Math.max(this.width - this.leftGutter - this.rightGutter - 1, 1) / this.xPixPerUnit / 2.0;
            this.xmax = (this.xmaxPreferred + this.xminPreferred) / 2.0 + (double)Math.max(this.width - this.leftGutter - this.rightGutter - 1, 1) / this.xPixPerUnit / 2.0;
            this.ymin = (this.ymaxPreferred + this.yminPreferred) / 2.0 - (double)Math.max(this.height - this.bottomGutter - this.topGutter - 1, 1) / this.yPixPerUnit / 2.0;
            this.ymax = (this.ymaxPreferred + this.yminPreferred) / 2.0 + (double)Math.max(this.height - this.bottomGutter - this.topGutter - 1, 1) / this.yPixPerUnit / 2.0;
            this.functionTransform.setTransform(this.xPixPerUnit, 0.0, 0.0, -this.yPixPerUnit, -this.xmin * this.xPixPerUnit + (double)this.leftGutter, this.ymax * this.yPixPerUnit + (double)this.topGutter);
            this.functionTransform.setApplyXFunction(false);
            this.functionTransform.setApplyYFunction(false);
            this.functionTransform.getMatrix(this.pixelMatrix);
            return;
        }
        this.xPixPerUnit = (double)(this.width - this.leftGutter - this.rightGutter) / (this.xmax - this.xmin);
        this.yPixPerUnit = (double)(this.height - this.bottomGutter - this.topGutter) / (this.ymax - this.ymin);
        if (this.squareAspect && !this.adjustableGutter) {
            double d = Math.abs(this.xPixPerUnit / this.yPixPerUnit);
            if (d >= 1.0) {
                d = Math.min(d, (double)this.width);
                this.xmin = this.xminPreferred - (this.xmaxPreferred - this.xminPreferred) * (d - 1.0) / 2.0;
                this.xmax = this.xmaxPreferred + (this.xmaxPreferred - this.xminPreferred) * (d - 1.0) / 2.0;
                this.xPixPerUnit = (double)(this.width - this.leftGutter - this.rightGutter) / (this.xmax - this.xmin);
            } else {
                d = Math.max(d, 1.0 / (double)this.height);
                this.ymin = this.yminPreferred - (this.ymaxPreferred - this.yminPreferred) * (1.0 / d - 1.0) / 2.0;
                this.ymax = this.ymaxPreferred + (this.ymaxPreferred - this.yminPreferred) * (1.0 / d - 1.0) / 2.0;
                this.yPixPerUnit = (double)(this.height - this.bottomGutter - this.topGutter) / (this.ymax - this.ymin);
            }
        }
        if (this.squareAspect && this.adjustableGutter) {
            if (Math.abs(this.xPixPerUnit / this.yPixPerUnit) >= 1.0) {
                this.xPixPerUnit = this.yPixPerUnit;
                float f = (float)this.width - (float)Math.abs((this.xmax - this.xmin) * this.xPixPerUnit);
                this.leftGutter = (int)(f / 2.0f + (float)this.leftGutterPreferred - (float)this.rightGutterPreferred + 0.5f);
                this.rightGutter = (int)((double)(f - (float)this.leftGutter) - 0.5);
                this.leftGutter = Math.max(0, this.leftGutter);
                this.rightGutter = Math.max(0, this.rightGutter);
            } else {
                this.yPixPerUnit = this.xPixPerUnit;
                float f = (float)this.height - (float)Math.abs((this.ymax - this.ymin) * this.yPixPerUnit);
                this.topGutter = (int)(f / 2.0f + (float)this.topGutterPreferred - (float)this.bottomGutterPreferred + 0.5f);
                this.bottomGutter = (int)(f - (float)this.topGutter);
                this.topGutter = Math.max(0, this.topGutter);
                this.bottomGutter = Math.max(0, this.bottomGutter);
            }
        }
        this.functionTransform.setTransform(this.xPixPerUnit, 0.0, 0.0, -this.yPixPerUnit, -this.xmin * this.xPixPerUnit + (double)this.leftGutter, this.ymax * this.yPixPerUnit + (double)this.topGutter);
        if (this.logScaleX) {
            this.functionTransform.setApplyXFunction(true);
        } else {
            this.functionTransform.setApplyXFunction(false);
        }
        if (this.logScaleY) {
            this.functionTransform.setApplyYFunction(true);
        } else {
            this.functionTransform.setApplyYFunction(false);
        }
        this.functionTransform.getMatrix(this.pixelMatrix);
    }

    public void recomputeTransform() {
        this.xPixPerUnit = (double)Math.max(this.width - this.leftGutter - this.rightGutter, 1) / (this.xmax - this.xmin);
        this.yPixPerUnit = (double)Math.max(this.height - this.bottomGutter - this.topGutter, 1) / (this.ymax - this.ymin);
        this.functionTransform.setTransform(this.xPixPerUnit, 0.0, 0.0, -this.yPixPerUnit, -this.xmin * this.xPixPerUnit + (double)this.leftGutter, this.ymax * this.yPixPerUnit + (double)this.topGutter);
        if (this.logScaleX) {
            this.functionTransform.setApplyXFunction(true);
        } else {
            this.functionTransform.setApplyXFunction(false);
        }
        if (this.logScaleY) {
            this.functionTransform.setApplyYFunction(true);
        } else {
            this.functionTransform.setApplyYFunction(false);
        }
        this.functionTransform.getMatrix(this.pixelMatrix);
    }

    public AffineTransform getPixelTransform() {
        return (AffineTransform)this.functionTransform.clone();
    }

    static double logBase10(double d) {
        return Math.log(d) / log10;
    }

    public static XML.ObjectLoader getLoader() {
        return new PlottingPanelLoader();
    }

    static class PlottingPanelLoader
    extends DrawingPanel.DrawingPanelLoader {
        PlottingPanelLoader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            PlottingPanel plottingPanel = (PlottingPanel)object;
            xMLControl.setValue("title", plottingPanel.axes.getTitle());
            xMLControl.setValue("x axis label", plottingPanel.axes.getXLabel());
            xMLControl.setValue("y axis label", plottingPanel.axes.getYLabel());
            super.saveObject(xMLControl, object);
        }

        public Object createObject(XMLControl xMLControl) {
            String string = xMLControl.getString("title");
            String string2 = xMLControl.getString("x axis label");
            String string3 = xMLControl.getString("y axis label");
            return new PlottingPanel(string2, string3, string);
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            PlottingPanel plottingPanel = (PlottingPanel)object;
            plottingPanel.setTitle(xMLControl.getString("title"));
            plottingPanel.setXLabel(xMLControl.getString("x axis label"));
            plottingPanel.setYLabel(xMLControl.getString("y axis label"));
            super.loadObject(xMLControl, object);
            return object;
        }
    }
}

