/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import javax.swing.JFrame;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Grid;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.MeasuredImage;
import org.opensourcephysics.display.axes.XAxis;
import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.GridPointData;
import org.opensourcephysics.display2d.Plot2D;
import org.opensourcephysics.display2d.Plot2DLoader;
import org.opensourcephysics.display2d.ZExpansion;

public class GrayscalePlot
extends MeasuredImage
implements Plot2D {
    GridData griddata;
    double floor;
    double ceil;
    boolean autoscaleZ = true;
    boolean symmetricZ = false;
    short[] bwData;
    Grid grid;
    ZExpansion zMap = null;
    private int ampIndex = 0;
    private JFrame legendFrame;

    public GrayscalePlot(GridData gridData) {
        this.setGridData(gridData);
        this.update();
    }

    public double indexToX(int n) {
        return this.griddata.indexToX(n);
    }

    public double indexToY(int n) {
        return this.griddata.indexToY(n);
    }

    public int xToIndex(double d) {
        return this.griddata.xToIndex(d);
    }

    public int yToIndex(double d) {
        return this.griddata.yToIndex(d);
    }

    public void setAll(Object object) {
        double[][] dArray = (double[][])object;
        this.copyData(dArray);
        this.update();
    }

    public void setAll(Object object, double d, double d2, double d3, double d4) {
        double[][] dArray = (double[][])object;
        this.copyData(dArray);
        if (this.griddata.isCellData()) {
            this.griddata.setCellScale(d, d2, d3, d4);
        } else {
            this.griddata.setScale(d, d2, d3, d4);
        }
        this.setMinMax(d, d2, d3, d4);
        this.update();
    }

    private void copyData(double[][] dArray) {
        if (this.griddata != null && !(this.griddata instanceof ArrayData)) {
            throw new IllegalStateException("SetAll only supports ArrayData for data storage.");
        }
        if (this.griddata == null || this.griddata.getNx() != dArray.length || this.griddata.getNy() != dArray[0].length) {
            this.griddata = new ArrayData(dArray.length, dArray[0].length, 1);
            this.setGridData(this.griddata);
        }
        double[][] dArray2 = this.griddata.getData()[0];
        int n = dArray2[0].length;
        int n2 = 0;
        int n3 = dArray2.length;
        while (n2 < n3) {
            System.arraycopy(dArray[n2], 0, dArray2[n2], 0, n);
            ++n2;
        }
    }

    public GridData getGridData() {
        return this.griddata;
    }

    public void setGridData(GridData gridData) {
        this.griddata = gridData;
        if (this.griddata == null) {
            return;
        }
        int n = this.griddata.getNx();
        int n2 = this.griddata.getNy();
        int n3 = n * n2;
        Grid grid = new Grid(n, n2, this.xmin, this.xmax, this.ymin, this.ymax);
        if (this.grid != null) {
            grid.setColor(this.grid.getColor());
            grid.setVisible(this.grid.isVisible());
        } else {
            grid.setColor(Color.pink);
        }
        this.grid = grid;
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{16}, false, false, 1, 1);
        ComponentSampleModel componentSampleModel = new ComponentSampleModel(1, n, n2, 1, n, new int[1]);
        this.bwData = new short[n3];
        DataBufferUShort dataBufferUShort = new DataBufferUShort(this.bwData, n3);
        WritableRaster writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferUShort, new Point(0, 0));
        this.image = new BufferedImage(componentColorModel, writableRaster, true, null);
        this.xmin = this.griddata.getLeft();
        this.xmax = this.griddata.getRight();
        this.ymin = this.griddata.getBottom();
        this.ymax = this.griddata.getTop();
    }

    public JFrame showLegend() {
        InteractivePanel interactivePanel = new InteractivePanel();
        interactivePanel.setPreferredSize(new Dimension(300, 66));
        interactivePanel.setPreferredGutters(0, 0, 0, 35);
        interactivePanel.setClipAtGutter(false);
        if (this.legendFrame == null || !this.legendFrame.isDisplayable()) {
            this.legendFrame = new JFrame(DisplayRes.getString("GUIUtils.Legend"));
        }
        this.legendFrame.setDefaultCloseOperation(2);
        this.legendFrame.setResizable(false);
        this.legendFrame.setContentPane(interactivePanel);
        int n = 256;
        GridPointData gridPointData = new GridPointData(n, 1, 1);
        double[][][] dArray = gridPointData.getData();
        double d = (this.ceil - this.floor) / (double)n;
        double d2 = this.floor - d / 2.0;
        int n2 = 0;
        int n3 = dArray.length;
        while (n2 < n3) {
            double d3 = d2;
            if (this.zMap != null) {
                d3 = this.zMap.evaluate(d3);
            }
            dArray[n2][0][2] = d3;
            d2 += d;
            ++n2;
        }
        gridPointData.setScale(this.floor - d, this.ceil + d, 0.0, 1.0);
        GrayscalePlot grayscalePlot = new GrayscalePlot(gridPointData);
        grayscalePlot.setShowGridLines(false);
        grayscalePlot.setAutoscaleZ(false, this.floor, this.ceil);
        grayscalePlot.update();
        interactivePanel.addDrawable(grayscalePlot);
        XAxis xAxis = new XAxis("");
        xAxis.setLocationType(2);
        xAxis.setLocation(-0.5);
        xAxis.setEnabled(true);
        interactivePanel.addDrawable(xAxis);
        this.legendFrame.pack();
        this.legendFrame.setVisible(true);
        return this.legendFrame;
    }

    public void setAutoscaleZ(boolean bl, double d, double d2) {
        this.autoscaleZ = bl;
        if (this.autoscaleZ) {
            this.update();
        } else {
            this.floor = d;
            this.ceil = d2;
            if (this.zMap != null) {
                this.zMap.setMinMax(this.floor, this.ceil);
            }
        }
    }

    public void setSymmetricZ(boolean bl) {
        this.symmetricZ = bl;
    }

    public boolean isSymmetricZ() {
        return this.symmetricZ;
    }

    public boolean isAutoscaleZ() {
        return this.autoscaleZ;
    }

    public double getFloor() {
        return this.floor;
    }

    public double getCeiling() {
        return this.ceil;
    }

    public void setShowGridLines(boolean bl) {
        this.grid.setVisible(bl);
    }

    public void setExpandedZ(boolean bl, double d) {
        if (bl && d > 0.0) {
            this.zMap = new ZExpansion(d);
            this.zMap.setMinMax(this.floor, this.ceil);
        } else {
            this.zMap = null;
        }
    }

    public void update() {
        if (this.griddata == null) {
            return;
        }
        if (this.autoscaleZ) {
            double[] dArray = this.griddata.getZRange(this.ampIndex);
            if (this.symmetricZ) {
                this.ceil = Math.max(Math.abs(dArray[1]), Math.abs(dArray[0]));
                this.floor = -this.ceil;
            } else {
                this.ceil = dArray[1];
                this.floor = dArray[0];
            }
            if (this.zMap != null) {
                this.zMap.setMinMax(this.floor, this.ceil);
            }
        }
        this.recolorImage();
        if (this.legendFrame != null && this.legendFrame.isDisplayable()) {
            this.showLegend();
        }
    }

    public void setIndexes(int[] nArray) {
        this.ampIndex = nArray[0];
    }

    protected void recolorImage() {
        block10: {
            double d;
            int n;
            int n2;
            double[][][] dArray;
            block9: {
                if (this.griddata == null) {
                    return;
                }
                if (this.griddata.isCellData()) {
                    double d2 = this.griddata.getDx();
                    double d3 = this.griddata.getDy();
                    this.xmin = this.griddata.getLeft() - d2 / 2.0;
                    this.xmax = this.griddata.getRight() + d2 / 2.0;
                    this.ymin = this.griddata.getBottom() + d3 / 2.0;
                    this.ymax = this.griddata.getTop() - d3 / 2.0;
                } else {
                    this.xmin = this.griddata.getLeft();
                    this.xmax = this.griddata.getRight();
                    this.ymin = this.griddata.getBottom();
                    this.ymax = this.griddata.getTop();
                }
                this.grid.setMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
                dArray = this.griddata.getData();
                n2 = this.griddata.getNx();
                n = this.griddata.getNy();
                d = 65534.0 / (this.ceil - this.floor);
                if (!(this.griddata instanceof GridPointData)) break block9;
                int n3 = this.ampIndex + 2;
                int n4 = 0;
                while (n4 < n2) {
                    int n5 = 0;
                    while (n5 < n) {
                        double d4 = dArray[n4][n5][n3];
                        if (this.zMap != null) {
                            d4 = this.zMap.evaluate(d4);
                        }
                        this.bwData[n5 * n2 + n4] = (d4 = d * (d4 - this.floor)) < 0.0 ? 0 : (d4 > 65534.0 ? -2 : (short)d4);
                        ++n5;
                    }
                    ++n4;
                }
                break block10;
            }
            if (!(this.griddata instanceof ArrayData)) break block10;
            int n6 = 0;
            while (n6 < n2) {
                int n7 = 0;
                while (n7 < n) {
                    double d5 = dArray[this.ampIndex][n6][n7];
                    if (this.zMap != null) {
                        d5 = this.zMap.evaluate(d5);
                    }
                    this.bwData[n7 * n2 + n6] = (d5 = d * (d5 - this.floor)) < 0.0 ? 0 : (d5 > 65534.0 ? -2 : (short)d5);
                    ++n7;
                }
                ++n6;
            }
        }
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.griddata == null) {
            return;
        }
        super.draw(drawingPanel, graphics);
        this.grid.draw(drawingPanel, graphics);
    }

    public void setFloorCeilColor(Color color, Color color2) {
    }

    public void setColorPalette(Color[] colorArray) {
    }

    public void setPaletteType(int n) {
    }

    public void setGridLineColor(Color color) {
        this.grid.setColor(color);
    }

    public static XML.ObjectLoader getLoader() {
        return new Plot2DLoader(){

            public Object createObject(XMLControl xMLControl) {
                return new GrayscalePlot(null);
            }
        };
    }
}

