/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.core;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.numerics.Transformation;

public interface Camera {
    public static final int MODE_PLANAR_XY = 0;
    public static final int MODE_PLANAR_XZ = 1;
    public static final int MODE_PLANAR_YZ = 2;
    public static final int MODE_PERSPECTIVE_OFF = 3;
    public static final int MODE_PERSPECTIVE_ON = 4;
    public static final int MODE_NO_PERSPECTIVE = 10;
    public static final int MODE_PERSPECTIVE = 11;

    public void setProjectionMode(int var1);

    public int getProjectionMode();

    public void reset();

    public void setXYZ(double var1, double var3, double var5);

    public void setXYZ(double[] var1);

    public double getX();

    public double getY();

    public double getZ();

    public void setFocusXYZ(double var1, double var3, double var5);

    public void setFocusXYZ(double[] var1);

    public double getFocusX();

    public double getFocusY();

    public double getFocusZ();

    public void setRotation(double var1);

    public double getRotation();

    public void setDistanceToScreen(double var1);

    public double getDistanceToScreen();

    public void setAzimuth(double var1);

    public double getAzimuth();

    public void setAltitude(double var1);

    public double getAltitude();

    public void setAzimuthAndAltitude(double var1, double var3);

    public Transformation getTransformation();

    public void copyFrom(Camera var1);

    public static abstract class Loader
    implements XML.ObjectLoader {
        public abstract Object createObject(XMLControl var1);

        public void saveObject(XMLControl xMLControl, Object object) {
            Camera camera = (Camera)object;
            xMLControl.setValue("projection mode", camera.getProjectionMode());
            xMLControl.setValue("x", camera.getX());
            xMLControl.setValue("y", camera.getY());
            xMLControl.setValue("z", camera.getZ());
            xMLControl.setValue("focus x", camera.getFocusX());
            xMLControl.setValue("focus y", camera.getFocusY());
            xMLControl.setValue("focus z", camera.getFocusZ());
            xMLControl.setValue("rotation", camera.getRotation());
            xMLControl.setValue("distance to screen", camera.getDistanceToScreen());
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            Camera camera = (Camera)object;
            camera.setProjectionMode(xMLControl.getInt("projection mode"));
            double d = xMLControl.getDouble("x");
            double d2 = xMLControl.getDouble("y");
            double d3 = xMLControl.getDouble("z");
            camera.setXYZ(d, d2, d3);
            d = xMLControl.getDouble("focus x");
            d2 = xMLControl.getDouble("focus y");
            d3 = xMLControl.getDouble("focus z");
            camera.setFocusXYZ(d, d2, d3);
            camera.setRotation(xMLControl.getDouble("rotation"));
            camera.setDistanceToScreen(xMLControl.getDouble("distance to screen"));
            return camera;
        }
    }
}

