/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.core;

import java.awt.Color;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display3d.core.Resolution;

public interface Style {
    public static final int CENTERED = 0;
    public static final int NORTH = 1;
    public static final int SOUTH = 2;
    public static final int EAST = 3;
    public static final int WEST = 4;
    public static final int NORTH_EAST = 5;
    public static final int NORTH_WEST = 6;
    public static final int SOUTH_EAST = 7;
    public static final int SOUTH_WEST = 8;

    public void setLineColor(Color var1);

    public Color getLineColor();

    public void setLineWidth(float var1);

    public float getLineWidth();

    public void setFillColor(Color var1);

    public Color getFillColor();

    public void setResolution(Resolution var1);

    public Resolution getResolution();

    public boolean isDrawingFill();

    public void setDrawingFill(boolean var1);

    public boolean isDrawingLines();

    public void setDrawingLines(boolean var1);

    public void setDepthFactor(double var1);

    public double getDepthFactor();

    public void setTexture(String var1, String var2, double var3, boolean var5);

    public String[] getTextures();

    public double getTransparency();

    public boolean getCombine();

    public void setRelativePosition(int var1);

    public int getRelativePosition();

    public void copyTo(Style var1);

    public static abstract class Loader
    extends XMLLoader {
        public abstract Object createObject(XMLControl var1);

        public void saveObject(XMLControl xMLControl, Object object) {
            Style style = (Style)object;
            xMLControl.setValue("line color", style.getLineColor());
            xMLControl.setValue("line width", style.getLineWidth());
            xMLControl.setValue("fill color", style.getFillColor());
            xMLControl.setValue("resolution", style.getResolution());
            xMLControl.setValue("drawing fill", style.isDrawingFill());
            xMLControl.setValue("drawing lines", style.isDrawingLines());
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            Style style = (Style)object;
            style.setLineColor((Color)xMLControl.getObject("line color"));
            style.setLineWidth((float)xMLControl.getDouble("line width"));
            style.setFillColor((Color)xMLControl.getObject("fill color"));
            style.setResolution((Resolution)xMLControl.getObject("resolution"));
            style.setDrawingFill(xMLControl.getBoolean("drawing fill"));
            style.setDrawingLines(xMLControl.getBoolean("drawing lines"));
            return object;
        }
    }
}

