/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.core;

import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;

public interface VisualizationHints {
    public static final int DECORATION_NONE = 0;
    public static final int DECORATION_AXES = 1;
    public static final int DECORATION_CUBE = 2;
    public static final int CURSOR_NONE = 0;
    public static final int CURSOR_XYZ = 1;
    public static final int CURSOR_CUBE = 2;
    public static final int CURSOR_CROSSHAIR = 3;

    public void setDecorationType(int var1);

    public int getDecorationType();

    public void setAxesLabels(String[] var1);

    public String[] getAxesLabels();

    public void setCursorType(int var1);

    public int getCursorType();

    public void setRemoveHiddenLines(boolean var1);

    public boolean isRemoveHiddenLines();

    public void setAllowQuickRedraw(boolean var1);

    public boolean isAllowQuickRedraw();

    public void setUseColorDepth(boolean var1);

    public boolean isUseColorDepth();

    public void setShowCoordinates(int var1);

    public int getShowCoordinates();

    public void setXFormat(String var1);

    public String getXFormat();

    public void setYFormat(String var1);

    public String getYFormat();

    public void setZFormat(String var1);

    public String getZFormat();

    public void copyFrom(VisualizationHints var1);

    public static abstract class Loader
    extends XMLLoader {
        public abstract Object createObject(XMLControl var1);

        public void saveObject(XMLControl xMLControl, Object object) {
            VisualizationHints visualizationHints = (VisualizationHints)object;
            xMLControl.setValue("decoration type", visualizationHints.getDecorationType());
            xMLControl.setValue("cursor type", visualizationHints.getCursorType());
            xMLControl.setValue("remove hidden lines", visualizationHints.isRemoveHiddenLines());
            xMLControl.setValue("allow quick redraw", visualizationHints.isAllowQuickRedraw());
            xMLControl.setValue("use color depth", visualizationHints.isUseColorDepth());
            xMLControl.setValue("show coordinates at", visualizationHints.getShowCoordinates());
            xMLControl.setValue("x format", visualizationHints.getXFormat());
            xMLControl.setValue("y format", visualizationHints.getYFormat());
            xMLControl.setValue("z format", visualizationHints.getZFormat());
            xMLControl.setValue("axes labels", visualizationHints.getAxesLabels());
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            VisualizationHints visualizationHints = (VisualizationHints)object;
            visualizationHints.setDecorationType(xMLControl.getInt("decoration type"));
            visualizationHints.setCursorType(xMLControl.getInt("cursor type"));
            visualizationHints.setRemoveHiddenLines(xMLControl.getBoolean("remove hidden lines"));
            visualizationHints.setAllowQuickRedraw(xMLControl.getBoolean("allow quick redraw"));
            visualizationHints.setUseColorDepth(xMLControl.getBoolean("use color depth"));
            visualizationHints.setShowCoordinates(xMLControl.getInt("show coordinates at"));
            visualizationHints.setXFormat(xMLControl.getString("x format"));
            visualizationHints.setYFormat(xMLControl.getString("y format"));
            visualizationHints.setZFormat(xMLControl.getString("z format"));
            visualizationHints.setAxesLabels((String[])xMLControl.getObject("axes labels"));
            return object;
        }
    }
}

