/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.opensourcephysics.ejs.Model;
import org.opensourcephysics.ejs.View;

public abstract class Simulation
implements Runnable {
    public static final int MAXIMUM_FPS = 25;
    public static final int MINIMUM_FPS = 1;
    private Model model = null;
    private View view = null;
    private Thread thread = null;
    private boolean autoplay = false;
    private boolean isPlaying = false;
    private long delay = 0L;
    private URL codebase = null;
    private static final String dummy = "";
    private static final Class<?> strClass = "".getClass();
    private static Hashtable<String, Object> memory = new Hashtable();

    private void errorMessage(String string) {
        System.err.println(String.valueOf(this.getClass().getName()) + ": " + string);
    }

    private void errorMessage(Exception exception) {
        System.err.println(String.valueOf(this.getClass().getName()) + ": Exception caught! Text follows:");
        exception.printStackTrace(System.err);
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.view = view;
    }

    public void setCodebase(URL uRL) {
        this.codebase = uRL;
    }

    public URL getCodebase() {
        return this.codebase;
    }

    public void play() {
        if (this.thread != null) {
            return;
        }
        this.thread = new Thread(this);
        this.thread.setPriority(1);
        this.thread.start();
        this.isPlaying = true;
    }

    public void pause() {
        this.thread = null;
        this.isPlaying = false;
    }

    public void run() {
        while (this.thread == Thread.currentThread()) {
            this.step();
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void setFPS(int n) {
        this.delay = n <= 1 ? 1000L : (n >= 25 ? 0L : (long)(1000.0 / (double)n));
    }

    public void setDelay(int n) {
        this.delay = n < 0 ? 0L : (long)n;
    }

    public void setAutoplay(boolean bl) {
        this.autoplay = bl;
    }

    public boolean isPlaying() {
        return this.isPlaying;
    }

    public boolean isPaused() {
        return !this.isPlaying;
    }

    public void reset() {
        this.pause();
        if (this.model != null) {
            this.model.reset();
            this.model.initialize();
            this.model.update();
        }
        if (this.view != null) {
            this.view.reset();
            this.view.initialize();
            this.view.update();
        }
        System.gc();
        if (this.autoplay) {
            this.play();
        }
    }

    public void initialize() {
        if (this.view != null) {
            this.view.read();
        }
        if (this.model != null) {
            this.model.initialize();
            this.model.update();
        }
        if (this.view != null) {
            this.view.initialize();
            this.view.update();
        }
    }

    public void apply() {
        if (this.view != null) {
            this.view.read();
        }
        this.update();
    }

    public void applyAll() {
        this.view.read();
        this.update();
    }

    public void apply(String string) {
        if (this.view != null) {
            this.view.read(string);
        }
    }

    public void update() {
        if (this.model != null) {
            this.model.update();
        }
        if (this.view != null) {
            this.view.update();
        }
    }

    public void step() {
        this.model.step();
        this.update();
    }

    public void updateAfterModelAction() {
        this.update();
    }

    public String getVariable(String string) {
        return this.getVariable(string, ",");
    }

    public String getVariable(String string, String string2) {
        if (this.model == null) {
            return null;
        }
        try {
            Field field = this.model.getClass().getField(string);
            if (field.getType().isArray()) {
                String string3 = dummy;
                Object object = field.get(this.model);
                int n = Array.getLength(object);
                int n2 = 0;
                while (n2 < n) {
                    string3 = n2 > 0 ? String.valueOf(string3) + string2 + Array.get(object, n2).toString() : String.valueOf(string3) + Array.get(object, n2).toString();
                    ++n2;
                }
                return string3;
            }
            return field.get(this.model).toString();
        }
        catch (Exception exception) {
            this.errorMessage(exception);
            return null;
        }
    }

    public boolean setVariable(String string, String string2) {
        return this.setVariable(string, string2, ",");
    }

    public boolean setVariable(String string, String string2, String string3) {
        if (this.model == null) {
            return false;
        }
        try {
            Field field = this.model.getClass().getField(string);
            if (field.getType().isArray()) {
                boolean bl = true;
                Object object = field.get(this.model);
                int n = 0;
                int n2 = Array.getLength(object);
                Class<?> clazz = field.getType().getComponentType();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
                if (n2 < stringTokenizer.countTokens()) {
                    this.errorMessage("Warning: there are less elements in the array than values provided!");
                } else if (n2 > stringTokenizer.countTokens()) {
                    this.errorMessage("Warning: there are more elements in the array than values provided!");
                }
                while (stringTokenizer.hasMoreTokens() && n < n2) {
                    String string4 = stringTokenizer.nextToken();
                    if (clazz.equals(Double.TYPE)) {
                        Array.setDouble(object, n, Double.parseDouble(string4));
                    } else if (clazz.equals(Float.TYPE)) {
                        Array.setFloat(object, n, Float.parseFloat(string4));
                    } else if (clazz.equals(Byte.TYPE)) {
                        Array.setByte(object, n, Byte.parseByte(string4));
                    } else if (clazz.equals(Short.TYPE)) {
                        Array.setShort(object, n, Short.parseShort(string4));
                    } else if (clazz.equals(Integer.TYPE)) {
                        Array.setInt(object, n, Integer.parseInt(string4));
                    } else if (clazz.equals(Long.TYPE)) {
                        Array.setLong(object, n, Long.parseLong(string4));
                    } else if (clazz.equals(Boolean.TYPE)) {
                        if (string4.trim().toLowerCase().equals("true")) {
                            Array.setBoolean(object, n, true);
                        } else {
                            Array.setBoolean(object, n, false);
                        }
                    } else if (clazz.equals(Character.TYPE)) {
                        Array.setChar(object, n, string4.charAt(0));
                    } else if (clazz.equals(strClass)) {
                        Array.set(object, n, string4);
                    } else {
                        bl = false;
                    }
                    ++n;
                }
                return bl;
            }
            Class<?> clazz = field.getType();
            if (clazz.equals(Double.TYPE)) {
                field.setDouble(this.model, Double.parseDouble(string2));
            } else if (clazz.equals(Float.TYPE)) {
                field.setFloat(this.model, Float.parseFloat(string2));
            } else if (clazz.equals(Byte.TYPE)) {
                field.setByte(this.model, Byte.parseByte(string2));
            } else if (clazz.equals(Short.TYPE)) {
                field.setShort(this.model, Short.parseShort(string2));
            } else if (clazz.equals(Integer.TYPE)) {
                field.setInt(this.model, Integer.parseInt(string2));
            } else if (clazz.equals(Long.TYPE)) {
                field.setLong(this.model, Long.parseLong(string2));
            } else if (clazz.equals(Boolean.TYPE)) {
                if (string2.trim().toLowerCase().equals("true")) {
                    field.setBoolean(this.model, true);
                } else {
                    field.setBoolean(this.model, false);
                }
            } else if (clazz.equals(Character.TYPE)) {
                field.setChar(this.model, string2.charAt(0));
            } else if (clazz.equals(strClass)) {
                field.set(this.model, string2);
            } else {
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            this.errorMessage(exception);
            return false;
        }
    }

    public boolean setVariables(String string) {
        return this.setVariables(string, ";", ",");
    }

    public boolean setVariables(String string, String string2, String string3) {
        boolean bl = true;
        String string4 = dummy;
        String string5 = dummy;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string6 = stringTokenizer.nextToken();
            int n = string6.indexOf(61);
            if (n < 0) {
                bl = false;
                continue;
            }
            string4 = string6.substring(0, n).trim();
            boolean bl2 = this.setVariable(string4, string5 = string6.substring(n + 1).trim(), string3);
            if (bl2) continue;
            bl = false;
        }
        this.update();
        return bl;
    }

    public boolean saveState(String string) {
        if (this.model == null) {
            return false;
        }
        try {
            OutputStream outputStream = string.startsWith("ejs:") ? new ByteArrayOutputStream() : new FileOutputStream(string);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(bufferedOutputStream);
            Field[] fieldArray = this.model.getClass().getFields();
            int n = 0;
            while (n < fieldArray.length) {
                if (fieldArray[n].get(this.model) instanceof Serializable) {
                    objectOutputStream.writeObject(fieldArray[n].get(this.model));
                }
                ++n;
            }
            objectOutputStream.close();
            if (string.startsWith("ejs:")) {
                memory.put(string, ((ByteArrayOutputStream)outputStream).toByteArray());
            }
            return true;
        }
        catch (Exception exception) {
            this.errorMessage("Error when trying to save" + string);
            exception.printStackTrace(System.err);
            return false;
        }
    }

    public boolean readState(String string) {
        return this.readState(string, null);
    }

    public boolean readState(String string, URL uRL) {
        if (this.model == null) {
            return false;
        }
        try {
            Object object;
            InputStream inputStream;
            if (string.startsWith("ejs:")) {
                inputStream = new ByteArrayInputStream((byte[])memory.get(string));
            } else if (string.startsWith("url:")) {
                object = string.substring(4);
                if (uRL != null && !((String)object).startsWith("http:")) {
                    object = uRL + (String)object;
                }
                inputStream = new URL((String)object).openStream();
            } else {
                inputStream = new FileInputStream(string);
            }
            object = new BufferedInputStream(inputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)object);
            Field[] fieldArray = this.model.getClass().getFields();
            int n = 0;
            while (n < fieldArray.length) {
                if (fieldArray[n].get(this.model) instanceof Serializable) {
                    fieldArray[n].set(this.model, objectInputStream.readObject());
                }
                ++n;
            }
            objectInputStream.close();
            if (this.view != null) {
                this.view.initialize();
            }
            this.update();
            return true;
        }
        catch (Exception exception) {
            this.errorMessage("Error when trying to read " + string);
            exception.printStackTrace(System.err);
            return false;
        }
    }
}

