/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control;

import java.awt.Container;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import org.opensourcephysics.controls.Calculation;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.ejs.control.EjsControlFrame;

public class EjsCalculationControl
extends EjsControlFrame {
    protected JPanel controlPanel;
    protected DrawingPanel drawingPanel;
    protected Calculation model;

    public EjsCalculationControl(Calculation calculation, DrawingFrame drawingFrame, String[] stringArray) {
        super(calculation, "name=controlFrame;title=QM Superposition;location=400,0;layout=border;exit=true; visible=false");
        this.model = calculation;
        this.addTarget("control", this);
        this.addTarget("model", calculation);
        if (drawingFrame != null) {
            this.getMainFrame().setAnimated(drawingFrame.isAnimated());
            this.getMainFrame().setAutoclear(drawingFrame.isAutoclear());
            this.getMainFrame().setBackground(drawingFrame.getBackground());
            this.getMainFrame().setTitle(drawingFrame.getTitle());
            this.drawingPanel = drawingFrame.getDrawingPanel();
            this.addObject(this.drawingPanel, "Panel", "name=drawingPanel; parent=controlFrame; position=center");
            drawingFrame.setDrawingPanel(null);
            drawingFrame.dispose();
        }
        this.add("Panel", "name=controlPanel; parent=controlFrame; layout=border; position=south");
        this.add("Panel", "name=buttonPanel;position=west;parent=controlPanel;layout=flow");
        this.add("Button", "parent=buttonPanel;tooltip=Calculate;image=/org/opensourcephysics/resources/controls/images/play.gif; action=control.calculate();name=calculateButton");
        this.add("Button", "parent=buttonPanel; tooltip=Reset calculation;image=/org/opensourcephysics/resources/controls/images/reset.gif; action=control.resetCalculation()");
        this.controlPanel = (JPanel)this.getElement("controlPanel").getComponent();
        this.controlPanel.setBorder(new EtchedBorder());
        this.customize();
        calculation.setControl(this);
        calculation.resetCalculation();
        this.loadXML(stringArray);
        Container container = (Container)this.getElement("controlFrame").getComponent();
        if (!OSPRuntime.appletMode) {
            container.setVisible(true);
        }
        if (calculation instanceof PropertyChangeListener) {
            this.addPropertyChangeListener((PropertyChangeListener)((Object)calculation));
        }
        this.getMainFrame().pack();
        this.getMainFrame().doLayout();
        GUIUtils.showDrawingAndTableFrames();
    }

    protected void customize() {
    }

    public void resetCalculation() {
        this.messageArea.setText("");
        GUIUtils.clearDrawingFrameData(true);
        this.model.resetCalculation();
        if (this.xmlDefault != null) {
            this.xmlDefault.loadObject(this.getOSPApp());
        } else {
            this.model.calculate();
        }
        GUIUtils.showDrawingAndTableFrames();
    }

    public void calculate() {
        GUIUtils.clearDrawingFrameData(true);
        this.model.calculate();
        GUIUtils.showDrawingAndTableFrames();
    }
}

