/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import javax.swing.ImageIcon;
import org.opensourcephysics.tools.ResourceLoader;

public class Utils {
    private static Hashtable<String, ImageIcon> cacheImages = new Hashtable();
    private static byte[] enormous = new byte[100000];

    public static boolean fileExists(String string, String string2) {
        int n;
        if (string2 == null) {
            return false;
        }
        if (cacheImages.get(string2) != null) {
            return true;
        }
        if (string != null) {
            if (string.startsWith("file:")) {
                string = "file:///" + string.substring(6);
            }
            if (!string.endsWith("/")) {
                string = String.valueOf(string) + "/";
            }
        }
        if ((n = string2.indexOf(43)) >= 0) {
            return Utils.fileExistsInJar(string, string2.substring(0, n), string2.substring(n + 1));
        }
        if (string == null) {
            File file = new File(string2);
            return file.exists();
        }
        try {
            URL uRL = new URL(String.valueOf(string) + string2);
            InputStream inputStream = uRL.openStream();
            inputStream.close();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean fileExistsInJar(String string, String string2, String string3) {
        if (string3 == null || string2 == null) {
            return false;
        }
        InputStream inputStream = null;
        JarInputStream jarInputStream = null;
        try {
            Object object;
            if (string == null) {
                inputStream = new FileInputStream(string2);
                jarInputStream = new JarInputStream(inputStream);
            } else {
                object = new URL(String.valueOf(string) + string2);
                inputStream = ((URL)object).openStream();
                jarInputStream = new JarInputStream(inputStream);
            }
            while ((object = jarInputStream.getNextJarEntry()) != null) {
                if (((ZipEntry)object).isDirectory() || !((ZipEntry)object).getName().equals(string3)) continue;
                jarInputStream.close();
                inputStream.close();
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        jarInputStream.close();
        inputStream.close();
        return false;
    }

    public static ImageIcon icon(String string, String string2) {
        return Utils.icon(string, string2, true);
    }

    public static ImageIcon icon(String string, String string2, boolean bl) {
        int n;
        if (string2 == null) {
            return null;
        }
        ImageIcon imageIcon = cacheImages.get(string2);
        if (imageIcon != null) {
            return imageIcon;
        }
        if (string != null) {
            if (string.startsWith("file:")) {
                string = "file:///" + string.substring(6);
            }
            if (!string.endsWith("/")) {
                string = String.valueOf(string) + "/";
            }
        }
        if ((n = string2.indexOf(43)) >= 0) {
            imageIcon = Utils.iconJar(string, string2.substring(0, n), string2.substring(n + 1), bl);
        } else if (string == null) {
            File file = new File(string2);
            if (file.exists()) {
                imageIcon = new ImageIcon(string2);
            }
            if (imageIcon == null) {
                imageIcon = ResourceLoader.getIcon(string2);
            }
        } else {
            try {
                URL uRL = new URL(String.valueOf(string) + string2);
                imageIcon = new ImageIcon(uRL);
            }
            catch (Exception exception) {
                if (bl) {
                    exception.printStackTrace();
                }
                imageIcon = null;
            }
        }
        if (imageIcon == null || imageIcon.getIconHeight() <= 0) {
            if (bl) {
                System.out.println("Unable to load image " + string2);
            }
        } else {
            cacheImages.put(string2, imageIcon);
        }
        return imageIcon;
    }

    public static ImageIcon iconJar(String string, String string2, String string3, boolean bl) {
        if (string3 == null || string2 == null) {
            return null;
        }
        ImageIcon imageIcon = null;
        InputStream inputStream = null;
        JarInputStream jarInputStream = null;
        try {
            if (string == null) {
                inputStream = new FileInputStream(string2);
                jarInputStream = new JarInputStream(inputStream);
            } else {
                URL uRL = new URL(String.valueOf(string) + string2);
                inputStream = uRL.openStream();
                jarInputStream = new JarInputStream(inputStream);
            }
            boolean bl2 = false;
            byte[] byArray = null;
            while (!bl2) {
                JarEntry jarEntry = jarInputStream.getNextJarEntry();
                if (jarEntry == null) break;
                if (jarEntry.isDirectory() || !jarEntry.getName().equals(string3)) continue;
                long l = (int)jarEntry.getSize();
                int n = 0;
                int n2 = 0;
                while (n2 >= 0) {
                    n2 = jarInputStream.read(enormous, n, 255);
                    if (n2 == -1) break;
                    n += n2;
                }
                l = n;
                byArray = new byte[(int)l];
                System.arraycopy(enormous, 0, byArray, 0, (int)l);
                bl2 = true;
            }
            imageIcon = new ImageIcon(byArray);
            jarInputStream.close();
        }
        catch (Exception exception) {
            if (bl) {
                exception.printStackTrace();
            }
            imageIcon = null;
        }
        return imageIcon;
    }
}

