/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.swing.ConstantParser;
import org.opensourcephysics.ejs.control.swing.ControlRadioButton;
import org.opensourcephysics.ejs.control.swing.ControlSwingElement;
import org.opensourcephysics.ejs.control.value.BooleanValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ControlContainer
extends ControlSwingElement {
    private static final BooleanValue falseValue = new BooleanValue(false);
    protected Vector<ControlElement> radioButtons = new Vector();
    protected Vector<ControlElement> children = new Vector();

    public ControlContainer(Object object) {
        super(object);
    }

    public Container getContainer() {
        return (Container)this.getVisual();
    }

    public void add(ControlElement controlElement) {
        this.children.add(controlElement);
        Container container = this.getContainer();
        LayoutManager layoutManager = container.getLayout();
        String string = controlElement.getProperty("_ejs_indexInParent_");
        int n = -1;
        if (string != null) {
            n = Integer.parseInt(string);
        }
        controlElement.setProperty("_ejs_indexInParent_", null);
        if (layoutManager instanceof BorderLayout) {
            String string2 = controlElement.getProperty("position");
            if (string2 != null) {
                container.add(controlElement.getComponent(), ConstantParser.constraintsConstant(string2).getString(), n);
            } else {
                container.add(controlElement.getComponent(), "Center", n);
            }
        } else {
            container.add(controlElement.getComponent(), n);
        }
        this.adjustSize();
        if (controlElement instanceof ControlRadioButton) {
            this.radioButtons.add(controlElement);
            ((ControlRadioButton)controlElement).setParent(this);
        }
        this.propagateProperty(controlElement, "font", this.getProperty("font"));
        this.propagateProperty(controlElement, "foreground", this.getProperty("foreground"));
        this.propagateProperty(controlElement, "background", this.getProperty("background"));
    }

    public void adjustSize() {
        this.getContainer().validate();
        this.getContainer().repaint();
        ControlContainer.resizeContainer(this.getContainer());
        ControlContainer.resizeContainer(this.getComponent().getParent());
    }

    private static void resizeContainer(Container container) {
        if (container == null) {
            return;
        }
        Rectangle rectangle = container.getBounds();
        container.setBounds(rectangle.x, rectangle.y, rectangle.width + 1, rectangle.height + 1);
        container.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        container.validate();
        container.repaint();
    }

    public Vector<ControlElement> getChildren() {
        return this.children;
    }

    public void remove(ControlElement controlElement) {
        this.children.remove(controlElement);
        Container container = this.getContainer();
        container.remove(controlElement.getComponent());
        container.validate();
        container.repaint();
        if (controlElement instanceof ControlRadioButton) {
            this.radioButtons.remove(controlElement);
            ((ControlRadioButton)controlElement).setParent(null);
        }
    }

    public void informRadioGroup(ControlRadioButton controlRadioButton, boolean bl) {
        if (!bl) {
            return;
        }
        Enumeration<ControlElement> enumeration = this.radioButtons.elements();
        while (enumeration.hasMoreElements()) {
            ControlRadioButton controlRadioButton2 = (ControlRadioButton)enumeration.nextElement();
            if (controlRadioButton2 == controlRadioButton) continue;
            boolean bl2 = controlRadioButton2.isActive();
            controlRadioButton2.setActive(false);
            controlRadioButton2.setValue(4, falseValue);
            controlRadioButton2.reportChanges();
            controlRadioButton2.setActive(bl2);
        }
    }

    private void propagateProperty(ControlElement controlElement, String string, String string2) {
        if (controlElement.getProperty(string) == null) {
            controlElement.setProperty(string, string2);
        }
    }

    private void propagateProperty(String string, String string2) {
        int n = 0;
        while (n < this.children.size()) {
            this.propagateProperty(this.children.elementAt(n), string, string2);
            ++n;
        }
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("visible")) {
            return "boolean";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public ControlElement setProperty(String string, String string2) {
        ControlElement controlElement = super.setProperty(string, string2);
        if (string.equals("font") || string.equals("foreground") || string.equals("background")) {
            this.propagateProperty(string, string2);
        }
        return controlElement;
    }
}

