/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractiveMouseHandler;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.displayejs.InteractionEvent;
import org.opensourcephysics.displayejs.InteractionTarget;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Point3D;
import org.opensourcephysics.ejs.control.swing.ControlDrawable;
import org.opensourcephysics.ejs.control.swing.ControlDrawablesParent;
import org.opensourcephysics.ejs.control.value.DoubleValue;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlDrawingPanel
extends ControlDrawablesParent
implements InteractiveMouseHandler {
    private static final int[] posIndex = new int[]{6, 7};
    protected InteractivePanel drawingPanel;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private Rectangle myGutters = null;
    private DoubleValue[] posValues = new DoubleValue[]{new DoubleValue(0.0), new DoubleValue(0.0)};
    private static ArrayList infoList = null;
    private InteractionTarget targetHit = null;

    public ControlDrawingPanel(Object object) {
        super(object);
    }

    protected Component createVisual(Object object) {
        if (object instanceof InteractivePanel) {
            this.drawingPanel = (InteractivePanel)object;
        } else {
            this.drawingPanel = new InteractivePanel();
            this.drawingPanel.enableInspector(false);
            this.drawingPanel.setSquareAspect(false);
        }
        this.drawingPanel.removeOptionController();
        this.minX = this.drawingPanel.getXMin();
        this.maxX = this.drawingPanel.getXMax();
        this.minY = this.drawingPanel.getYMin();
        this.maxY = this.drawingPanel.getYMax();
        this.drawingPanel.render();
        this.drawingPanel.setInteractiveMouseHandler(this);
        return this.drawingPanel;
    }

    protected int[] getPosIndex() {
        return posIndex;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("autoscaleX");
            infoList.add("autoscaleY");
            infoList.add("minimumX");
            infoList.add("maximumX");
            infoList.add("minimumY");
            infoList.add("maximumY");
            infoList.add("x");
            infoList.add("y");
            infoList.add("pressaction");
            infoList.add("dragaction");
            infoList.add("action");
            infoList.add("square");
            infoList.add("showCoordinates");
            infoList.add("gutters");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("autoscaleX")) {
            return "boolean";
        }
        if (string.equals("autoscaleY")) {
            return "boolean";
        }
        if (string.equals("minimumX")) {
            return "int|double";
        }
        if (string.equals("maximumX")) {
            return "int|double";
        }
        if (string.equals("minimumY")) {
            return "int|double";
        }
        if (string.equals("maximumY")) {
            return "int|double";
        }
        if (string.equals("x")) {
            return "int|double";
        }
        if (string.equals("y")) {
            return "int|double";
        }
        if (string.equals("action")) {
            return "Action CONSTANT";
        }
        if (string.equals("pressaction")) {
            return "Action CONSTANT";
        }
        if (string.equals("dragaction")) {
            return "Action CONSTANT";
        }
        if (string.equals("square")) {
            return "boolean BASIC";
        }
        if (string.equals("showCoordinates")) {
            return "boolean BASIC";
        }
        if (string.equals("gutters")) {
            return "Margins|Object BASIC";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.drawingPanel.setAutoscaleX(value.getBoolean());
                break;
            }
            case 1: {
                this.drawingPanel.setAutoscaleY(value.getBoolean());
                break;
            }
            case 2: {
                if (value.getDouble() == this.minX) break;
                this.minX = value.getDouble();
                this.drawingPanel.setPreferredMinMaxX(this.minX, this.maxX);
                break;
            }
            case 3: {
                if (value.getDouble() == this.maxX) break;
                this.maxX = value.getDouble();
                this.drawingPanel.setPreferredMinMaxX(this.minX, this.maxX);
                break;
            }
            case 4: {
                if (value.getDouble() == this.minY) break;
                this.minY = value.getDouble();
                this.drawingPanel.setPreferredMinMaxY(this.minY, this.maxY);
                break;
            }
            case 5: {
                if (value.getDouble() == this.maxY) break;
                this.maxY = value.getDouble();
                this.drawingPanel.setPreferredMinMaxY(this.minY, this.maxY);
                break;
            }
            case 6: {
                this.posValues[0].value = value.getDouble();
                break;
            }
            case 7: {
                this.posValues[1].value = value.getDouble();
                break;
            }
            case 8: {
                this.removeAction(10, this.getProperty("pressaction"));
                this.addAction(10, value.getString());
                break;
            }
            case 9: {
                this.removeAction(1, this.getProperty("dragaction"));
                this.addAction(1, value.getString());
                break;
            }
            case 10: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, value.getString());
                break;
            }
            case 11: {
                this.drawingPanel.setSquareAspect(value.getBoolean());
                break;
            }
            case 12: {
                this.drawingPanel.setShowCoordinates(value.getBoolean());
                break;
            }
            case 13: {
                Rectangle rectangle;
                if (!(value.getObject() instanceof Rectangle) || (rectangle = (Rectangle)value.getObject()) == this.myGutters) break;
                this.drawingPanel.setPreferredGutters(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.myGutters = rectangle;
                break;
            }
            default: {
                super.setValue(n - 14, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.drawingPanel.setAutoscaleX(false);
                break;
            }
            case 1: {
                this.drawingPanel.setAutoscaleY(false);
                break;
            }
            case 2: {
                this.minX = 0.0;
                this.drawingPanel.setPreferredMinMaxX(0.0, this.maxX);
                break;
            }
            case 3: {
                this.maxX = 1.0;
                this.drawingPanel.setPreferredMinMaxX(this.minX, 1.0);
                break;
            }
            case 4: {
                this.minY = 0.0;
                this.drawingPanel.setPreferredMinMaxY(0.0, this.maxY);
                break;
            }
            case 5: {
                this.maxY = 1.0;
                this.drawingPanel.setPreferredMinMaxY(this.minY, 1.0);
                break;
            }
            case 6: {
                this.posValues[0].value = (this.minX + this.maxX) / 2.0;
                break;
            }
            case 7: {
                this.posValues[1].value = (this.minY + this.maxY) / 2.0;
                break;
            }
            case 8: {
                this.removeAction(10, this.getProperty("pressaction"));
                break;
            }
            case 9: {
                this.removeAction(1, this.getProperty("dragaction"));
                break;
            }
            case 10: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            case 11: {
                this.drawingPanel.setSquareAspect(false);
                break;
            }
            case 12: {
                this.drawingPanel.setShowCoordinates(true);
                break;
            }
            case 13: {
                this.drawingPanel.setPreferredGutters(0, 0, 0, 0);
                this.myGutters = null;
                break;
            }
            default: {
                super.setDefaultValue(n - 14);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return null;
            }
            case 6: {
                return this.posValues[0];
            }
            case 7: {
                return this.posValues[1];
            }
        }
        return super.getValue(n - 14);
    }

    public ControlDrawable getSelectedDrawable() {
        Object object;
        if (this.targetHit != null && this.targetHit.getSource() instanceof InteractiveElement && (object = ((InteractiveElement)this.targetHit.getSource()).getDataObject()) instanceof ControlDrawable) {
            return (ControlDrawable)object;
        }
        return null;
    }

    public void handleMouseAction(InteractivePanel interactivePanel, MouseEvent mouseEvent) {
        switch (interactivePanel.getMouseAction()) {
            case 1: {
                Interactive interactive = interactivePanel.getInteractive();
                if (interactive instanceof InteractionTarget) {
                    this.targetHit = (InteractionTarget)interactive;
                    this.targetHit.getSource().invokeActions(new InteractionEvent((Object)this.targetHit.getSource(), 2000, null, this.targetHit));
                    break;
                }
                this.targetHit = null;
                this.mousePressed(interactivePanel.getMouseX(), interactivePanel.getMouseY());
                break;
            }
            case 3: {
                if (this.targetHit != null) {
                    Point3D point3D = new Point3D(interactivePanel.getMouseX(), interactivePanel.getMouseY(), 0.0);
                    this.targetHit.updateHotspot(interactivePanel, point3D);
                    this.targetHit.getSource().invokeActions(new InteractionEvent((Object)this.targetHit.getSource(), 2001, null, this.targetHit));
                    interactivePanel.repaint();
                    break;
                }
                this.mouseDragged(interactivePanel.getMouseX(), interactivePanel.getMouseY());
                break;
            }
            case 2: {
                if (this.targetHit != null) {
                    this.targetHit.getSource().invokeActions(new InteractionEvent((Object)this.targetHit.getSource(), 2002, null, this.targetHit));
                } else {
                    this.mouseReleased(interactivePanel.getMouseX(), interactivePanel.getMouseY());
                }
            }
            case 6: {
                this.targetHit = null;
                break;
            }
            case 7: {
                if (interactivePanel.getInteractive() != null) {
                    interactivePanel.setMouseCursor(Cursor.getPredefinedCursor(12));
                    break;
                }
                interactivePanel.setMouseCursor(Cursor.getPredefinedCursor(1));
            }
        }
    }

    public void mousePressed(double d, double d2) {
        this.invokeActions(10);
        this.mouseDragged(d, d2);
    }

    public void mouseDragged(double d, double d2) {
        this.posValues[0].value = d;
        this.posValues[1].value = d2;
        this.variablesChanged(this.getPosIndex(), this.posValues);
    }

    public void mouseReleased(double d, double d2) {
        this.invokeActions(0);
    }
}

