/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Component;
import java.util.ArrayList;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractionEvent;
import org.opensourcephysics.displayejs.InteractionListener;
import org.opensourcephysics.displayejs.Point3D;
import org.opensourcephysics.ejs.control.swing.ControlDrawablesParent;
import org.opensourcephysics.ejs.control.value.DoubleValue;
import org.opensourcephysics.ejs.control.value.IntegerValue;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlDrawingPanel3DNew
extends ControlDrawablesParent
implements InteractionListener {
    private static final double TO_RAD = Math.PI / 180;
    private static final int[] posIndexes = new int[]{9, 10, 11};
    private static final int[] angleIndexes = new int[]{15, 16};
    private static final int ZOOM_INDEX = 17;
    private static final int[] panIndexes = new int[]{18, 19};
    protected DrawingPanel3D drawingPanel3D;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private double minZ;
    private double maxZ;
    private DoubleValue zoomValue;
    private DoubleValue[] angleValues;
    private IntegerValue[] panValues;
    private DoubleValue[] posValues = new DoubleValue[]{new DoubleValue(0.0), new DoubleValue(0.0), new DoubleValue(0.0)};
    private static ArrayList infoList = null;

    public ControlDrawingPanel3DNew(Object object) {
        super(object);
    }

    protected Component createVisual(Object object) {
        this.drawingPanel3D = object instanceof DrawingPanel3D ? (DrawingPanel3D)object : new DrawingPanel3D();
        this.minX = this.drawingPanel3D.getXMin();
        this.maxX = this.drawingPanel3D.getXMax();
        this.minY = this.drawingPanel3D.getYMin();
        this.maxY = this.drawingPanel3D.getYMax();
        this.minZ = this.drawingPanel3D.getZMin();
        this.maxZ = this.drawingPanel3D.getZMax();
        this.angleValues = new DoubleValue[2];
        this.angleValues[0] = new DoubleValue(this.drawingPanel3D.getAlpha());
        this.angleValues[1] = new DoubleValue(this.drawingPanel3D.getBeta());
        this.zoomValue = new DoubleValue(this.drawingPanel3D.getZoom());
        this.panValues = new IntegerValue[2];
        this.panValues[0] = new IntegerValue(this.drawingPanel3D.getPan().x);
        this.panValues[1] = new IntegerValue(this.drawingPanel3D.getPan().y);
        this.drawingPanel3D.addListener(this);
        this.drawingPanel3D.render();
        return this.drawingPanel3D;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("autoscaleX");
            infoList.add("autoscaleY");
            infoList.add("autoscaleZ");
            infoList.add("minimumX");
            infoList.add("maximumX");
            infoList.add("minimumY");
            infoList.add("maximumY");
            infoList.add("minimumZ");
            infoList.add("maximumZ");
            infoList.add("x");
            infoList.add("y");
            infoList.add("z");
            infoList.add("pressaction");
            infoList.add("dragaction");
            infoList.add("action");
            infoList.add("alpha");
            infoList.add("beta");
            infoList.add("zoom");
            infoList.add("panx");
            infoList.add("pany");
            infoList.add("displayMode");
            infoList.add("decoration");
            infoList.add("square");
            infoList.add("cursorMode");
            infoList.add("showCoordinates");
            infoList.add("hideLines");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("autoscaleX")) {
            return "boolean";
        }
        if (string.equals("autoscaleY")) {
            return "boolean";
        }
        if (string.equals("autoscaleZ")) {
            return "boolean";
        }
        if (string.equals("minimumX")) {
            return "int|double";
        }
        if (string.equals("maximumX")) {
            return "int|double";
        }
        if (string.equals("minimumY")) {
            return "int|double";
        }
        if (string.equals("maximumY")) {
            return "int|double";
        }
        if (string.equals("minimumZ")) {
            return "int|double";
        }
        if (string.equals("maximumZ")) {
            return "int|double";
        }
        if (string.equals("x")) {
            return "int|double";
        }
        if (string.equals("y")) {
            return "int|double";
        }
        if (string.equals("z")) {
            return "int|double";
        }
        if (string.equals("action")) {
            return "Action CONSTANT";
        }
        if (string.equals("pressaction")) {
            return "Action CONSTANT";
        }
        if (string.equals("dragaction")) {
            return "Action CONSTANT";
        }
        if (string.equals("alpha")) {
            return "int|double BASIC";
        }
        if (string.equals("beta")) {
            return "int|double BASIC";
        }
        if (string.equals("zoom")) {
            return "int|double BASIC";
        }
        if (string.equals("panx")) {
            return "int|double BASIC HIDDEN";
        }
        if (string.equals("pany")) {
            return "int|double BASIC HIDDEN";
        }
        if (string.equals("displayMode")) {
            return "int|DisplayMode BASIC";
        }
        if (string.equals("decoration")) {
            return "int|Decoration BASIC";
        }
        if (string.equals("square")) {
            return "boolean BASIC";
        }
        if (string.equals("cursorMode")) {
            return "int|CursorMode BASIC";
        }
        if (string.equals("showCoordinates")) {
            return "boolean BASIC";
        }
        if (string.equals("hideLines")) {
            return "boolean BASIC";
        }
        return super.getPropertyInfo(string);
    }

    public Value parseConstant(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("DisplayMode") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("perspective")) {
                return new IntegerValue(10);
            }
            if (string2.equals("no_perspective")) {
                return new IntegerValue(12);
            }
            if (string2.equals("planar_xy")) {
                return new IntegerValue(0);
            }
            if (string2.equals("planar_xz")) {
                return new IntegerValue(1);
            }
            if (string2.equals("planar_yz")) {
                return new IntegerValue(2);
            }
        }
        if (string.indexOf("Decoration") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("none")) {
                return new IntegerValue(0);
            }
            if (string2.equals("cube")) {
                return new IntegerValue(2);
            }
            if (string2.equals("axes")) {
                return new IntegerValue(1);
            }
        }
        if (string.indexOf("CursorMode") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("none")) {
                return new IntegerValue(0);
            }
            if (string2.equals("cube")) {
                return new IntegerValue(2);
            }
            if (string2.equals("crosshair")) {
                return new IntegerValue(3);
            }
            if (string2.equals("xyz")) {
                return new IntegerValue(1);
            }
        }
        return super.parseConstant(string, string2);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.drawingPanel3D.setAutoscaleX(value.getBoolean());
                break;
            }
            case 1: {
                this.drawingPanel3D.setAutoscaleY(value.getBoolean());
                break;
            }
            case 2: {
                this.drawingPanel3D.setAutoscaleZ(value.getBoolean());
                break;
            }
            case 3: {
                if (value.getDouble() == this.minX) break;
                this.minX = value.getDouble();
                this.drawingPanel3D.setPreferredMinMaxX(this.minX, this.maxX);
                break;
            }
            case 4: {
                if (value.getDouble() == this.maxX) break;
                this.maxX = value.getDouble();
                this.drawingPanel3D.setPreferredMinMaxX(this.minX, this.maxX);
                break;
            }
            case 5: {
                if (value.getDouble() == this.minY) break;
                this.minY = value.getDouble();
                this.drawingPanel3D.setPreferredMinMaxY(this.minY, this.maxY);
                break;
            }
            case 6: {
                if (value.getDouble() == this.maxY) break;
                this.maxY = value.getDouble();
                this.drawingPanel3D.setPreferredMinMaxY(this.minY, this.maxY);
                break;
            }
            case 7: {
                if (value.getDouble() == this.minZ) break;
                this.minZ = value.getDouble();
                this.drawingPanel3D.setPreferredMinMaxZ(this.minZ, this.maxZ);
                break;
            }
            case 8: {
                if (value.getDouble() == this.maxZ) break;
                this.maxZ = value.getDouble();
                this.drawingPanel3D.setPreferredMinMaxZ(this.minZ, this.maxZ);
                break;
            }
            case 9: {
                this.posValues[0].value = value.getDouble();
                break;
            }
            case 10: {
                this.posValues[1].value = value.getDouble();
                break;
            }
            case 11: {
                this.posValues[2].value = value.getDouble();
                break;
            }
            case 12: {
                this.removeAction(10, this.getProperty("pressaction"));
                this.addAction(10, value.getString());
                break;
            }
            case 13: {
                this.removeAction(1, this.getProperty("dragaction"));
                this.addAction(1, value.getString());
                break;
            }
            case 14: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, value.getString());
                break;
            }
            case 15: {
                double d = value instanceof IntegerValue ? (double)value.getInteger() * (Math.PI / 180) : value.getDouble();
                if (d == this.angleValues[0].value) break;
                this.angleValues[0].value = d;
                this.drawingPanel3D.setAlpha(this.angleValues[0].value);
                break;
            }
            case 16: {
                double d = value instanceof IntegerValue ? (double)value.getInteger() * (Math.PI / 180) : value.getDouble();
                if (d == this.angleValues[1].value) break;
                this.angleValues[1].value = d;
                this.drawingPanel3D.setBeta(this.angleValues[1].value);
                break;
            }
            case 17: {
                if (value.getDouble() == this.zoomValue.value) break;
                this.zoomValue.value = value.getDouble();
                this.drawingPanel3D.setZoom(this.zoomValue.value);
                break;
            }
            case 18: {
                if (value.getInteger() == this.panValues[0].value) break;
                this.panValues[0].value = value.getInteger();
                this.drawingPanel3D.setPan(this.panValues[0].value, this.panValues[1].value);
                break;
            }
            case 19: {
                if (value.getInteger() == this.panValues[1].value) break;
                this.panValues[1].value = value.getInteger();
                this.drawingPanel3D.setPan(this.panValues[0].value, this.panValues[1].value);
                break;
            }
            case 20: {
                if (value.getInteger() == this.drawingPanel3D.getDisplayMode()) break;
                this.drawingPanel3D.setDisplayMode(value.getInteger());
                break;
            }
            case 21: {
                if (value.getInteger() == this.drawingPanel3D.getDecorationType()) break;
                this.drawingPanel3D.setDecorationType(value.getInteger());
                break;
            }
            case 22: {
                if (value.getBoolean() == this.drawingPanel3D.isSquareAspect()) break;
                this.drawingPanel3D.setSquareAspect(value.getBoolean());
                break;
            }
            case 23: {
                if (value.getInteger() == this.drawingPanel3D.getCursorMode()) break;
                this.drawingPanel3D.setCursorMode(value.getInteger());
                break;
            }
            case 24: {
                this.drawingPanel3D.setShowCoordinates(value.getBoolean());
                break;
            }
            case 25: {
                this.drawingPanel3D.setRemoveHiddenLines(value.getBoolean());
                break;
            }
            default: {
                super.setValue(n - 26, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.drawingPanel3D.setAutoscaleX(false);
                break;
            }
            case 1: {
                this.drawingPanel3D.setAutoscaleY(false);
                break;
            }
            case 2: {
                this.drawingPanel3D.setAutoscaleZ(false);
                break;
            }
            case 3: {
                this.minX = 0.0;
                this.drawingPanel3D.setPreferredMinMaxX(0.0, this.maxX);
                break;
            }
            case 4: {
                this.maxX = 1.0;
                this.drawingPanel3D.setPreferredMinMaxX(this.minX, 1.0);
                break;
            }
            case 5: {
                this.minY = 0.0;
                this.drawingPanel3D.setPreferredMinMaxY(0.0, this.maxY);
                break;
            }
            case 6: {
                this.maxY = 1.0;
                this.drawingPanel3D.setPreferredMinMaxY(this.minY, 1.0);
                break;
            }
            case 7: {
                this.minZ = 0.0;
                this.drawingPanel3D.setPreferredMinMaxZ(0.0, this.maxZ);
                break;
            }
            case 8: {
                this.maxZ = 1.0;
                this.drawingPanel3D.setPreferredMinMaxZ(this.minZ, 1.0);
                break;
            }
            case 9: {
                this.posValues[0].value = (this.minX + this.maxX) / 2.0;
                break;
            }
            case 10: {
                this.posValues[1].value = (this.minY + this.maxY) / 2.0;
                break;
            }
            case 11: {
                this.posValues[2].value = (this.minZ + this.maxZ) / 2.0;
                break;
            }
            case 12: {
                this.removeAction(10, this.getProperty("pressaction"));
                break;
            }
            case 13: {
                this.removeAction(1, this.getProperty("dragaction"));
                break;
            }
            case 14: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            case 15: {
                this.angleValues[0].value = 0.0;
                this.drawingPanel3D.setAlpha(0.0);
                break;
            }
            case 16: {
                this.angleValues[1].value = 0.0;
                this.drawingPanel3D.setBeta(0.0);
                break;
            }
            case 17: {
                this.zoomValue.value = 1.0;
                this.drawingPanel3D.setZoom(1.0);
                break;
            }
            case 18: {
                this.panValues[0].value = 0;
                this.drawingPanel3D.setPan(0, this.panValues[1].value);
                break;
            }
            case 19: {
                this.panValues[1].value = 0;
                this.drawingPanel3D.setPan(this.panValues[0].value, 0);
                break;
            }
            case 20: {
                this.drawingPanel3D.setDisplayMode(10);
                break;
            }
            case 21: {
                this.drawingPanel3D.setDecorationType(2);
                break;
            }
            case 22: {
                this.drawingPanel3D.setSquareAspect(true);
                break;
            }
            case 23: {
                this.drawingPanel3D.setCursorMode(3);
                break;
            }
            case 24: {
                this.drawingPanel3D.setShowCoordinates(true);
                break;
            }
            case 25: {
                this.drawingPanel3D.setRemoveHiddenLines(true);
                break;
            }
            default: {
                super.setDefaultValue(n - 26);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return null;
            }
            case 9: {
                return this.posValues[0];
            }
            case 10: {
                return this.posValues[1];
            }
            case 11: {
                return this.posValues[2];
            }
            case 15: {
                return this.angleValues[0];
            }
            case 16: {
                return this.angleValues[1];
            }
            case 17: {
                return this.zoomValue;
            }
            case 18: {
                return this.panValues[0];
            }
            case 19: {
                return this.panValues[1];
            }
        }
        return super.getValue(n - 26);
    }

    public void interactionPerformed(InteractionEvent interactionEvent) {
        if (interactionEvent.getTarget() == null) {
            if (interactionEvent.getID() == 2001) {
                if (this.angleValues[0].value != this.drawingPanel3D.getAlpha() || this.angleValues[1].value != this.drawingPanel3D.getBeta()) {
                    this.angleValues[0].value = this.drawingPanel3D.getAlpha();
                    this.angleValues[1].value = this.drawingPanel3D.getBeta();
                    this.variablesChanged(angleIndexes, this.angleValues);
                }
                if (this.zoomValue.value != this.drawingPanel3D.getZoom()) {
                    this.zoomValue.value = this.drawingPanel3D.getZoom();
                    this.variableChanged(17, this.zoomValue);
                }
                if (this.panValues[0].value != this.drawingPanel3D.getPan().x || this.panValues[1].value != this.drawingPanel3D.getPan().y) {
                    this.panValues[0].value = this.drawingPanel3D.getPan().x;
                    this.panValues[1].value = this.drawingPanel3D.getPan().y;
                    this.variablesChanged(panIndexes, this.panValues);
                }
            }
            return;
        }
        if (!(interactionEvent.getTarget() instanceof Point3D)) {
            return;
        }
        Point3D point3D = (Point3D)interactionEvent.getTarget();
        switch (interactionEvent.getID()) {
            case 2000: {
                this.invokeActions(10);
            }
            case 2001: {
                this.posValues[0].value = point3D.x;
                this.posValues[1].value = point3D.y;
                this.posValues[2].value = point3D.z;
                this.variablesChanged(posIndexes, this.posValues);
                break;
            }
            case 2002: {
                this.invokeActions(0);
            }
        }
    }
}

